/*
 * Decompiled with CFR 0.152.
 */
package com.sun.management.snmp.usm.usmmib;

import com.sun.jdmk.internal.ClassLogger;
import com.sun.management.internal.snmp.SnmpTools;
import com.sun.management.snmp.SnmpEngine;
import com.sun.management.snmp.SnmpOid;
import com.sun.management.snmp.SnmpStatusException;
import com.sun.management.snmp.agent.SnmpMib;
import com.sun.management.snmp.usm.SnmpUsmAlgorithm;
import com.sun.management.snmp.usm.SnmpUsmException;
import com.sun.management.snmp.usm.SnmpUsmLcd;
import com.sun.management.snmp.usm.SnmpUsmSecureUser;
import com.sun.management.snmp.usm.usmmib.EnumUsmUserStatus;
import com.sun.management.snmp.usm.usmmib.EnumUsmUserStorageType;
import com.sun.management.snmp.usm.usmmib.TableUsmUserTableImpl;
import com.sun.management.snmp.usm.usmmib.UsmUserEntry;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;

public class UsmUserEntryImpl
extends UsmUserEntry {
    private static final long serialVersionUID = 7849396415731734840L;
    SnmpUsmSecureUser user = null;
    SnmpUsmLcd lcd = null;
    UsmUserEntryImpl original = null;
    TableUsmUserTableImpl table = null;
    private String dbgTag = "UsmUserEntryImpl";
    SnmpOid oid = null;
    private String prefix = null;
    private static final ClassLogger logger = new ClassLogger("com.sun.jdmk.snmp.adaptor", "UsmUserEntryImpl");

    public UsmUserEntryImpl(SnmpEngine engine, SnmpMib mib, SnmpUsmLcd lcd, SnmpUsmSecureUser user, TableUsmUserTableImpl table) {
        super(mib);
        this.prefix = engine.getEngineId().toString() + "/UsmUserTable:";
        this.user = user;
        this.table = table;
        this.UsmUserAuthKeyChange = null;
        this.UsmUserPrivKeyChange = null;
        this.lcd = lcd;
    }

    synchronized void setUser(SnmpUsmSecureUser user) {
        this.user = user;
    }

    synchronized SnmpUsmSecureUser getUser() {
        return this.user;
    }

    private String convertAuthAlgorithm(SnmpUsmAlgorithm algo) {
        if ((this.getUser().getSecurityLevel() & 1) == 0) {
            return "1.3.6.1.6.3.10.1.1.1";
        }
        return this.getUser().getAuthPair().algo.getOid();
    }

    private String convertPrivAlgorithm() {
        if ((this.getUser().getSecurityLevel() & 2) == 0) {
            return "1.3.6.1.6.3.10.1.2.1";
        }
        return this.getUser().getPrivPair().algo.getOid();
    }

    protected ObjectName createObjectName() throws MalformedObjectNameException {
        String engine = this.user.getEngineId().toString();
        return new ObjectName(this.prefix + "name=" + this.user.getName());
    }

    public void addInMBeanServer(MBeanServer server) {
        block2: {
            try {
                server.registerMBean(this, this.createObjectName());
            }
            catch (Exception e) {
                if (!logger.finerOn()) break block2;
                logger.finer("addInMBeanServer", e.toString());
            }
        }
    }

    public void removeFromMBeanServer(MBeanServer server) {
        block2: {
            try {
                server.unregisterMBean(this.createObjectName());
            }
            catch (Exception e) {
                if (!logger.finerOn()) break block2;
                logger.finer("addInMBeanServer", e.toString());
            }
        }
    }

    public String getUsmUserSecurityName() throws SnmpStatusException {
        return this.getUser().getSecurityName();
    }

    public Byte[] getUsmUserPrivKeyChange() throws SnmpStatusException {
        return new Byte[0];
    }

    public void checkUsmUserPrivKeyChange(Byte[] x) throws SnmpStatusException {
        if ((this.getUser().getSecurityLevel() & 2) == 0) {
            if (logger.finestOn()) {
                logger.finest("checkUsmUserPrivKeyChange", "No privacy, return.");
            }
            return;
        }
        int expectedSize = this.user.getPrivPair().algo.getDeltaSize();
        if (logger.finestOn()) {
            logger.finest("checkUsmUserPrivKeyChange", "Expected delta and random size: " + expectedSize);
        }
        if (x.length != expectedSize) {
            if (logger.finestOn()) {
                logger.finest("checkUsmUserPrivKeyChange", "Received delta is wrong: " + x.length);
            }
            throw new SnmpStatusException(10);
        }
        if (logger.finestOn()) {
            logger.finest("checkUsmUserPrivKeyChange", "check OK");
        }
    }

    public void setUsmUserPrivKeyChange(Byte[] x) throws SnmpStatusException {
        int i;
        Byte[] random;
        if ((this.getUser().getSecurityLevel() & 2) == 0) {
            if (logger.finestOn()) {
                logger.finest("setUsmUserPrivKeyChange", "No privacy, return.");
            }
            return;
        }
        if (logger.finestOn()) {
            logger.finest("setUsmUserPrivKeyChange", "Will do priv key change.");
        }
        if ((random = this.getUsmUserPublic()) == null) {
            if (logger.finestOn()) {
                logger.finest("checkUsmUserPrivKeyChange", "Random is null can't process key change");
            }
            throw new SnmpStatusException(10);
        }
        int expectedSize = this.user.getPrivPair().algo.getDeltaSize();
        if (random.length != expectedSize) {
            if (logger.finestOn()) {
                logger.finest("checkUsmUserPrivKeyChange", "Random is wrong: " + random.length);
            }
            throw new SnmpStatusException(10);
        }
        if (logger.finestOn()) {
            logger.finest("setUsmUserPrivKeyChange", "Random is : " + random);
        }
        byte[] res = new byte[x.length + random.length];
        for (i = 0; i < random.length; ++i) {
            res[i] = random[i];
        }
        if (logger.finestOn()) {
            logger.finest("setUsmUserPrivKeyChange", "Random is : " + SnmpTools.binary2ascii(res, random.length));
        }
        for (i = 0; i < x.length; ++i) {
            res[i + random.length] = x[i];
        }
        this.lcd.setUserPrivKeyChange(this.user, res);
        super.setUsmUserPrivKeyChange(x);
    }

    public Byte[] getUsmUserAuthKeyChange() throws SnmpStatusException {
        return new Byte[0];
    }

    public void checkUsmUserAuthKeyChange(Byte[] x) throws SnmpStatusException {
        if ((this.getUser().getSecurityLevel() & 1) == 0) {
            if (logger.finestOn()) {
                logger.finest("checkUsmUserAuthKeyChange", "No authentication, return.");
            }
            return;
        }
        int expectedSize = this.user.getAuthPair().algo.getDeltaSize();
        if (logger.finestOn()) {
            logger.finest("checkUsmUserAuthKeyChange", "Expected delta and random size: " + expectedSize);
        }
        if (x.length != expectedSize) {
            if (logger.finestOn()) {
                logger.finest("checkUsmUserAuthKeyChange", "Received delta is wrong: " + x.length);
            }
            throw new SnmpStatusException(10);
        }
        if (logger.finestOn()) {
            logger.finest("checkUsmUserAuthKeyChange", "check OK");
        }
    }

    public void setUsmUserAuthKeyChange(Byte[] x) throws SnmpStatusException {
        int i;
        Byte[] random;
        if ((this.getUser().getSecurityLevel() & 1) == 0) {
            if (logger.finestOn()) {
                logger.finest("setUsmUserAuthKeyChange", "No authentication, return.");
            }
            return;
        }
        if (logger.finestOn()) {
            logger.finest("setUsmUserAuthKeyChange", "Will do auth key change.");
        }
        if ((random = this.getUsmUserPublic()) == null) {
            if (logger.finestOn()) {
                logger.finest("setUsmUserAuthKeyChange", "Random is null can't process key change");
            }
            throw new SnmpStatusException(10);
        }
        int expectedSize = this.user.getAuthPair().algo.getDeltaSize();
        if (random.length != expectedSize) {
            if (logger.finestOn()) {
                logger.finest("setUsmUserAuthKeyChange", "Random is wrong: " + random.length);
            }
            throw new SnmpStatusException(10);
        }
        if (logger.finestOn()) {
            logger.finest("setUsmUserAuthKeyChange", "Random is : " + random);
        }
        byte[] res = new byte[x.length + random.length];
        for (i = 0; i < random.length; ++i) {
            res[i] = random[i];
        }
        for (i = 0; i < x.length; ++i) {
            res[i + random.length] = x[i];
        }
        if (logger.finestOn()) {
            logger.finest("setUsmUserAuthKeyChange", "Received key change : " + SnmpTools.binary2ascii(res));
        }
        this.lcd.setUserAuthKeyChange(this.user, res);
        super.setUsmUserAuthKeyChange(x);
    }

    public void setUsmUserOwnPrivKeyChange(Byte[] x) throws SnmpStatusException {
        this.setUsmUserPrivKeyChange(x);
    }

    public Byte[] getUsmUserOwnPrivKeyChange() throws SnmpStatusException {
        return new Byte[0];
    }

    public Byte[] getUsmUserOwnAuthKeyChange() throws SnmpStatusException {
        return new Byte[0];
    }

    public void setUsmUserOwnAuthKeyChange(Byte[] x) throws SnmpStatusException {
        this.setUsmUserAuthKeyChange(x);
    }

    public String getUsmUserPrivProtocol() throws SnmpStatusException {
        return this.convertPrivAlgorithm();
    }

    public void setUsmUserPrivProtocol(String x) throws SnmpStatusException {
        super.setUsmUserPrivProtocol(x);
        if (logger.finestOn()) {
            logger.finest("setUsmUserPrivProtocol", "priv protocol : " + x);
        }
        this.user.setPrivAlgorithm(x);
    }

    public void checkUsmUserPrivProtocol(String x) throws SnmpStatusException {
        if (logger.finestOn()) {
            logger.finest("checkUsmUserPrivProtocol", "priv protocol : " + x);
        }
        if (x.equals("1.3.6.1.6.3.10.1.2.1")) {
            if (logger.finestOn()) {
                logger.finest("checkUsmUserPrivProtocol", "priv protocol will be set to no protocol");
            }
            return;
        }
        if ((this.getUser().getSecurityLevel() & 1) == 0) {
            if (logger.finestOn()) {
                logger.finest("checkUsmUserPrivProtocol", "Unsupported security level. Security level is : " + (this.getUser().getSecurityLevel() & 2));
            }
            throw new SnmpStatusException(12);
        }
        if (this.getUsmUserStatus().intValue() == 1) {
            if (logger.finestOn()) {
                logger.finest("checkUsmUserPrivProtocol", "Status already active, failed");
            }
            throw new SnmpStatusException(12);
        }
        if (this.lcd.getAlgorithmManager().getAlgorithm(x) == null) {
            if (logger.finestOn()) {
                logger.finest("checkUsmUserPrivProtocol", "Unknown algo : " + x);
            }
            throw new SnmpStatusException(10);
        }
    }

    public String getUsmUserAuthProtocol() throws SnmpStatusException {
        return this.convertAuthAlgorithm(this.user.getAuthPair().algo);
    }

    public void setUsmUserAuthProtocol(String x) throws SnmpStatusException {
        super.setUsmUserAuthProtocol(x);
        if (logger.finestOn()) {
            logger.finest("setUsmUserAuthProtocol", "auth protocol : " + x);
        }
        this.user.setAuthAlgorithm(x);
    }

    public void checkUsmUserAuthProtocol(String x) throws SnmpStatusException {
        if (logger.finestOn()) {
            logger.finest("checkUsmUserAuthProtocol", "auth protocol : " + x);
        }
        if (x.equals("1.3.6.1.6.3.10.1.1.1")) {
            if ((this.getUser().getSecurityLevel() & 2) != 0) {
                if (logger.finestOn()) {
                    logger.finest("checkUsmUserAuthProtocol", "Unsupported security level. Security level is : " + (this.getUser().getSecurityLevel() & 2));
                }
                throw new SnmpStatusException(12);
            }
            if (logger.finestOn()) {
                logger.finest("checkUsmUserAuthProtocol", "auth protocol is no protocol.");
            }
            return;
        }
        if (this.getUsmUserStatus().intValue() == 1) {
            if (logger.finestOn()) {
                logger.finest("checkUsmUserAuthProtocol", "auth protocol already active. Failed");
            }
            throw new SnmpStatusException(12);
        }
        if (this.lcd.getAlgorithmManager().getAlgorithm(x) == null) {
            if (logger.finestOn()) {
                logger.finest("checkUsmUserAuthProtocol", "Unknown algo : " + x);
            }
            throw new SnmpStatusException(10);
        }
    }

    public EnumUsmUserStorageType getUsmUserStorageType() throws SnmpStatusException {
        EnumUsmUserStorageType e = new EnumUsmUserStorageType(this.user.getStorageType());
        return e;
    }

    public void setUsmUserStorageType(EnumUsmUserStorageType x) throws SnmpStatusException {
        super.setUsmUserStorageType(x);
        if (logger.finestOn()) {
            logger.finest("setUsmUserStorageType", "Enum : " + x.toString());
        }
        this.user.setStorageType(x.intValue());
    }

    public void checkUsmUserStorageType(EnumUsmUserStorageType x) throws SnmpStatusException {
        if (x.intValue() != 3 && x.intValue() != 2) {
            if (logger.finestOn()) {
                logger.finest("checkUsmUserStorageType", "Wrong storage type :" + x.intValue());
            }
            throw new SnmpStatusException(10);
        }
        if (this.lcd.getStorageType() < x.intValue()) {
            if (logger.finestOn()) {
                logger.finest("checkUsmUserStorageType", "Unsupported storage type :" + x.intValue());
            }
            throw new SnmpStatusException(12);
        }
    }

    public Byte[] getUsmUserEngineID() throws SnmpStatusException {
        byte[] engineid = this.user.getEngineId().getBytes();
        Byte[] ret = new Byte[engineid.length];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = new Byte(engineid[i]);
        }
        return ret;
    }

    public String getUsmUserName() throws SnmpStatusException {
        return this.user.getName();
    }

    public String getUsmUserCloneFrom() throws SnmpStatusException {
        return "0.0";
    }

    public void checkUsmUserCloneFrom(String x) throws SnmpStatusException {
        if (this.original != null) {
            return;
        }
        try {
            this.original = this.table.getCloneFromUser(x);
        }
        catch (SnmpStatusException e) {
            if (logger.finestOn()) {
                logger.finest("setUsmUserCloneFrom", "Exception : " + e);
            }
            throw new SnmpStatusException(18);
        }
        if (this.original == null) {
            throw new SnmpStatusException(18);
        }
        this.UsmUserCloneFrom = x;
        EnumUsmUserStatus en = this.original.getUsmUserStatus();
        if (en.intValue() != 1) {
            throw new SnmpStatusException(18);
        }
    }

    public void setUsmUserCloneFrom(String x) throws SnmpStatusException {
        if (this.original == null) {
            if (logger.finestOn()) {
                logger.finest("setUsmUserCloneFrom", "original == null");
            }
            throw new SnmpStatusException(18);
        }
        SnmpUsmSecureUser clone = this.original.getUser();
        this.user.cloneAuthPair(clone.getAuthPair());
        this.user.clonePrivPair(clone.getPrivPair());
        super.setUsmUserCloneFrom(x);
    }

    public void setUsmUserStatus(EnumUsmUserStatus x) throws SnmpStatusException {
        if (this.getUsmUserStatus().intValue() == 1) {
            if (logger.finestOn()) {
                logger.finest("setUsmUserStatus", "Already active. Return");
            }
            return;
        }
        if (this.user.isTemplate()) {
            super.setUsmUserStatus(x);
            return;
        }
        if (logger.finestOn()) {
            logger.finest("setUsmUserStatus", "Setting status to : " + x.intValue());
        }
        if (x.intValue() == 1) {
            try {
                this.lcd.addUser(this.user, false);
            }
            catch (SnmpUsmException e) {
                if (logger.finestOn()) {
                    logger.finest("setUsmUserStatus", " error when adding a user : " + e);
                }
                throw new SnmpStatusException(15);
            }
        }
        super.setUsmUserStatus(x);
    }

    public void checkUsmUserStatus(EnumUsmUserStatus x) throws SnmpStatusException {
        if (this.getUsmUserStatus().intValue() == 1) {
            if (logger.finestOn()) {
                logger.finest("checkUsmUserStatus", "Already active. Return");
            }
            return;
        }
        if (x.intValue() == 1) {
            if (this.original == null) {
                if (logger.finestOn()) {
                    logger.finest("checkUsmUserStatus", "cloneFrom not done. Can't switch to active state.");
                }
                throw new SnmpStatusException(12);
            }
            if (this.user.getAuthPair().algo != null && this.user.getAuthPair().key != null && this.UsmUserAuthKeyChange == null) {
                if (logger.finestOn()) {
                    logger.finest("checkUsmUserStatus", "Auth key change not done. Can't switch to active state.");
                }
                throw new SnmpStatusException(12);
            }
            if (this.user.getPrivPair().algo != null && this.user.getPrivPair().key != null && this.UsmUserPrivKeyChange == null) {
                if (logger.finestOn()) {
                    logger.finest("checkUsmUserStatus", "Priv key change not done. Can't switch to active state.");
                }
                throw new SnmpStatusException(12);
            }
        }
    }
}

