package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.cds.types.rev191024;
import java.lang.Class;
import java.lang.Override;
import java.util.NoSuchElementException;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.svc.v1.urn.opendaylight.params.xml.ns.yang.controller.cds.types.rev191024.YangModuleInfoImpl;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.QName;

/**
 * Identifier of a particular client.
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>odl-controller-cds-types</b>
 * <pre>
 * grouping client-identifier {
 *   uses frontend-identifier;
 *   leaf generation {
 *     type client-generation;
 *   }
 * }
 * </pre>
 *
 */
@Generated("mdsal-binding-generator")
public interface ClientIdentifier
    extends
    DataObject,
    FrontendIdentifier
{



    /**
     * YANG identifier of the statement represented by this class.
     */
    public static final @NonNull QName QNAME = YangModuleInfoImpl.qnameOf("client-identifier");

    @Override
    Class<? extends ClientIdentifier> implementedInterface();
    
    /**
     * Return generation, or {@code null} if it is not present.
     *
     * @return {@code ClientGeneration} generation, or {@code null} if it is not present.
     *
     */
    ClientGeneration getGeneration();
    
    /**
     * Return generation, guaranteed to be non-null.
     *
     * @return {@code ClientGeneration} generation, guaranteed to be non-null.
     * @throws NoSuchElementException if generation is not present
     *
     */
    default @NonNull ClientGeneration requireGeneration() {
        return CodeHelpers.require(getGeneration(), "generation");
    }

}

