package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.cds.types.rev191024;
import java.lang.Class;
import java.lang.Override;
import java.util.NoSuchElementException;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.svc.v1.urn.opendaylight.params.xml.ns.yang.controller.cds.types.rev191024.YangModuleInfoImpl;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.QName;

/**
 * Identifier of a particular frontend.
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>odl-controller-cds-types</b>
 * <pre>
 * grouping frontend-identifier {
 *   leaf member {
 *     type member-name;
 *   }
 *   leaf type {
 *     type frontend-type;
 *   }
 * }
 * </pre>
 *
 */
@Generated("mdsal-binding-generator")
public interface FrontendIdentifier
    extends
    DataObject
{



    /**
     * YANG identifier of the statement represented by this class.
     */
    public static final @NonNull QName QNAME = YangModuleInfoImpl.qnameOf("frontend-identifier");

    @Override
    Class<? extends FrontendIdentifier> implementedInterface();
    
    /**
     * Return member, or {@code null} if it is not present.
     *
     * @return {@code MemberName} member, or {@code null} if it is not present.
     *
     */
    MemberName getMember();
    
    /**
     * Return member, guaranteed to be non-null.
     *
     * @return {@code MemberName} member, guaranteed to be non-null.
     * @throws NoSuchElementException if member is not present
     *
     */
    default @NonNull MemberName requireMember() {
        return CodeHelpers.require(getMember(), "member");
    }
    
    /**
     * Return type, or {@code null} if it is not present.
     *
     * @return {@code FrontendType} type, or {@code null} if it is not present.
     *
     */
    FrontendType getType();
    
    /**
     * Return type, guaranteed to be non-null.
     *
     * @return {@code FrontendType} type, guaranteed to be non-null.
     * @throws NoSuchElementException if type is not present
     *
     */
    default @NonNull FrontendType requireType() {
        return CodeHelpers.require(getType(), "type");
    }

}

