/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.access;

import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.controller.cluster.access.ABIVersion;

public abstract class AbstractVersionException
extends Exception {
    private static final long serialVersionUID = 1L;
    private final @NonNull ABIVersion closestVersion;
    private final int version;

    AbstractVersionException(String message, short version, ABIVersion closestVersion) {
        super(message);
        this.closestVersion = Objects.requireNonNull(closestVersion);
        this.version = Short.toUnsignedInt(version);
    }

    public final int version() {
        return this.version;
    }

    public final @NonNull ABIVersion closestVersion() {
        return this.closestVersion;
    }
}

