/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.access.commands;

import akka.actor.ActorRef;
import com.google.common.base.MoreObjects;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.controller.cluster.access.ABIVersion;
import org.opendaylight.controller.cluster.access.commands.AbstractReadTransactionRequest;
import org.opendaylight.controller.cluster.access.concepts.Message;
import org.opendaylight.controller.cluster.access.concepts.TransactionIdentifier;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.codec.binfmt.NormalizedNodeDataInput;
import org.opendaylight.yangtools.yang.data.codec.binfmt.NormalizedNodeDataOutput;

public abstract class AbstractReadPathTransactionRequest<T extends AbstractReadPathTransactionRequest<T>>
extends AbstractReadTransactionRequest<T> {
    private static final long serialVersionUID = 1L;
    private final @NonNull YangInstanceIdentifier path;

    AbstractReadPathTransactionRequest(TransactionIdentifier identifier, long sequence, ActorRef replyTo, YangInstanceIdentifier path, boolean snapshotOnly) {
        super(identifier, sequence, replyTo, snapshotOnly);
        this.path = Objects.requireNonNull(path);
    }

    AbstractReadPathTransactionRequest(T request, ABIVersion version) {
        super(request, version);
        this.path = ((AbstractReadPathTransactionRequest)request).getPath();
    }

    public final @NonNull YangInstanceIdentifier getPath() {
        return this.path;
    }

    @Override
    protected MoreObjects.ToStringHelper addToStringAttributes(MoreObjects.ToStringHelper toStringHelper) {
        return super.addToStringAttributes(toStringHelper).add("path", (Object)this.path);
    }

    @Override
    protected abstract SerialForm<T> externalizableProxy(ABIVersion var1);

    static interface SerialForm<T extends AbstractReadPathTransactionRequest<T>>
    extends AbstractReadTransactionRequest.SerialForm<T> {
        @Override
        default public T readExternal(ObjectInput in, TransactionIdentifier target, long sequence, ActorRef replyTo, boolean snapshotOnly) throws IOException {
            return this.readExternal(in, target, sequence, replyTo, snapshotOnly, NormalizedNodeDataInput.newDataInput((DataInput)in).readYangInstanceIdentifier());
        }

        public @NonNull T readExternal(@NonNull ObjectInput var1, @NonNull TransactionIdentifier var2, long var3, @NonNull ActorRef var5, boolean var6, @NonNull YangInstanceIdentifier var7) throws IOException;

        @Override
        default public void writeExternal(ObjectOutput out, T msg) throws IOException {
            AbstractReadTransactionRequest.SerialForm.super.writeExternal(out, msg);
            try (NormalizedNodeDataOutput nnout = ((Message)msg).getVersion().getStreamVersion().newDataOutput((DataOutput)out);){
                nnout.writeYangInstanceIdentifier(((AbstractReadPathTransactionRequest)msg).getPath());
            }
        }
    }
}

