/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.access.commands;

import akka.actor.ActorRef;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamException;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.opendaylight.controller.cluster.access.ABIVersion;
import org.opendaylight.controller.cluster.access.commands.MTR;
import org.opendaylight.controller.cluster.access.commands.PersistenceProtocol;
import org.opendaylight.controller.cluster.access.commands.TransactionModification;
import org.opendaylight.controller.cluster.access.commands.TransactionRequest;
import org.opendaylight.controller.cluster.access.concepts.SliceableMessage;
import org.opendaylight.controller.cluster.access.concepts.TransactionIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.stream.ReusableStreamReceiver;
import org.opendaylight.yangtools.yang.data.codec.binfmt.NormalizedNodeDataInput;
import org.opendaylight.yangtools.yang.data.codec.binfmt.NormalizedNodeDataOutput;
import org.opendaylight.yangtools.yang.data.impl.schema.ReusableImmutableNormalizedNodeStreamWriter;

public final class ModifyTransactionRequest
extends TransactionRequest<ModifyTransactionRequest>
implements SliceableMessage {
    private static final long serialVersionUID = 1L;
    private final List<TransactionModification> modifications;
    private final PersistenceProtocol protocol;

    private ModifyTransactionRequest(ModifyTransactionRequest request, ABIVersion version) {
        super(request, version);
        this.modifications = request.modifications;
        this.protocol = request.protocol;
    }

    ModifyTransactionRequest(TransactionIdentifier target, long sequence, ActorRef replyTo, List<TransactionModification> modifications, PersistenceProtocol protocol) {
        super(target, sequence, replyTo);
        this.modifications = ImmutableList.copyOf(modifications);
        this.protocol = protocol;
    }

    public Optional<PersistenceProtocol> getPersistenceProtocol() {
        return Optional.ofNullable(this.protocol);
    }

    public List<TransactionModification> getModifications() {
        return this.modifications;
    }

    @Override
    protected MoreObjects.ToStringHelper addToStringAttributes(MoreObjects.ToStringHelper toStringHelper) {
        return super.addToStringAttributes(toStringHelper).add("modifications", this.modifications.size()).add("protocol", (Object)this.protocol);
    }

    @Override
    protected SerialForm externalizableProxy(ABIVersion version) {
        return new MTR(this);
    }

    @Override
    protected ModifyTransactionRequest cloneAsVersion(ABIVersion version) {
        return new ModifyTransactionRequest(this, version);
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        this.throwNSE();
    }

    private void readObjectNoData() throws ObjectStreamException {
        this.throwNSE();
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        this.throwNSE();
    }

    static interface SerialForm
    extends TransactionRequest.SerialForm<ModifyTransactionRequest> {
        @Override
        default public ModifyTransactionRequest readExternal(ObjectInput in, TransactionIdentifier target, long sequence, ActorRef replyTo) throws IOException {
            Object modifications;
            Optional<PersistenceProtocol> protocol = Optional.ofNullable(PersistenceProtocol.readFrom(in));
            int size = in.readInt();
            if (size != 0) {
                modifications = new ArrayList(size);
                NormalizedNodeDataInput nnin = NormalizedNodeDataInput.newDataInput((DataInput)in);
                ReusableImmutableNormalizedNodeStreamWriter writer = ReusableImmutableNormalizedNodeStreamWriter.create();
                for (int i = 0; i < size; ++i) {
                    modifications.add(TransactionModification.readFrom(nnin, (ReusableStreamReceiver)writer));
                }
            } else {
                modifications = ImmutableList.of();
            }
            return new ModifyTransactionRequest(target, sequence, replyTo, (List<TransactionModification>)modifications, protocol.orElse(null));
        }

        @Override
        default public void writeExternal(ObjectOutput out, ModifyTransactionRequest msg) throws IOException {
            TransactionRequest.SerialForm.super.writeExternal(out, msg);
            out.writeByte(PersistenceProtocol.byteValue(msg.getPersistenceProtocol().orElse(null)));
            List<TransactionModification> modifications = msg.getModifications();
            out.writeInt(modifications.size());
            if (!modifications.isEmpty()) {
                try (NormalizedNodeDataOutput nnout = msg.getVersion().getStreamVersion().newDataOutput((DataOutput)out);){
                    for (TransactionModification op : modifications) {
                        op.writeTo(nnout);
                    }
                }
            }
        }
    }
}

