/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.access.concepts;

import com.google.common.base.MoreObjects;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.controller.cluster.access.concepts.Message;
import org.opendaylight.yangtools.concepts.Immutable;
import org.opendaylight.yangtools.concepts.WritableObjects;

public abstract class Envelope<T extends Message<?, ?>>
implements Immutable,
Serializable {
    private static final long serialVersionUID = 1L;
    private final @NonNull T message;
    private final long txSequence;
    private final long sessionId;

    Envelope(T message, long sessionId, long txSequence) {
        this.message = (Message)Objects.requireNonNull(message);
        this.sessionId = sessionId;
        this.txSequence = txSequence;
    }

    public @NonNull T getMessage() {
        return this.message;
    }

    public long getTxSequence() {
        return this.txSequence;
    }

    public long getSessionId() {
        return this.sessionId;
    }

    public String toString() {
        return MoreObjects.toStringHelper(Envelope.class).add("sessionId", (Object)Long.toHexString(this.sessionId)).add("txSequence", (Object)Long.toHexString(this.txSequence)).add("message", this.message).toString();
    }

    final Object writeReplace() {
        return this.createProxy();
    }

    abstract @NonNull SerialForm<T, ?> createProxy();

    static interface SerialForm<T extends Message<?, ?>, E extends Envelope<T>>
    extends Externalizable {
        public @NonNull E envelope();

        public void setEnvelope(@NonNull E var1);

        public Object readResolve();

        @Override
        default public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            byte header = WritableObjects.readLongHeader((DataInput)in);
            long sessionId = WritableObjects.readFirstLong((DataInput)in, (byte)header);
            long txSequence = WritableObjects.readSecondLong((DataInput)in, (byte)header);
            Message message = (Message)in.readObject();
            this.setEnvelope(this.readExternal(in, sessionId, txSequence, message));
        }

        public E readExternal(ObjectInput var1, long var2, long var4, T var6) throws IOException;

        @Override
        default public void writeExternal(ObjectOutput out) throws IOException {
            this.writeExternal(out, this.envelope());
        }

        default public void writeExternal(ObjectOutput out, @NonNull E envelope) throws IOException {
            WritableObjects.writeLongs((DataOutput)out, (long)((Envelope)envelope).getSessionId(), (long)((Envelope)envelope).getTxSequence());
            out.writeObject(((Envelope)envelope).getMessage());
        }
    }
}

