/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.access.client;

import java.util.Objects;
import org.opendaylight.controller.cluster.access.client.AbstractReceivingClientConnection;
import org.opendaylight.controller.cluster.access.client.ConnectionEntry;

public abstract class ReconnectForwarder {
    private final AbstractReceivingClientConnection<?> successor;

    protected ReconnectForwarder(AbstractReceivingClientConnection<?> successor) {
        this.successor = Objects.requireNonNull(successor);
    }

    protected final void sendToSuccessor(ConnectionEntry entry) {
        this.successor.sendRequest(entry.getRequest(), entry.getCallback());
    }

    protected final void replayToSuccessor(ConnectionEntry entry) {
        this.successor.enqueueRequest(entry.getRequest(), entry.getCallback(), entry.getEnqueuedTicks());
    }

    protected abstract void forwardEntry(ConnectionEntry var1, long var2);

    protected abstract void replayEntry(ConnectionEntry var1, long var2);

    final AbstractReceivingClientConnection<?> successor() {
        return this.successor;
    }
}

