package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.entity.owners.norev;
import java.lang.Class;
import java.lang.Override;
import java.util.List;
import java.util.NoSuchElementException;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yang.svc.v1.urn.opendaylight.params.xml.ns.yang.controller.entity.owners.norev.YangModuleInfoImpl;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.QName;

/**
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>odl-entity-owners</b>
 * <pre>
 * grouping candidates {
 *   leaf-list candidate-nodes {
 *     type node-name;
 *     ordered-by user;
 *     min-elements 1;
 *   }
 * }
 * </pre>
 *
 */
@Generated("mdsal-binding-generator")
public interface Candidates
    extends
    DataObject
{



    /**
     * YANG identifier of the statement represented by this class.
     */
    public static final @NonNull QName QNAME = YangModuleInfoImpl.qnameOf("candidates");

    @Override
    Class<? extends Candidates> implementedInterface();
    
    /**
     * Return candidateNodes, or {@code null} if it is not present.
     *
     * @return {@code List<NodeName>} candidateNodes, or {@code null} if it is not present.
     *
     */
    @Nullable List<NodeName> getCandidateNodes();
    
    /**
     * Return candidateNodes, guaranteed to be non-null.
     *
     * @return {@code List<NodeName>} candidateNodes, guaranteed to be non-null.
     * @throws NoSuchElementException if candidateNodes is not present
     *
     */
    default @NonNull List<NodeName> requireCandidateNodes() {
        return CodeHelpers.require(getCandidateNodes(), "candidatenodes");
    }

}

