package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.entity.owners.norev;
import java.lang.Class;
import java.lang.Override;
import java.util.NoSuchElementException;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.svc.v1.urn.opendaylight.params.xml.ns.yang.controller.entity.owners.norev.YangModuleInfoImpl;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.QName;

/**
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>odl-entity-owners</b>
 * <pre>
 * grouping entity-id {
 *   leaf type {
 *     type entity-type;
 *   }
 *   leaf name {
 *     type entity-name;
 *   }
 * }
 * </pre>
 *
 */
@Generated("mdsal-binding-generator")
public interface EntityId
    extends
    DataObject
{



    /**
     * YANG identifier of the statement represented by this class.
     */
    public static final @NonNull QName QNAME = YangModuleInfoImpl.qnameOf("entity-id");

    @Override
    Class<? extends EntityId> implementedInterface();
    
    /**
     * Return type, or {@code null} if it is not present.
     *
     * @return {@code EntityType} type, or {@code null} if it is not present.
     *
     */
    EntityType getType();
    
    /**
     * Return type, guaranteed to be non-null.
     *
     * @return {@code EntityType} type, guaranteed to be non-null.
     * @throws NoSuchElementException if type is not present
     *
     */
    default @NonNull EntityType requireType() {
        return CodeHelpers.require(getType(), "type");
    }
    
    /**
     * Return name, or {@code null} if it is not present.
     *
     * @return {@code EntityName} name, or {@code null} if it is not present.
     *
     */
    EntityName getName();
    
    /**
     * Return name, guaranteed to be non-null.
     *
     * @return {@code EntityName} name, guaranteed to be non-null.
     * @throws NoSuchElementException if name is not present
     *
     */
    default @NonNull EntityName requireName() {
        return CodeHelpers.require(getName(), "name");
    }

}

