package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.entity.owners.norev;
import com.google.common.base.MoreObjects;
import java.io.Serializable;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.InstanceIdentifier;
import org.opendaylight.yangtools.yang.binding.UnionTypeObject;

/**
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>odl-entity-owners</b>
 * <pre>
 * typedef entity-name {
 *   type union {
 *     type instance-identifier;
 *     type string {
 *       length 1..max;
 *     }
 *   }
 * }
 * </pre>
 *
 */
@Generated("mdsal-binding-generator")
public class EntityName
 implements UnionTypeObject, Serializable {
    @java.io.Serial
    private static final long serialVersionUID = 410486610934028909L;
    private final InstanceIdentifier<?> _instanceIdentifier;
    private final String _string;


    public EntityName(InstanceIdentifier<?> _instanceIdentifier) {
        this._instanceIdentifier = Objects.requireNonNull(_instanceIdentifier);
        this._string = null;
    }
    
    public EntityName(String _string) {
        this._instanceIdentifier = null;
        this._string = Objects.requireNonNull(_string);
    }
    /**
     * Creates a copy from Source Object.
     *
     * @param source Source object
     */
    public EntityName(EntityName source) {
        this._instanceIdentifier = source._instanceIdentifier;
        this._string = source._string;
    }
    
    /**
     * Return a String representing the value of this union.
     *
     * @return String representation of this union's value.
     */
    public String stringValue() {
        if (_instanceIdentifier != null) {
            return _instanceIdentifier.toString();
        }
        if (_string != null) {
            return _string;
        }
        throw new IllegalStateException("No value assigned");
    }


    public InstanceIdentifier<?> getInstanceIdentifier() {
        return _instanceIdentifier;
    }
    
    public String getString() {
        return _string;
    }


    @Override
    public int hashCode() {
        final int prime = 31;
        int result = 1;
        result = prime * result + Objects.hashCode(_instanceIdentifier);
        result = prime * result + Objects.hashCode(_string);
        return result;
    }

    @Override
    public final boolean equals(Object obj) {
        return this == obj || obj instanceof EntityName other
            && Objects.equals(_instanceIdentifier, other._instanceIdentifier)        
            && Objects.equals(_string, other._string);
    }

    @Override
    public String toString() {
        final var helper = MoreObjects.toStringHelper(EntityName.class);
        CodeHelpers.appendValue(helper, "instanceIdentifier", _instanceIdentifier);
        CodeHelpers.appendValue(helper, "string", _string);
        return helper.toString();
    }
}

