package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.entity.owners.norev;
import java.lang.Class;
import java.lang.IllegalArgumentException;
import java.lang.NullPointerException;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

/**
 * Class that builds {@link GetEntityOwnerInput} instances. Overall design of the class is that of a
 * <a href="https://en.wikipedia.org/wiki/Fluent_interface">fluent interface</a>, where method chaining is used.
 *
 * <p>
 * In general, this class is supposed to be used like this template:
 * <pre>
 *   <code>
 *     GetEntityOwnerInput createGetEntityOwnerInput(int fooXyzzy, int barBaz) {
 *         return new GetEntityOwnerInputBuilder()
 *             .setFoo(new FooBuilder().setXyzzy(fooXyzzy).build())
 *             .setBar(new BarBuilder().setBaz(barBaz).build())
 *             .build();
 *     }
 *   </code>
 * </pre>
 *
 * <p>
 * This pattern is supported by the immutable nature of GetEntityOwnerInput, as instances can be freely passed around without
 * worrying about synchronization issues.
 *
 * <p>
 * As a side note: method chaining results in:
 * <ul>
 *   <li>very efficient Java bytecode, as the method invocation result, in this case the Builder reference, is
 *       on the stack, so further method invocations just need to fill method arguments for the next method
 *       invocation, which is terminated by {@link #build()}, which is then returned from the method</li>
 *   <li>better understanding by humans, as the scope of mutable state (the builder) is kept to a minimum and is
 *       very localized</li>
 *   <li>better optimization opportunities, as the object scope is minimized in terms of invocation (rather than
 *       method) stack, making <a href="https://en.wikipedia.org/wiki/Escape_analysis">escape analysis</a> a lot
 *       easier. Given enough compiler (JIT/AOT) prowess, the cost of th builder object can be completely
 *       eliminated</li>
 * </ul>
 *
 * @see GetEntityOwnerInput
 *
 */
@Generated("mdsal-binding-generator")
public class GetEntityOwnerInputBuilder {

    private EntityName _name;
    private EntityType _type;


    Map<Class<? extends Augmentation<GetEntityOwnerInput>>, Augmentation<GetEntityOwnerInput>> augmentation = Map.of();

    /**
     * Construct an empty builder.
     */
    public GetEntityOwnerInputBuilder() {
        // No-op
    }

    
    
    /**
     * Construct a new builder initialized from specified {@link EntityId}.
     *
     * @param arg EntityId from which the builder should be initialized
     */
    public GetEntityOwnerInputBuilder(EntityId arg) {
        this._type = arg.getType();
        this._name = arg.getName();
    }
    

    /**
     * Construct a builder initialized with state from specified {@link GetEntityOwnerInput}.
     *
     * @param base GetEntityOwnerInput from which the builder should be initialized
     */
    public GetEntityOwnerInputBuilder(GetEntityOwnerInput base) {
        final var aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<>(aug);
        }
        this._name = base.getName();
        this._type = base.getType();
    }

    /**
     * Set fields from given grouping argument. Valid argument is instance of one of following types:
     * <ul>
     *   <li>{@link EntityId}</li>
     * </ul>
     *
     * @param arg grouping object
     * @throws IllegalArgumentException if given argument is none of valid types or has property with incompatible value
    */
    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof EntityId castArg) {
            this._type = castArg.getType();
            this._name = castArg.getName();
            isValidArg = true;
        }
        CodeHelpers.validValue(isValidArg, arg, "[EntityId]");
    }


    /**
     * Return current value associated with the property corresponding to {@link GetEntityOwnerInput#getName()}.
     *
     * @return current value
     */
    public EntityName getName() {
        return _name;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link GetEntityOwnerInput#getType()}.
     *
     * @return current value
     */
    public EntityType getType() {
        return _type;
    }

    /**
     * Return the specified augmentation, if it is present in this builder.
     *
     * @param <E$$> augmentation type
     * @param augmentationType augmentation type class
     * @return Augmentation object from this builder, or {@code null} if not present
     * @throws NullPointerException if {@code augmentType} is {@code null}
     */
    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<GetEntityOwnerInput>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(Objects.requireNonNull(augmentationType));
    }

    
    /**
     * Set the property corresponding to {@link GetEntityOwnerInput#getName()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public GetEntityOwnerInputBuilder setName(final EntityName value) {
        this._name = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link GetEntityOwnerInput#getType()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public GetEntityOwnerInputBuilder setType(final EntityType value) {
        this._type = value;
        return this;
    }
    
    /**
      * Add an augmentation to this builder's product.
      *
      * @param augmentation augmentation to be added
      * @return this builder
      * @throws NullPointerException if {@code augmentation} is null
      */
    public GetEntityOwnerInputBuilder addAugmentation(Augmentation<GetEntityOwnerInput> augmentation) {
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentation.implementedInterface(), augmentation);
        return this;
    }
    
    /**
      * Remove an augmentation from this builder's product. If this builder does not track such an augmentation
      * type, this method does nothing.
      *
      * @param augmentationType augmentation type to be removed
      * @return this builder
      */
    public GetEntityOwnerInputBuilder removeAugmentation(Class<? extends Augmentation<GetEntityOwnerInput>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    /**
     * A new {@link GetEntityOwnerInput} instance.
     *
     * @return A new {@link GetEntityOwnerInput} instance.
     */
    public @NonNull GetEntityOwnerInput build() {
        return new GetEntityOwnerInputImpl(this);
    }

    private static final class GetEntityOwnerInputImpl
        extends AbstractAugmentable<GetEntityOwnerInput>
        implements GetEntityOwnerInput {
    
        private final EntityName _name;
        private final EntityType _type;
    
        GetEntityOwnerInputImpl(GetEntityOwnerInputBuilder base) {
            super(base.augmentation);
            this._name = base.getName();
            this._type = base.getType();
        }
    
        @Override
        public EntityName getName() {
            return _name;
        }
        
        @Override
        public EntityType getType() {
            return _type;
        }
    
        
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int result = GetEntityOwnerInput.bindingHashCode(this);
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            return GetEntityOwnerInput.bindingEquals(this, obj);
        }
    
        @Override
        public String toString() {
            return GetEntityOwnerInput.bindingToString(this);
        }
    }
}
