package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.entity.owners.norev;
import com.google.common.base.MoreObjects;
import java.io.Serializable;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;
import javax.annotation.processing.Generated;
import javax.management.ConstructorParameters;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.ScalarTypeObject;

/**
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>odl-entity-owners</b>
 * <pre>
 * typedef node-name {
 *   type string {
 *     length 1..max;
 *   }
 * }
 * </pre>
 *
 */
@Generated("mdsal-binding-generator")
public class NodeName
 implements ScalarTypeObject<String>, Serializable {
    @java.io.Serial
    private static final long serialVersionUID = 1976334865305676141L;
    private final String _value;

    private static void check_valueLength(final String value) {
        final int length = value.codePointCount(0, value.length());
        if (length >= 1) {
            return;
        }
        CodeHelpers.throwInvalidLength("[[1..2147483647]]", value);
    }

    @ConstructorParameters("value")
    public NodeName(String _value) {
        if (_value != null) {
            check_valueLength(_value);
        }
        
        CodeHelpers.requireValue(_value);
    
        this._value = _value;
    }
    
    /**
     * Creates a copy from Source Object.
     *
     * @param source Source object
     */
    public NodeName(NodeName source) {
        this._value = source._value;
    }

    public static NodeName getDefaultInstance(final String defaultValue) {
        return new NodeName(defaultValue);
    }

    @Override
    public String getValue() {
        return _value;
    }


    @Override
    public int hashCode() {
        return CodeHelpers.wrapperHashCode(_value);
    }

    @Override
    public final boolean equals(Object obj) {
        return this == obj || obj instanceof NodeName other
            && Objects.equals(_value, other._value);
    }

    @Override
    public String toString() {
        final var helper = MoreObjects.toStringHelper(NodeName.class);
        CodeHelpers.appendValue(helper, "value", _value);
        return helper.toString();
    }
}

