package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.entity.owners.norev;
import javax.annotation.processing.Generated;
import org.opendaylight.yangtools.yang.binding.DataRoot;

/**
 * An initial cut at modeling entity ownership status information in a way which 
 * not dependent on the datastore. This model is considered experimental and 
 * implementation-specific. It can change incompatibly between OpenDaylight 
 * releases.
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>odl-entity-owners</b>
 * <pre>
 * module odl-entity-owners {
 *   namespace urn:opendaylight:params:xml:ns:yang:controller:entity-owners;
 *   prefix entity-owners;
 *   typedef entity-type {
 *     type string {
 *       length 1..max;
 *     }
 *   }
 *   typedef entity-name {
 *     type union {
 *       type instance-identifier;
 *       type string {
 *         length 1..max;
 *       }
 *     }
 *   }
 *   typedef node-name {
 *     type string {
 *       length 1..max;
 *     }
 *   }
 *   grouping entity-id {
 *     leaf type {
 *       type entity-type;
 *     }
 *     leaf name {
 *       type entity-name;
 *     }
 *   }
 *   grouping owner {
 *     leaf owner-node {
 *       type node-name;
 *     }
 *   }
 *   grouping candidates {
 *     leaf-list candidate-nodes {
 *       type node-name;
 *       ordered-by user;
 *       min-elements 1;
 *     }
 *   }
 *   grouping details {
 *     uses owner;
 *     uses candidates;
 *   }
 *   rpc get-entities {
 *     output output {
 *       list entities {
 *         key "type name";
 *         uses entity-id;
 *         uses details;
 *       }
 *     }
 *   }
 *   rpc get-entity {
 *     input input {
 *       uses entity-id;
 *     }
 *     output output {
 *       uses details;
 *     }
 *   }
 *   rpc get-entity-owner {
 *     input input {
 *       uses entity-id;
 *     }
 *     output output {
 *       uses owner;
 *     }
 *   }
 * }
 * </pre>
 *
 */
@Generated("mdsal-binding-generator")
public interface OdlEntityOwnersData
    extends
    DataRoot
{





}

