package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.entity.owners.norev.get.entities.output;
import java.lang.Class;
import java.lang.IllegalArgumentException;
import java.lang.NullPointerException;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.entity.owners.norev.Candidates;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.entity.owners.norev.Details;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.entity.owners.norev.EntityId;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.entity.owners.norev.EntityName;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.entity.owners.norev.EntityType;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.entity.owners.norev.NodeName;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.entity.owners.norev.Owner;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

/**
 * Class that builds {@link Entities} instances. Overall design of the class is that of a
 * <a href="https://en.wikipedia.org/wiki/Fluent_interface">fluent interface</a>, where method chaining is used.
 *
 * <p>
 * In general, this class is supposed to be used like this template:
 * <pre>
 *   <code>
 *     Entities createEntities(int fooXyzzy, int barBaz) {
 *         return new EntitiesBuilder()
 *             .setFoo(new FooBuilder().setXyzzy(fooXyzzy).build())
 *             .setBar(new BarBuilder().setBaz(barBaz).build())
 *             .build();
 *     }
 *   </code>
 * </pre>
 *
 * <p>
 * This pattern is supported by the immutable nature of Entities, as instances can be freely passed around without
 * worrying about synchronization issues.
 *
 * <p>
 * As a side note: method chaining results in:
 * <ul>
 *   <li>very efficient Java bytecode, as the method invocation result, in this case the Builder reference, is
 *       on the stack, so further method invocations just need to fill method arguments for the next method
 *       invocation, which is terminated by {@link #build()}, which is then returned from the method</li>
 *   <li>better understanding by humans, as the scope of mutable state (the builder) is kept to a minimum and is
 *       very localized</li>
 *   <li>better optimization opportunities, as the object scope is minimized in terms of invocation (rather than
 *       method) stack, making <a href="https://en.wikipedia.org/wiki/Escape_analysis">escape analysis</a> a lot
 *       easier. Given enough compiler (JIT/AOT) prowess, the cost of th builder object can be completely
 *       eliminated</li>
 * </ul>
 *
 * @see Entities
 *
 */
@Generated("mdsal-binding-generator")
public class EntitiesBuilder {

    private List<NodeName> _candidateNodes;
    private EntityName _name;
    private NodeName _ownerNode;
    private EntityType _type;
    private EntitiesKey key;


    Map<Class<? extends Augmentation<Entities>>, Augmentation<Entities>> augmentation = Map.of();

    /**
     * Construct an empty builder.
     */
    public EntitiesBuilder() {
        // No-op
    }

    
    
    /**
     * Construct a new builder initialized from specified {@link EntityId}.
     *
     * @param arg EntityId from which the builder should be initialized
     */
    public EntitiesBuilder(EntityId arg) {
        this._type = arg.getType();
        this._name = arg.getName();
    }
    
    
    /**
     * Construct a new builder initialized from specified {@link Details}.
     *
     * @param arg Details from which the builder should be initialized
     */
    public EntitiesBuilder(Details arg) {
        this._ownerNode = arg.getOwnerNode();
        this._candidateNodes = arg.getCandidateNodes();
    }
    
    /**
     * Construct a new builder initialized from specified {@link Owner}.
     *
     * @param arg Owner from which the builder should be initialized
     */
    public EntitiesBuilder(Owner arg) {
        this._ownerNode = arg.getOwnerNode();
    }
    
    /**
     * Construct a new builder initialized from specified {@link Candidates}.
     *
     * @param arg Candidates from which the builder should be initialized
     */
    public EntitiesBuilder(Candidates arg) {
        this._candidateNodes = arg.getCandidateNodes();
    }
    
    

    /**
     * Construct a builder initialized with state from specified {@link Entities}.
     *
     * @param base Entities from which the builder should be initialized
     */
    public EntitiesBuilder(Entities base) {
        final var aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<>(aug);
        }
        this.key = base.key();
        this._name = base.getName();
        this._type = base.getType();
        this._candidateNodes = base.getCandidateNodes();
        this._ownerNode = base.getOwnerNode();
    }

    /**
     * Set fields from given grouping argument. Valid argument is instance of one of following types:
     * <ul>
     *   <li>{@link EntityId}</li>
     *   <li>{@link Owner}</li>
     *   <li>{@link Details}</li>
     *   <li>{@link Candidates}</li>
     * </ul>
     *
     * @param arg grouping object
     * @throws IllegalArgumentException if given argument is none of valid types or has property with incompatible value
    */
    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof EntityId castArg) {
            this._type = castArg.getType();
            this._name = castArg.getName();
            isValidArg = true;
        }
        if (arg instanceof Owner castArg) {
            this._ownerNode = castArg.getOwnerNode();
            isValidArg = true;
        }
        if (arg instanceof Details castArg) {
            isValidArg = true;
        }
        if (arg instanceof Candidates castArg) {
            this._candidateNodes = castArg.getCandidateNodes();
            isValidArg = true;
        }
        CodeHelpers.validValue(isValidArg, arg, "[EntityId, Owner, Details, Candidates]");
    }


    /**
     * Return current value associated with the property corresponding to {@link Entities#key()}.
     *
     * @return current value
     */
    public EntitiesKey key() {
        return key;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link Entities#getCandidateNodes()}.
     *
     * @return current value
     */
    public List<NodeName> getCandidateNodes() {
        return _candidateNodes;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link Entities#getName()}.
     *
     * @return current value
     */
    public EntityName getName() {
        return _name;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link Entities#getOwnerNode()}.
     *
     * @return current value
     */
    public NodeName getOwnerNode() {
        return _ownerNode;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link Entities#getType()}.
     *
     * @return current value
     */
    public EntityType getType() {
        return _type;
    }

    /**
     * Return the specified augmentation, if it is present in this builder.
     *
     * @param <E$$> augmentation type
     * @param augmentationType augmentation type class
     * @return Augmentation object from this builder, or {@code null} if not present
     * @throws NullPointerException if {@code augmentType} is {@code null}
     */
    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<Entities>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(Objects.requireNonNull(augmentationType));
    }

    /**
     * Set the key value corresponding to {@link Entities#key()} to the specified
     * value.
     *
     * @param key desired value
     * @return this builder
     */
    public EntitiesBuilder withKey(final EntitiesKey key) {
        this.key = key;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link Entities#getCandidateNodes()} to the specified
     * value.
     *
     * @param values desired value
     * @return this builder
     */
    public EntitiesBuilder setCandidateNodes(final List<NodeName> values) {
        this._candidateNodes = values;
        return this;
    }
    
    
    /**
     * Set the property corresponding to {@link Entities#getName()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public EntitiesBuilder setName(final EntityName value) {
        this._name = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link Entities#getOwnerNode()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public EntitiesBuilder setOwnerNode(final NodeName value) {
        this._ownerNode = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link Entities#getType()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public EntitiesBuilder setType(final EntityType value) {
        this._type = value;
        return this;
    }
    
    /**
      * Add an augmentation to this builder's product.
      *
      * @param augmentation augmentation to be added
      * @return this builder
      * @throws NullPointerException if {@code augmentation} is null
      */
    public EntitiesBuilder addAugmentation(Augmentation<Entities> augmentation) {
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentation.implementedInterface(), augmentation);
        return this;
    }
    
    /**
      * Remove an augmentation from this builder's product. If this builder does not track such an augmentation
      * type, this method does nothing.
      *
      * @param augmentationType augmentation type to be removed
      * @return this builder
      */
    public EntitiesBuilder removeAugmentation(Class<? extends Augmentation<Entities>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    /**
     * A new {@link Entities} instance.
     *
     * @return A new {@link Entities} instance.
     */
    public @NonNull Entities build() {
        return new EntitiesImpl(this);
    }

    private static final class EntitiesImpl
        extends AbstractAugmentable<Entities>
        implements Entities {
    
        private final List<NodeName> _candidateNodes;
        private final EntityName _name;
        private final NodeName _ownerNode;
        private final EntityType _type;
        private final EntitiesKey key;
    
        EntitiesImpl(EntitiesBuilder base) {
            super(base.augmentation);
            if (base.key() != null) {
                this.key = base.key();
            } else {
                this.key = new EntitiesKey(base.getName(), base.getType());
            }
            this._name = key.getName();
            this._type = key.getType();
            this._candidateNodes = base.getCandidateNodes();
            this._ownerNode = base.getOwnerNode();
        }
    
        @Override
        public EntitiesKey key() {
            return key;
        }
        
        @Override
        public List<NodeName> getCandidateNodes() {
            return _candidateNodes;
        }
        
        @Override
        public EntityName getName() {
            return _name;
        }
        
        @Override
        public NodeName getOwnerNode() {
            return _ownerNode;
        }
        
        @Override
        public EntityType getType() {
            return _type;
        }
    
        
        
        
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int result = Entities.bindingHashCode(this);
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            return Entities.bindingEquals(this, obj);
        }
    
        @Override
        public String toString() {
            return Entities.bindingToString(this);
        }
    }
}
