package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.entity.owners.norev.get.entities.output;
import com.google.common.base.MoreObjects;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.entity.owners.norev.EntityName;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.entity.owners.norev.EntityType;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.Key;

/**
 * This class represents the key of {@link Entities} class.
 *
 * @see Entities
 *
 */
@Generated("mdsal-binding-generator")
public class EntitiesKey
 implements Key<Entities> {
    @java.io.Serial
    private static final long serialVersionUID = 6512938549318049411L;
    private final EntityType _type;
    private final EntityName _name;


    /**
     * Constructs an instance.
     *
     * @param _name the entity name
     * @param _type the entity type
     * @throws NullPointerException if any of the arguments are null
     */
    public EntitiesKey(@NonNull EntityName _name, @NonNull EntityType _type) {
        this._name = CodeHelpers.requireKeyProp(_name, "name");
        this._type = CodeHelpers.requireKeyProp(_type, "type");
    }
    
    /**
     * Creates a copy from Source Object.
     *
     * @param source Source object
     */
    public EntitiesKey(EntitiesKey source) {
        this._type = source._type;
        this._name = source._name;
    }


    /**
     * Return type, guaranteed to be non-null.
     *
     * @return {@code EntityType} type, guaranteed to be non-null.
     */
    public @NonNull EntityType getType() {
        return _type;
    }
    
    /**
     * Return name, guaranteed to be non-null.
     *
     * @return {@code EntityName} name, guaranteed to be non-null.
     */
    public @NonNull EntityName getName() {
        return _name;
    }


    @Override
    public int hashCode() {
        final int prime = 31;
        int result = 1;
        result = prime * result + Objects.hashCode(_type);
        result = prime * result + Objects.hashCode(_name);
        return result;
    }

    @Override
    public final boolean equals(Object obj) {
        return this == obj || obj instanceof EntitiesKey other
            && Objects.equals(_type, other._type)        
            && Objects.equals(_name, other._name);
    }

    @Override
    public String toString() {
        final var helper = MoreObjects.toStringHelper(EntitiesKey.class);
        CodeHelpers.appendValue(helper, "type", _type);
        CodeHelpers.appendValue(helper, "name", _name);
        return helper.toString();
    }
}

