/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.eos.akka.bootstrap;

import akka.actor.typed.ActorRef;
import akka.actor.typed.ActorSystem;
import akka.actor.typed.Behavior;
import akka.actor.typed.SupervisorStrategy;
import akka.actor.typed.javadsl.AbstractBehavior;
import akka.actor.typed.javadsl.ActorContext;
import akka.actor.typed.javadsl.Behaviors;
import akka.actor.typed.javadsl.Receive;
import akka.cluster.typed.Cluster;
import akka.cluster.typed.ClusterSingleton;
import akka.cluster.typed.SingletonActor;
import akka.japi.function.Function;
import java.io.Serializable;
import org.opendaylight.controller.eos.akka.bootstrap.command.BootstrapCommand;
import org.opendaylight.controller.eos.akka.bootstrap.command.GetRunningContext;
import org.opendaylight.controller.eos.akka.bootstrap.command.RunningContext;
import org.opendaylight.controller.eos.akka.bootstrap.command.Terminate;
import org.opendaylight.controller.eos.akka.owner.checker.OwnerStateChecker;
import org.opendaylight.controller.eos.akka.owner.checker.command.StateCheckerCommand;
import org.opendaylight.controller.eos.akka.owner.supervisor.IdleSupervisor;
import org.opendaylight.controller.eos.akka.owner.supervisor.command.OwnerSupervisorCommand;
import org.opendaylight.controller.eos.akka.registry.candidate.CandidateRegistryInit;
import org.opendaylight.controller.eos.akka.registry.candidate.command.CandidateRegistryCommand;
import org.opendaylight.controller.eos.akka.registry.listener.type.EntityTypeListenerRegistry;
import org.opendaylight.controller.eos.akka.registry.listener.type.command.TypeListenerRegistryCommand;
import org.opendaylight.mdsal.binding.dom.codec.api.BindingInstanceIdentifierCodec;
import org.opendaylight.yangtools.yang.common.Empty;

public final class EOSMain
extends AbstractBehavior<BootstrapCommand> {
    private final ActorRef<TypeListenerRegistryCommand> listenerRegistry;
    private final ActorRef<CandidateRegistryCommand> candidateRegistry;
    private final ActorRef<OwnerSupervisorCommand> ownerSupervisor;
    private final ActorRef<StateCheckerCommand> ownerStateChecker;

    private EOSMain(ActorContext<BootstrapCommand> context, BindingInstanceIdentifierCodec iidCodec) {
        super(context);
        String role = (String)Cluster.get((ActorSystem)context.getSystem()).selfMember().getRoles().iterator().next();
        this.listenerRegistry = context.spawn(EntityTypeListenerRegistry.create(role), "ListenerRegistry");
        ClusterSingleton clusterSingleton = ClusterSingleton.get((ActorSystem)context.getSystem());
        this.ownerSupervisor = clusterSingleton.init(SingletonActor.of((Behavior)Behaviors.supervise(IdleSupervisor.create(iidCodec)).onFailure((SupervisorStrategy)SupervisorStrategy.restart()), (String)"OwnerSupervisor"));
        this.candidateRegistry = context.spawn(CandidateRegistryInit.create(this.ownerSupervisor), "CandidateRegistry");
        this.ownerStateChecker = context.spawn(OwnerStateChecker.create(role, this.ownerSupervisor, iidCodec), "OwnerStateChecker");
    }

    public static Behavior<BootstrapCommand> create(BindingInstanceIdentifierCodec iidCodec) {
        return Behaviors.setup((Function & Serializable)context -> new EOSMain((ActorContext<BootstrapCommand>)context, iidCodec));
    }

    public Receive<BootstrapCommand> createReceive() {
        return this.newReceiveBuilder().onMessage(GetRunningContext.class, this::onGetRunningContext).onMessage(Terminate.class, this::onTerminate).build();
    }

    private Behavior<BootstrapCommand> onGetRunningContext(GetRunningContext request) {
        request.getReplyTo().tell((Object)new RunningContext(this.listenerRegistry, this.candidateRegistry, this.ownerStateChecker, this.ownerSupervisor));
        return this;
    }

    private Behavior<BootstrapCommand> onTerminate(Terminate request) {
        request.getReplyTo().tell((Object)Empty.value());
        return Behaviors.stopped();
    }
}

