/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.eos.akka.owner.checker;

import akka.actor.typed.ActorRef;
import akka.actor.typed.ActorSystem;
import akka.actor.typed.Behavior;
import akka.actor.typed.Scheduler;
import akka.actor.typed.javadsl.AbstractBehavior;
import akka.actor.typed.javadsl.ActorContext;
import akka.actor.typed.javadsl.AskPattern;
import akka.actor.typed.javadsl.Behaviors;
import akka.actor.typed.javadsl.Receive;
import akka.cluster.ddata.Key;
import akka.cluster.ddata.LWWRegister;
import akka.cluster.ddata.LWWRegisterKey;
import akka.cluster.ddata.ORMap;
import akka.cluster.ddata.ORSet;
import akka.cluster.ddata.typed.javadsl.DistributedData;
import akka.cluster.ddata.typed.javadsl.Replicator;
import akka.cluster.ddata.typed.javadsl.ReplicatorMessageAdapter;
import akka.japi.function.Function;
import akka.pattern.StatusReply;
import com.google.common.base.Verify;
import java.io.Serializable;
import java.time.Duration;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletionStage;
import org.opendaylight.controller.eos.akka.owner.checker.command.AbstractEntityRequest;
import org.opendaylight.controller.eos.akka.owner.checker.command.GetCandidates;
import org.opendaylight.controller.eos.akka.owner.checker.command.GetCandidatesForEntity;
import org.opendaylight.controller.eos.akka.owner.checker.command.GetEntitiesReply;
import org.opendaylight.controller.eos.akka.owner.checker.command.GetEntitiesRequest;
import org.opendaylight.controller.eos.akka.owner.checker.command.GetEntityOwnerReply;
import org.opendaylight.controller.eos.akka.owner.checker.command.GetEntityOwnerRequest;
import org.opendaylight.controller.eos.akka.owner.checker.command.GetEntityReply;
import org.opendaylight.controller.eos.akka.owner.checker.command.GetEntityRequest;
import org.opendaylight.controller.eos.akka.owner.checker.command.GetOwnerForEntity;
import org.opendaylight.controller.eos.akka.owner.checker.command.OwnerDataResponse;
import org.opendaylight.controller.eos.akka.owner.checker.command.SingleEntityOwnerDataResponse;
import org.opendaylight.controller.eos.akka.owner.checker.command.StateCheckerCommand;
import org.opendaylight.controller.eos.akka.owner.supervisor.command.GetEntitiesBackendReply;
import org.opendaylight.controller.eos.akka.owner.supervisor.command.GetEntitiesBackendRequest;
import org.opendaylight.controller.eos.akka.owner.supervisor.command.GetEntityBackendReply;
import org.opendaylight.controller.eos.akka.owner.supervisor.command.GetEntityBackendRequest;
import org.opendaylight.controller.eos.akka.owner.supervisor.command.GetEntityOwnerBackendReply;
import org.opendaylight.controller.eos.akka.owner.supervisor.command.GetEntityOwnerBackendRequest;
import org.opendaylight.controller.eos.akka.owner.supervisor.command.OwnerSupervisorCommand;
import org.opendaylight.controller.eos.akka.registry.candidate.CandidateRegistry;
import org.opendaylight.mdsal.binding.dom.codec.api.BindingInstanceIdentifierCodec;
import org.opendaylight.mdsal.eos.dom.api.DOMEntity;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.entity.owners.norev.EntityName;
import org.opendaylight.yangtools.yang.binding.InstanceIdentifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class EntityRpcHandler
extends AbstractBehavior<StateCheckerCommand> {
    private static final Logger LOG = LoggerFactory.getLogger(EntityRpcHandler.class);
    private static final Duration ASK_TIMEOUT = Duration.ofSeconds(5L);
    private final ReplicatorMessageAdapter<StateCheckerCommand, LWWRegister<String>> ownerReplicator;
    private final ReplicatorMessageAdapter<StateCheckerCommand, ORMap<DOMEntity, ORSet<String>>> candidateReplicator;
    private final ActorRef<OwnerSupervisorCommand> ownerSupervisor;
    private final ActorRef<Replicator.Command> replicator;
    private final BindingInstanceIdentifierCodec iidCodec;
    private final Map<DOMEntity, Set<String>> currentCandidates = new HashMap<DOMEntity, Set<String>>();
    private final Map<DOMEntity, String> currentOwners = new HashMap<DOMEntity, String>();
    private final Map<String, DOMEntity> entityLookup = new HashMap<String, DOMEntity>();
    private int toSync = -1;

    public EntityRpcHandler(ActorContext<StateCheckerCommand> context, ActorRef<OwnerSupervisorCommand> ownerSupervisor, BindingInstanceIdentifierCodec iidCodec) {
        super(context);
        this.replicator = DistributedData.get((ActorSystem)context.getSystem()).replicator();
        this.ownerReplicator = new ReplicatorMessageAdapter(context, this.replicator, ASK_TIMEOUT);
        this.candidateReplicator = new ReplicatorMessageAdapter(this.getContext(), this.replicator, ASK_TIMEOUT);
        this.ownerSupervisor = ownerSupervisor;
        this.iidCodec = iidCodec;
    }

    public static Behavior<StateCheckerCommand> create(ActorRef<OwnerSupervisorCommand> ownerSupervisor, BindingInstanceIdentifierCodec iidCodec) {
        return Behaviors.setup((Function & Serializable)ctx -> new EntityRpcHandler((ActorContext<StateCheckerCommand>)ctx, ownerSupervisor, iidCodec));
    }

    public Receive<StateCheckerCommand> createReceive() {
        return this.newReceiveBuilder().onMessage(GetEntitiesRequest.class, this::onGetEntities).onMessage(GetEntityRequest.class, this::onGetEntity).onMessage(GetEntityOwnerRequest.class, this::onGetEntityOwner).onMessage(GetCandidates.class, this::onCandidatesReceived).onMessage(GetCandidatesForEntity.class, this::onCandidatesForEntityReceived).onMessage(OwnerDataResponse.class, this::onOwnerDataReceived).onMessage(SingleEntityOwnerDataResponse.class, this::onSingleOwnerReceived).onMessage(GetOwnerForEntity.class, this::onReplyWithOwner).build();
    }

    private Behavior<StateCheckerCommand> onGetEntities(GetEntitiesRequest request) {
        LOG.debug("{} : Executing get-entities rpc.", (Object)this.getContext().getSelf());
        CompletionStage result = AskPattern.askWithStatus(this.ownerSupervisor, GetEntitiesBackendRequest::new, (Duration)ASK_TIMEOUT, (Scheduler)this.getContext().getSystem().scheduler());
        result.whenComplete((response, throwable) -> {
            if (response != null) {
                request.getReplyTo().tell((Object)new GetEntitiesReply((GetEntitiesBackendReply)response));
            } else {
                LOG.debug("{} : Get-entities failed with owner supervisor, falling back to distributed-data.", (Object)this.getContext().getSelf(), throwable);
                this.getCandidates(request.getReplyTo());
            }
        });
        return this;
    }

    private Behavior<StateCheckerCommand> onGetEntity(GetEntityRequest request) {
        LOG.debug("{} : Executing get-entity rpc.", (Object)this.getContext().getSelf());
        CompletionStage result = AskPattern.askWithStatus(this.ownerSupervisor, (Function & Serializable)replyTo -> new GetEntityBackendRequest((ActorRef<StatusReply<GetEntityBackendReply>>)replyTo, request.getEntity()), (Duration)ASK_TIMEOUT, (Scheduler)this.getContext().getSystem().scheduler());
        result.whenComplete((response, throwable) -> {
            if (response != null) {
                request.getReplyTo().tell((Object)new GetEntityReply((GetEntityBackendReply)response));
            } else {
                LOG.debug("{} : Get-entity failed with owner supervisor, falling back to distributed-data.", (Object)this.getContext().getSelf(), throwable);
                this.getCandidatesForEntity(this.extractEntity(request), request.getReplyTo());
            }
        });
        return this;
    }

    private Behavior<StateCheckerCommand> onGetEntityOwner(GetEntityOwnerRequest request) {
        LOG.debug("{} : Executing get-entity-owner rpc.", (Object)this.getContext().getSelf());
        CompletionStage result = AskPattern.askWithStatus(this.ownerSupervisor, (Function & Serializable)replyTo -> new GetEntityOwnerBackendRequest((ActorRef<StatusReply<GetEntityOwnerBackendReply>>)replyTo, request.getEntity()), (Duration)ASK_TIMEOUT, (Scheduler)this.getContext().getSystem().scheduler());
        result.whenComplete((response, throwable) -> {
            if (response != null) {
                request.getReplyTo().tell((Object)new GetEntityOwnerReply(response.getOwner()));
            } else {
                LOG.debug("{} : Get-entity-owner failed with owner supervisor, falling back to distributed-data.", (Object)this.getContext().getSelf(), throwable);
                this.getOwnerForEntity(this.extractEntity(request), request.getReplyTo());
            }
        });
        return this;
    }

    private void getCandidates(ActorRef<GetEntitiesReply> replyTo) {
        this.candidateReplicator.askGet(askReplyTo -> new Replicator.Get(CandidateRegistry.KEY, Replicator.readLocal(), askReplyTo), replicatorResponse -> new GetCandidates((Replicator.GetResponse<ORMap<DOMEntity, ORSet<String>>>)replicatorResponse, replyTo));
    }

    private void getCandidatesForEntity(DOMEntity entity, ActorRef<GetEntityReply> replyTo) {
        this.candidateReplicator.askGet(askReplyTo -> new Replicator.Get(CandidateRegistry.KEY, Replicator.readLocal(), askReplyTo), replicatorResponse -> new GetCandidatesForEntity((Replicator.GetResponse<ORMap<DOMEntity, ORSet<String>>>)replicatorResponse, entity, replyTo));
    }

    private void getOwnerForEntity(DOMEntity entity, ActorRef<GetEntityOwnerReply> replyTo) {
        this.ownerReplicator.askGet(askReplyTo -> new Replicator.Get((Key)new LWWRegisterKey(entity.toString()), Replicator.readLocal(), askReplyTo), replicatorReponse -> new GetOwnerForEntity((Replicator.GetResponse<LWWRegister<String>>)replicatorReponse, entity, replyTo));
    }

    private Behavior<StateCheckerCommand> onReplyWithOwner(GetOwnerForEntity message) {
        Replicator.GetResponse<LWWRegister<String>> response = message.getResponse();
        if (response instanceof Replicator.GetSuccess) {
            message.getReplyTo().tell((Object)new GetEntityOwnerReply((String)((LWWRegister)((Replicator.GetSuccess)response).dataValue()).getValue()));
        } else {
            LOG.debug("Unable to retrieve owner for entity: {}, response: {}", (Object)message.getEntity(), response);
            message.getReplyTo().tell((Object)new GetEntityOwnerReply(""));
        }
        return Behaviors.stopped();
    }

    private Behavior<StateCheckerCommand> onCandidatesReceived(GetCandidates message) {
        Replicator.GetResponse<ORMap<DOMEntity, ORSet<String>>> response = message.getResponse();
        if (response instanceof Replicator.GetSuccess) {
            return this.extractCandidates((Replicator.GetSuccess<ORMap<DOMEntity, ORSet<String>>>)((Replicator.GetSuccess)response), message.getReplyTo());
        }
        LOG.debug("Unable to retrieve candidates from distributed-data. Response: {}", response);
        message.getReplyTo().tell((Object)new GetEntitiesReply(Collections.emptyMap(), Collections.emptyMap()));
        return Behaviors.stopped();
    }

    private Behavior<StateCheckerCommand> extractCandidates(Replicator.GetSuccess<ORMap<DOMEntity, ORSet<String>>> response, ActorRef<GetEntitiesReply> replyTo) {
        ORMap candidates = (ORMap)response.get(CandidateRegistry.KEY);
        candidates.getEntries().forEach((key, value) -> this.currentCandidates.put((DOMEntity)key, new HashSet(value.getElements())));
        this.toSync = candidates.keys().size();
        for (DOMEntity entity : candidates.keys().getElements()) {
            this.entityLookup.put(entity.toString(), entity);
            this.ownerReplicator.askGet(askReplyTo -> new Replicator.Get((Key)new LWWRegisterKey(entity.toString()), Replicator.readLocal(), askReplyTo), replicatorResponse -> new OwnerDataResponse((Replicator.GetResponse<LWWRegister<String>>)replicatorResponse, replyTo));
        }
        return this;
    }

    private Behavior<StateCheckerCommand> onOwnerDataReceived(OwnerDataResponse message) {
        Replicator.GetResponse<LWWRegister<String>> response = message.getResponse();
        if (response instanceof Replicator.GetSuccess) {
            this.handleOwnerRsp((Replicator.GetSuccess<LWWRegister<String>>)((Replicator.GetSuccess)response));
        } else if (response instanceof Replicator.NotFound) {
            EntityRpcHandler.handleNotFoundOwnerRsp((Replicator.NotFound<LWWRegister<String>>)((Replicator.NotFound)response));
        } else {
            LOG.debug("Owner retrieval failed, response: {}", response);
        }
        --this.toSync;
        if (this.toSync == 0) {
            GetEntitiesReply getEntitiesReply = new GetEntitiesReply(this.currentCandidates, this.currentOwners);
            message.getReplyTo().tell((Object)getEntitiesReply);
            return Behaviors.stopped();
        }
        return this;
    }

    private Behavior<StateCheckerCommand> onCandidatesForEntityReceived(GetCandidatesForEntity message) {
        LOG.debug("Received CandidatesForEntity: {}", (Object)message);
        Replicator.GetResponse<ORMap<DOMEntity, ORSet<String>>> response = message.getResponse();
        if (response instanceof Replicator.GetSuccess) {
            return this.extractCandidatesForEntity((Replicator.GetSuccess<ORMap<DOMEntity, ORSet<String>>>)((Replicator.GetSuccess)response), message.getEntity(), message.getReplyTo());
        }
        LOG.debug("Unable to retrieve candidates for entity: {}. Response:: {}", (Object)message.getEntity(), response);
        message.getReplyTo().tell((Object)new GetEntityReply(null, Collections.emptySet()));
        return this;
    }

    private Behavior<StateCheckerCommand> extractCandidatesForEntity(Replicator.GetSuccess<ORMap<DOMEntity, ORSet<String>>> response, DOMEntity entity, ActorRef<GetEntityReply> replyTo) {
        Map entries = ((ORMap)response.get(CandidateRegistry.KEY)).getEntries();
        this.currentCandidates.put(entity, ((ORSet)entries.get(entity)).getElements());
        this.entityLookup.put(entity.toString(), entity);
        this.ownerReplicator.askGet(askReplyTo -> new Replicator.Get((Key)new LWWRegisterKey(entity.toString()), Replicator.readLocal(), askReplyTo), replicatorResponse -> new SingleEntityOwnerDataResponse((Replicator.GetResponse<LWWRegister<String>>)replicatorResponse, entity, replyTo));
        return this;
    }

    private void handleOwnerRsp(Replicator.GetSuccess<LWWRegister<String>> rsp) {
        DOMEntity entity = this.entityLookup.get(rsp.key().id());
        String owner = (String)((LWWRegister)rsp.get(rsp.key())).getValue();
        this.currentOwners.put(entity, owner);
    }

    private static void handleNotFoundOwnerRsp(Replicator.NotFound<LWWRegister<String>> rsp) {
        LOG.debug("Owner not found. {}", rsp);
    }

    private Behavior<StateCheckerCommand> onSingleOwnerReceived(SingleEntityOwnerDataResponse message) {
        LOG.debug("Received owner for single entity: {}", (Object)message);
        Replicator.GetResponse<LWWRegister<String>> response = message.getResponse();
        GetEntityReply reply = response instanceof Replicator.GetSuccess ? new GetEntityReply((String)((LWWRegister)((Replicator.GetSuccess)response).dataValue()).getValue(), this.currentCandidates.get(message.getEntity())) : new GetEntityReply(null, this.currentCandidates.get(message.getEntity()));
        message.getReplyTo().tell((Object)reply);
        return Behaviors.stopped();
    }

    private DOMEntity extractEntity(AbstractEntityRequest<?> request) {
        EntityName name = request.getName();
        InstanceIdentifier<?> iid = name.getInstanceIdentifier();
        if (iid != null) {
            return new DOMEntity(request.getType().getValue(), this.iidCodec.fromBinding(iid));
        }
        String str = (String)Verify.verifyNotNull((Object)name.getString(), (String)"Unhandled entity name %s", (Object[])new Object[]{name});
        return new DOMEntity(request.getType().getValue(), str);
    }
}

