/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.eos.akka.owner.checker;

import akka.actor.typed.ActorRef;
import akka.actor.typed.ActorSystem;
import akka.actor.typed.Behavior;
import akka.actor.typed.javadsl.AbstractBehavior;
import akka.actor.typed.javadsl.ActorContext;
import akka.actor.typed.javadsl.Behaviors;
import akka.actor.typed.javadsl.Receive;
import akka.cluster.ddata.Key;
import akka.cluster.ddata.LWWRegister;
import akka.cluster.ddata.LWWRegisterKey;
import akka.cluster.ddata.typed.javadsl.DistributedData;
import akka.cluster.ddata.typed.javadsl.Replicator;
import akka.cluster.ddata.typed.javadsl.ReplicatorMessageAdapter;
import akka.japi.function.Function;
import java.io.Serializable;
import java.time.Duration;
import java.util.Objects;
import org.opendaylight.controller.eos.akka.owner.checker.EntityRpcHandler;
import org.opendaylight.controller.eos.akka.owner.checker.command.GetEntitiesRequest;
import org.opendaylight.controller.eos.akka.owner.checker.command.GetEntityOwnerRequest;
import org.opendaylight.controller.eos.akka.owner.checker.command.GetEntityRequest;
import org.opendaylight.controller.eos.akka.owner.checker.command.GetOwnershipState;
import org.opendaylight.controller.eos.akka.owner.checker.command.GetOwnershipStateReply;
import org.opendaylight.controller.eos.akka.owner.checker.command.InternalGetReply;
import org.opendaylight.controller.eos.akka.owner.checker.command.StateCheckerCommand;
import org.opendaylight.controller.eos.akka.owner.checker.command.StateCheckerRequest;
import org.opendaylight.controller.eos.akka.owner.supervisor.command.OwnerSupervisorCommand;
import org.opendaylight.mdsal.binding.dom.codec.api.BindingInstanceIdentifierCodec;
import org.opendaylight.mdsal.eos.common.api.EntityOwnershipState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class OwnerStateChecker
extends AbstractBehavior<StateCheckerCommand> {
    private static final Logger LOG = LoggerFactory.getLogger(OwnerStateChecker.class);
    private static final Duration GET_OWNERSHIP_TIMEOUT = Duration.ofSeconds(5L);
    private static final Duration UNEXPECTED_ASK_TIMEOUT = Duration.ofSeconds(5L);
    private final ReplicatorMessageAdapter<StateCheckerCommand, LWWRegister<String>> ownerReplicator;
    private final ActorRef<OwnerSupervisorCommand> ownerSupervisor;
    private final BindingInstanceIdentifierCodec iidCodec;
    private final ActorRef<Replicator.Command> replicator;
    private final String localMember;

    private OwnerStateChecker(ActorContext<StateCheckerCommand> context, String localMember, ActorRef<OwnerSupervisorCommand> ownerSupervisor, BindingInstanceIdentifierCodec iidCodec) {
        super(context);
        this.localMember = Objects.requireNonNull(localMember);
        this.ownerSupervisor = Objects.requireNonNull(ownerSupervisor);
        this.iidCodec = Objects.requireNonNull(iidCodec);
        this.replicator = DistributedData.get((ActorSystem)context.getSystem()).replicator();
        this.ownerReplicator = new ReplicatorMessageAdapter(context, this.replicator, UNEXPECTED_ASK_TIMEOUT);
    }

    public static Behavior<StateCheckerCommand> create(String localMember, ActorRef<OwnerSupervisorCommand> ownerSupervisor, BindingInstanceIdentifierCodec iidCodec) {
        return Behaviors.setup((Function & Serializable)ctx -> new OwnerStateChecker((ActorContext<StateCheckerCommand>)ctx, localMember, ownerSupervisor, iidCodec));
    }

    public Receive<StateCheckerCommand> createReceive() {
        return this.newReceiveBuilder().onMessage(GetOwnershipState.class, this::onGetOwnershipState).onMessage(InternalGetReply.class, this::respondWithState).onMessage(GetEntitiesRequest.class, this::executeEntityRpc).onMessage(GetEntityRequest.class, this::executeEntityRpc).onMessage(GetEntityOwnerRequest.class, this::executeEntityRpc).build();
    }

    private Behavior<StateCheckerCommand> onGetOwnershipState(GetOwnershipState message) {
        this.ownerReplicator.askGet(askReplyTo -> new Replicator.Get((Key)new LWWRegisterKey(message.getEntity().toString()), (Replicator.ReadConsistency)new Replicator.ReadMajority(GET_OWNERSHIP_TIMEOUT), askReplyTo), reply -> new InternalGetReply((Replicator.GetResponse<LWWRegister<String>>)reply, message.getEntity(), message.getReplyTo()));
        return this;
    }

    private Behavior<StateCheckerCommand> respondWithState(InternalGetReply reply) {
        Replicator.GetResponse<LWWRegister<String>> response = reply.getResponse();
        if (response instanceof Replicator.NotFound) {
            LOG.debug("Data for owner not found, most likely no owner has beed picked for entity: {}", (Object)reply.getEntity());
            reply.getReplyTo().tell((Object)new GetOwnershipStateReply(null));
        } else if (response instanceof Replicator.GetFailure) {
            LOG.warn("Failure retrieving data for entity: {}", (Object)reply.getEntity());
            reply.getReplyTo().tell((Object)new GetOwnershipStateReply(null));
        } else if (response instanceof Replicator.GetSuccess) {
            String owner = (String)((LWWRegister)((Replicator.GetSuccess)response).get(response.key())).getValue();
            LOG.debug("Data for owner received. {}, owner: {}", response, (Object)owner);
            boolean isOwner = this.localMember.equals(owner);
            boolean hasOwner = !owner.isEmpty();
            reply.getReplyTo().tell((Object)new GetOwnershipStateReply(EntityOwnershipState.from((boolean)isOwner, (boolean)hasOwner)));
        }
        return this;
    }

    private Behavior<StateCheckerCommand> executeEntityRpc(StateCheckerRequest request) {
        ActorRef rpcHandler = this.getContext().spawnAnonymous(EntityRpcHandler.create(this.ownerSupervisor, this.iidCodec));
        LOG.debug("Executing entity rpc: {} in actor: {}", (Object)request, (Object)rpcHandler);
        rpcHandler.tell((Object)request);
        return this;
    }
}

