/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.eos.akka.owner.checker.command;

import akka.actor.typed.ActorRef;
import com.google.common.base.MoreObjects;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.controller.eos.akka.owner.checker.command.StateCheckerReply;
import org.opendaylight.controller.eos.akka.owner.checker.command.StateCheckerRequest;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.entity.owners.norev.EntityId;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.entity.owners.norev.EntityName;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.entity.owners.norev.EntityType;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.entity.owners.norev.get.entities.output.EntitiesBuilder;

public abstract class AbstractEntityRequest<T extends StateCheckerReply>
extends StateCheckerRequest<T> {
    private static final long serialVersionUID = 1L;
    private final @NonNull EntityType type;
    private final @NonNull EntityName name;

    AbstractEntityRequest(ActorRef<T> replyTo, EntityId entity) {
        super(replyTo);
        this.type = entity.requireType();
        this.name = entity.requireName();
    }

    public final @NonNull EntityId getEntity() {
        return new EntitiesBuilder().setType(this.type).setName(this.name).build();
    }

    public final @NonNull EntityType getType() {
        return this.type;
    }

    public final @NonNull EntityName getName() {
        return this.name;
    }

    public final String toString() {
        return MoreObjects.toStringHelper((Object)this).add("type", (Object)this.type).add("name", (Object)this.name).toString();
    }
}

