/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.eos.akka.owner.supervisor;

import akka.actor.typed.ActorRef;
import akka.actor.typed.ActorSystem;
import akka.actor.typed.Behavior;
import akka.actor.typed.javadsl.AbstractBehavior;
import akka.actor.typed.javadsl.ActorContext;
import akka.actor.typed.javadsl.Behaviors;
import akka.actor.typed.javadsl.Receive;
import akka.cluster.ddata.ORMap;
import akka.cluster.ddata.ORSet;
import akka.cluster.ddata.ReplicatedData;
import akka.cluster.ddata.SelfUniqueAddress;
import akka.cluster.ddata.typed.javadsl.DistributedData;
import akka.cluster.ddata.typed.javadsl.Replicator;
import akka.cluster.ddata.typed.javadsl.ReplicatorMessageAdapter;
import java.time.Duration;
import java.util.Map;
import org.opendaylight.controller.eos.akka.owner.supervisor.command.ClearCandidates;
import org.opendaylight.controller.eos.akka.owner.supervisor.command.ClearCandidatesResponse;
import org.opendaylight.controller.eos.akka.owner.supervisor.command.ClearCandidatesUpdateResponse;
import org.opendaylight.controller.eos.akka.owner.supervisor.command.OwnerSupervisorCommand;
import org.opendaylight.controller.eos.akka.registry.candidate.CandidateRegistry;
import org.opendaylight.mdsal.eos.dom.api.DOMEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CandidateCleaner
extends AbstractBehavior<OwnerSupervisorCommand> {
    private static final Logger LOG = LoggerFactory.getLogger(CandidateCleaner.class);
    private final ReplicatorMessageAdapter<OwnerSupervisorCommand, ORMap<DOMEntity, ORSet<String>>> candidateReplicator;
    private final SelfUniqueAddress node;
    private int remaining = 0;

    private CandidateCleaner(ActorContext<OwnerSupervisorCommand> context) {
        super(context);
        ActorRef replicator = DistributedData.get((ActorSystem)this.getContext().getSystem()).replicator();
        this.candidateReplicator = new ReplicatorMessageAdapter(this.getContext(), replicator, Duration.ofSeconds(5L));
        this.node = DistributedData.get((ActorSystem)context.getSystem()).selfUniqueAddress();
    }

    public static Behavior<OwnerSupervisorCommand> create() {
        return Behaviors.setup(CandidateCleaner::new);
    }

    public Receive<OwnerSupervisorCommand> createReceive() {
        return this.newReceiveBuilder().onMessage(ClearCandidates.class, this::onClearCandidates).onMessage(ClearCandidatesUpdateResponse.class, this::onClearCandidatesUpdateResponse).build();
    }

    private Behavior<OwnerSupervisorCommand> onClearCandidates(ClearCandidates command) {
        LOG.debug("Clearing candidates for member: {}", (Object)command.getOriginalMessage().getCandidate());
        ORMap candidates = (ORMap)((Replicator.GetSuccess)command.getResponse()).get(CandidateRegistry.KEY);
        for (Map.Entry entry : candidates.getEntries().entrySet()) {
            if (!((ORSet)entry.getValue()).contains((Object)command.getOriginalMessage().getCandidate())) continue;
            LOG.debug("Removing {} from {}", (Object)command.getOriginalMessage().getCandidate(), entry.getKey());
            ++this.remaining;
            this.candidateReplicator.askUpdate(askReplyTo -> new Replicator.Update(CandidateRegistry.KEY, (ReplicatedData)ORMap.empty(), (Replicator.WriteConsistency)new Replicator.WriteMajority(Duration.ofSeconds(10L)), askReplyTo, map -> map.update(this.node, (Object)((DOMEntity)entry.getKey()), (ReplicatedData)ORSet.empty(), value -> value.remove(this.node, (Object)command.getOriginalMessage().getCandidate()))), updateResponse -> new ClearCandidatesUpdateResponse((Replicator.UpdateResponse<ORMap<DOMEntity, ORSet<String>>>)updateResponse, command.getOriginalMessage().getReplyTo()));
        }
        if (this.remaining == 0) {
            LOG.debug("Did not clear any candidates for {}", (Object)command.getOriginalMessage().getCandidate());
            command.getOriginalMessage().getReplyTo().tell((Object)new ClearCandidatesResponse());
            return Behaviors.stopped();
        }
        return this;
    }

    private Behavior<OwnerSupervisorCommand> onClearCandidatesUpdateResponse(ClearCandidatesUpdateResponse command) {
        --this.remaining;
        if (this.remaining == 0) {
            LOG.debug("Last update response for candidate removal received, replying to: {}", command.getReplyTo());
            command.getReplyTo().tell((Object)new ClearCandidatesResponse());
            return Behaviors.stopped();
        }
        LOG.debug("Have still {} outstanding requests after {}", (Object)this.remaining, command.getResponse());
        return this;
    }
}

