/*
 * Decompiled with CFR 0.152.
 */
package akka.cluster.client;

import akka.actor.ActorRef;
import akka.actor.ActorSystem;
import akka.actor.ClassicActorSystemProvider;
import akka.actor.ExtendedActorSystem;
import akka.actor.Extension;
import akka.cluster.Cluster;
import akka.cluster.Cluster$;
import akka.cluster.client.ClusterClientReceptionist$;
import akka.cluster.client.ClusterReceptionist$;
import akka.cluster.client.ClusterReceptionistSettings$;
import akka.cluster.pubsub.DistributedPubSub;
import akka.cluster.pubsub.DistributedPubSub$;
import akka.cluster.pubsub.DistributedPubSubMediator;
import akka.cluster.pubsub.DistributedPubSubMediator$Subscribe$;
import akka.cluster.pubsub.DistributedPubSubMediator$Unsubscribe$;
import com.typesafe.config.Config;
import java.io.Serializable;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.collection.immutable.Set;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005\u0005Er!B\f\u0019\u0011\u0003yb!B\u0011\u0019\u0011\u0003\u0011\u0003B\u0002\u001d\u0002\t\u0003\tI\u0001C\u0004\u0002\f\u0005!\t%!\u0004\t\u000f\u0005-\u0011\u0001\"\u0011\u0002\u0018!9\u0011\u0011E\u0001\u0005B\u0005\r\u0002bBA\u0013\u0003\u0011\u0005\u0013q\u0005\u0004\u0005Ca\u0011\u0001\u0007\u0003\u00055\u000f\t\u0005\t\u0015!\u00036\u0011\u0015At\u0001\"\u0001:\u0011\u001dYtA1A\u0005\nqBaAR\u0004!\u0002\u0013i\u0004bB$\b\u0005\u0004%I\u0001\u0013\u0005\u0007/\u001e\u0001\u000b\u0011B%\t\u000ba;A\u0011A-\t\u000bu;A\u0011\u00020\t\u000b\t<A\u0011A2\t\u000b!<A\u0011A5\t\u000b-<A\u0011\u00017\t\u000bA<A\u0011A9\t\u000fQ<!\u0019!C\u0005=\"1Qo\u0002Q\u0001\n}CQA^\u0004\u0005\u0002y\u000b\u0011d\u00117vgR,'o\u00117jK:$(+Z2faRLwN\\5ti*\u0011\u0011DG\u0001\u0007G2LWM\u001c;\u000b\u0005ma\u0012aB2mkN$XM\u001d\u0006\u0002;\u0005!\u0011m[6b\u0007\u0001\u0001\"\u0001I\u0001\u000e\u0003a\u0011\u0011d\u00117vgR,'o\u00117jK:$(+Z2faRLwN\\5tiN)\u0011aI\u0015\u0002\u0004A\u0011AeJ\u0007\u0002K)\ta%A\u0003tG\u0006d\u0017-\u0003\u0002)K\t1\u0011I\\=SK\u001a\u00042AK\u00170\u001b\u0005Y#B\u0001\u0017\u001d\u0003\u0015\t7\r^8s\u0013\tq3FA\u0006FqR,gn]5p]&#\u0007C\u0001\u0011\b'\r91%\r\t\u0003UIJ!aM\u0016\u0003\u0013\u0015CH/\u001a8tS>t\u0017AB:zgR,W\u000e\u0005\u0002+m%\u0011qg\u000b\u0002\u0014\u000bb$XM\u001c3fI\u0006\u001bGo\u001c:TsN$X-\\\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0005=R\u0004\"\u0002\u001b\n\u0001\u0004)\u0014AB2p]\u001aLw-F\u0001>!\tqD)D\u0001@\u0015\tY\u0004I\u0003\u0002B\u0005\u0006AA/\u001f9fg\u00064WMC\u0001D\u0003\r\u0019w.\\\u0005\u0003\u000b~\u0012aaQ8oM&<\u0017aB2p]\u001aLw\rI\u0001\u0005e>dW-F\u0001J!\r!#\nT\u0005\u0003\u0017\u0016\u0012aa\u00149uS>t\u0007CA'U\u001d\tq%\u000b\u0005\u0002PK5\t\u0001K\u0003\u0002R=\u00051AH]8pizJ!aU\u0013\u0002\rA\u0013X\rZ3g\u0013\t)fK\u0001\u0004TiJLgn\u001a\u0006\u0003'\u0016\nQA]8mK\u0002\nA\"[:UKJl\u0017N\\1uK\u0012,\u0012A\u0017\t\u0003ImK!\u0001X\u0013\u0003\u000f\t{w\u000e\\3b]\u0006q\u0001/\u001e2Tk\nlU\rZ5bi>\u0014X#A0\u0011\u0005)\u0002\u0017BA1,\u0005!\t5\r^8s%\u00164\u0017a\u0004:fO&\u001cH/\u001a:TKJ4\u0018nY3\u0015\u0005\u0011<\u0007C\u0001\u0013f\u0013\t1WE\u0001\u0003V]&$\b\"\u0002\u0017\u0011\u0001\u0004y\u0016!E;oe\u0016<\u0017n\u001d;feN+'O^5dKR\u0011AM\u001b\u0005\u0006YE\u0001\raX\u0001\u0013e\u0016<\u0017n\u001d;feN+(m]2sS\n,'\u000fF\u0002e[>DQA\u001c\nA\u00021\u000bQ\u0001^8qS\u000eDQ\u0001\f\nA\u0002}\u000bA#\u001e8sK\u001eL7\u000f^3s'V\u00147o\u0019:jE\u0016\u0014Hc\u00013sg\")an\u0005a\u0001\u0019\")Af\u0005a\u0001?\u0006a!/Z2faRLwN\\5ti\u0006i!/Z2faRLwN\\5ti\u0002\n!\"\u001e8eKJd\u00170\u001b8hQ\u00199\u0001p\u001f?\u007f\u007fB\u0011A%_\u0005\u0003u\u0016\u0012!\u0002Z3qe\u0016\u001c\u0017\r^3e\u0003\u001diWm]:bO\u0016\f\u0013!`\u0001h+N,\u0007%Q6lC\u0002:'\u000bU\"!S:\u001cH/Z1eY\u0001\u001aX-\u001a\u0011iiR\u00048OO\u00180I>\u001cg&Y6lC:Jwn\f3pGN|\u0013m[6b_IrcgL2mkN$XM]\u0017dY&,g\u000e\u001e\u0018ii6d7%\\5he\u0006$\u0018n\u001c8.i>l\u0013m[6b[\u001d\u0014\boY\u0001\u0006g&t7-Z\u0011\u0003\u0003\u0003\tQA\r\u00187]A\u00022AKA\u0003\u0013\r\t9a\u000b\u0002\u0014\u000bb$XM\\:j_:LE\r\u0015:pm&$WM\u001d\u000b\u0002?\u0005\u0019q-\u001a;\u0015\u0007=\ny\u0001\u0003\u00045\u0007\u0001\u0007\u0011\u0011\u0003\t\u0004U\u0005M\u0011bAA\u000bW\tY\u0011i\u0019;peNK8\u000f^3n)\ry\u0013\u0011\u0004\u0005\u0007i\u0011\u0001\r!a\u0007\u0011\u0007)\ni\"C\u0002\u0002 -\u0012!d\u00117bgNL7-Q2u_J\u001c\u0016p\u001d;f[B\u0013xN^5eKJ\fa\u0001\\8pWV\u0004X#A\u0010\u0002\u001f\r\u0014X-\u0019;f\u000bb$XM\\:j_:$2aLA\u0015\u0011\u0015!d\u00011\u00016Q\u0019\t\u0001p\u001f?\u007f\u007f\"\u0012\u0011\u0001\u001f\u0015\u0007\u0001a\\HP`@")
public final class ClusterClientReceptionist
implements Extension {
    private final ExtendedActorSystem system;
    private final Config config;
    private final Option<String> role;
    private final ActorRef receptionist;

    public static ClusterClientReceptionist createExtension(ExtendedActorSystem system) {
        return ClusterClientReceptionist$.MODULE$.createExtension(system);
    }

    public static ClusterClientReceptionist$ lookup() {
        return ClusterClientReceptionist$.MODULE$.lookup();
    }

    public static ClusterClientReceptionist get(ClassicActorSystemProvider system) {
        return ClusterClientReceptionist$.MODULE$.get(system);
    }

    public static ClusterClientReceptionist get(ActorSystem system) {
        return ClusterClientReceptionist$.MODULE$.get(system);
    }

    public static Extension apply(ClassicActorSystemProvider system) {
        return ClusterClientReceptionist$.MODULE$.apply(system);
    }

    public static Extension apply(ActorSystem system) {
        return ClusterClientReceptionist$.MODULE$.apply(system);
    }

    private Config config() {
        return this.config;
    }

    private Option<String> role() {
        return this.role;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isTerminated() {
        if (((Cluster)Cluster$.MODULE$.apply(this.system)).isTerminated()) return true;
        Set<String> set = ((Cluster)Cluster$.MODULE$.apply(this.system)).selfRoles();
        if (this.role().forall((Function1 & Serializable)elem -> BoxesRunTime.boxToBoolean((boolean)set.contains((Object)elem)))) return false;
        return true;
    }

    private ActorRef pubSubMediator() {
        return ((DistributedPubSub)DistributedPubSub$.MODULE$.apply(this.system)).mediator();
    }

    public void registerService(ActorRef actor) {
        ActorRef qual$1 = this.pubSubMediator();
        DistributedPubSubMediator.Put x$1 = new DistributedPubSubMediator.Put(actor);
        ActorRef x$2 = qual$1.$bang$default$2(x$1);
        qual$1.$bang(x$1, x$2);
    }

    public void unregisterService(ActorRef actor) {
        ActorRef qual$1 = this.pubSubMediator();
        DistributedPubSubMediator.Remove x$1 = new DistributedPubSubMediator.Remove(actor.path().toStringWithoutAddress());
        ActorRef x$2 = qual$1.$bang$default$2(x$1);
        qual$1.$bang(x$1, x$2);
    }

    public void registerSubscriber(String topic, ActorRef actor) {
        ActorRef qual$1 = this.pubSubMediator();
        DistributedPubSubMediator.Subscribe x$1 = DistributedPubSubMediator$Subscribe$.MODULE$.apply(topic, actor);
        ActorRef x$2 = qual$1.$bang$default$2(x$1);
        qual$1.$bang(x$1, x$2);
    }

    public void unregisterSubscriber(String topic, ActorRef actor) {
        ActorRef qual$1 = this.pubSubMediator();
        DistributedPubSubMediator.Unsubscribe x$1 = DistributedPubSubMediator$Unsubscribe$.MODULE$.apply(topic, actor);
        ActorRef x$2 = qual$1.$bang$default$2(x$1);
        qual$1.$bang(x$1, x$2);
    }

    private ActorRef receptionist() {
        return this.receptionist;
    }

    public ActorRef underlying() {
        return this.receptionist();
    }

    public ClusterClientReceptionist(ExtendedActorSystem system) {
        ActorRef actorRef2;
        None$ none$;
        block5: {
            this.system = system;
            this.config = system.settings().config().getConfig("akka.cluster.client.receptionist");
            String string = this.config().getString("role");
            switch (string == null ? 0 : string.hashCode()) {
                case 0: {
                    if (!"".equals(string)) break;
                    none$ = None$.MODULE$;
                    break block5;
                }
            }
            none$ = new Some((Object)string);
        }
        this.role = none$;
        if (this.isTerminated()) {
            actorRef2 = system.deadLetters();
        } else {
            String name = this.config().getString("name");
            String dispatcher = this.config().getString("use-dispatcher");
            ActorRef mediator = this.pubSubMediator();
            actorRef2 = system.systemActorOf(ClusterReceptionist$.MODULE$.props(mediator, ClusterReceptionistSettings$.MODULE$.apply(this.config())).withDispatcher(dispatcher), name);
        }
        this.receptionist = actorRef2;
    }
}

