/*
 * Decompiled with CFR 0.152.
 */
package akka.cluster.typed.internal.receptionist;

import akka.actor.ActorRef;
import akka.actor.typed.ActorRef$;
import akka.actor.typed.ActorRef$ActorRefOps$;
import akka.actor.typed.Behavior;
import akka.actor.typed.internal.receptionist.AbstractServiceKey;
import akka.actor.typed.internal.receptionist.ReceptionistBehaviorProvider;
import akka.actor.typed.internal.receptionist.ReceptionistMessages;
import akka.actor.typed.internal.receptionist.ReceptionistMessages$Deregistered$;
import akka.actor.typed.internal.receptionist.ReceptionistMessages$Listing$;
import akka.actor.typed.internal.receptionist.ReceptionistMessages$Registered$;
import akka.actor.typed.receptionist.Receptionist;
import akka.actor.typed.receptionist.ServiceKey;
import akka.actor.typed.scaladsl.ActorContext;
import akka.actor.typed.scaladsl.Behaviors$;
import akka.actor.typed.scaladsl.adapter.package$TypedActorRefOps$;
import akka.actor.typed.scaladsl.package$;
import akka.actor.typed.scaladsl.package$LoggerOps$;
import akka.annotation.InternalApi;
import akka.cluster.ClusterEvent;
import akka.cluster.ClusterEvent$ClusterShuttingDown$;
import akka.cluster.ClusterEvent$InitialStateAsEvents$;
import akka.cluster.Member;
import akka.cluster.UniqueAddress;
import akka.cluster.ddata.ORMultiMap;
import akka.cluster.ddata.ORMultiMap$;
import akka.cluster.ddata.ORMultiMapKey;
import akka.cluster.ddata.Replicator;
import akka.cluster.ddata.Replicator$Update$;
import akka.cluster.typed.internal.receptionist.ClusterReceptionist;
import akka.cluster.typed.internal.receptionist.ClusterReceptionist$PruneTombstonesTick$;
import akka.cluster.typed.internal.receptionist.ClusterReceptionist$RemoveTick$;
import akka.cluster.typed.internal.receptionist.ServiceRegistry;
import akka.cluster.typed.internal.receptionist.ServiceRegistry$;
import akka.cluster.typed.internal.receptionist.ShardedServiceRegistry;
import akka.cluster.typed.internal.receptionist.ShardedServiceRegistry$;
import akka.util.TypedMultiMap;
import akka.util.TypedMultiMap$;
import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.concurrent.duration.Deadline;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@InternalApi
public final class ClusterReceptionist$
implements ReceptionistBehaviorProvider {
    public static final ClusterReceptionist$ MODULE$ = new ClusterReceptionist$();
    private static final ORMultiMap<ServiceKey<?>, ClusterReceptionist.Entry> EmptyORMultiMap = ORMultiMap$.MODULE$.empty();
    private static final String name = "clusterReceptionist";

    public final ORMultiMap<ServiceKey<?>, ClusterReceptionist.Entry> EmptyORMultiMap() {
        return EmptyORMultiMap;
    }

    @Override
    public String name() {
        return name;
    }

    @Override
    public Behavior<Receptionist.Command> behavior() {
        return Behaviors$.MODULE$.setup((Function1 & Serializable)ctx -> {
            ctx.setLoggerName(ClusterReceptionist.class);
            return Behaviors$.MODULE$.withTimers((Function1 & Serializable)timers -> {
                ClusterReceptionist.Setup setup = new ClusterReceptionist.Setup((ActorContext<Receptionist.Command>)ctx);
                ShardedServiceRegistry initialRegistry = ShardedServiceRegistry$.MODULE$.apply(setup.settings().distributedKeyCount()).addNode(setup.selfUniqueAddress());
                akka.actor.typed.ActorRef replicatorMessageAdapter = ctx.messageAdapter((Function1 & Serializable)x0$1 -> {
                    Replicator.ReplicatorMessage replicatorMessage = x0$1;
                    if (!(replicatorMessage instanceof Replicator.Changed)) {
                        throw new IllegalArgumentException();
                    }
                    Replicator.Changed changed = (Replicator.Changed)replicatorMessage;
                    ClusterReceptionist.ChangeFromReplicator changeFromReplicator = new ClusterReceptionist.ChangeFromReplicator((ORMultiMapKey)changed.key(), (ORMultiMap)changed.dataValue());
                    return changeFromReplicator;
                }, ClassTag$.MODULE$.apply(Replicator.ReplicatorMessage.class));
                initialRegistry.allDdataKeys().foreach((Function1 & Serializable)key -> {
                    ClusterReceptionist$.$anonfun$behavior$4(replicatorMessageAdapter, setup, key);
                    return BoxedUnit.UNIT;
                });
                akka.actor.typed.ActorRef clusterEventMessageAdapter = ctx.messageAdapter((Function1 & Serializable)x0$2 -> {
                    Receptionist.Command command;
                    ClusterEvent.ClusterDomainEvent clusterDomainEvent = x0$2;
                    if (clusterDomainEvent instanceof ClusterEvent.MemberJoined) {
                        ClusterEvent.MemberJoined memberJoined = (ClusterEvent.MemberJoined)clusterDomainEvent;
                        Member member = memberJoined.member();
                        command = new ClusterReceptionist.NodeAdded(member.uniqueAddress());
                    } else if (clusterDomainEvent instanceof ClusterEvent.MemberWeaklyUp) {
                        ClusterEvent.MemberWeaklyUp memberWeaklyUp = (ClusterEvent.MemberWeaklyUp)clusterDomainEvent;
                        Member member = memberWeaklyUp.member();
                        command = new ClusterReceptionist.NodeAdded(member.uniqueAddress());
                    } else if (clusterDomainEvent instanceof ClusterEvent.MemberUp) {
                        ClusterEvent.MemberUp memberUp = (ClusterEvent.MemberUp)clusterDomainEvent;
                        Member member = memberUp.member();
                        command = new ClusterReceptionist.NodeAdded(member.uniqueAddress());
                    } else if (clusterDomainEvent instanceof ClusterEvent.MemberRemoved) {
                        ClusterEvent.MemberRemoved memberRemoved = (ClusterEvent.MemberRemoved)clusterDomainEvent;
                        Member member = memberRemoved.member();
                        command = new ClusterReceptionist.NodeRemoved(member.uniqueAddress());
                    } else if (clusterDomainEvent instanceof ClusterEvent.UnreachableMember) {
                        ClusterEvent.UnreachableMember unreachableMember = (ClusterEvent.UnreachableMember)clusterDomainEvent;
                        Member member = unreachableMember.member();
                        command = new ClusterReceptionist.NodeUnreachable(member.uniqueAddress());
                    } else if (clusterDomainEvent instanceof ClusterEvent.ReachableMember) {
                        ClusterEvent.ReachableMember reachableMember = (ClusterEvent.ReachableMember)clusterDomainEvent;
                        Member member = reachableMember.member();
                        command = new ClusterReceptionist.NodeReachable(member.uniqueAddress());
                    } else if (ClusterEvent$ClusterShuttingDown$.MODULE$.equals(clusterDomainEvent)) {
                        command = new ClusterReceptionist.NodeRemoved(setup.cluster().selfUniqueAddress());
                    } else {
                        throw new IllegalStateException(new StringBuilder(50).append("Unexpected ClusterDomainEvent ").append(clusterDomainEvent).append(". Please report bug.").toString());
                    }
                    return command;
                }, ClassTag$.MODULE$.apply(ClusterEvent.ClusterDomainEvent.class));
                setup.cluster().subscribe(package$TypedActorRefOps$.MODULE$.toClassic$extension(akka.actor.typed.scaladsl.adapter.package$.MODULE$.TypedActorRefOps(clusterEventMessageAdapter)), (ClusterEvent.SubscriptionInitialStateMode)ClusterEvent$InitialStateAsEvents$.MODULE$, (Seq<Class<?>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Class[]{ClusterEvent.MemberJoined.class, ClusterEvent.MemberWeaklyUp.class, ClusterEvent.MemberUp.class, ClusterEvent.MemberRemoved.class, ClusterEvent.ReachabilityEvent.class, ClusterEvent$ClusterShuttingDown$.MODULE$.getClass()}));
                timers.startTimerWithFixedDelay(ClusterReceptionist$RemoveTick$.MODULE$, setup.settings().pruningInterval());
                timers.startTimerWithFixedDelay(ClusterReceptionist$PruneTombstonesTick$.MODULE$, setup.keepTombstonesFor().$div(24L));
                ClusterReceptionist.State initialState = new ClusterReceptionist.State(initialRegistry, Predef$.MODULE$.Map().empty(), Predef$.MODULE$.Map().empty(), TypedMultiMap$.MODULE$.empty());
                return MODULE$.behavior(setup, initialState);
            });
        });
    }

    public Behavior<Receptionist.Command> behavior(ClusterReceptionist.Setup setup, ClusterReceptionist.State state) {
        return Behaviors$.MODULE$.setup((Function1 & Serializable)ctx -> Behaviors$.MODULE$.receive((Function2 & Serializable)(x$7, msg) -> {
            Behavior behavior;
            Receptionist.Command command = msg;
            if (command instanceof ClusterReceptionist.InternalCommand) {
                ClusterReceptionist.InternalCommand internalCommand = (ClusterReceptionist.InternalCommand)((Object)command);
                behavior = ClusterReceptionist$.onInternalCommand$1(internalCommand, setup, state, ctx);
            } else if (command != null) {
                Receptionist.Command command2 = command;
                behavior = ClusterReceptionist$.onCommand$1(command2, setup, ctx, state);
            } else if (command == null) {
                behavior = Behaviors$.MODULE$.unhandled();
            } else {
                throw new MatchError((Object)command);
            }
            return behavior;
        }));
    }

    public static final /* synthetic */ void $anonfun$behavior$4(akka.actor.typed.ActorRef replicatorMessageAdapter$1, ClusterReceptionist.Setup setup$1, ORMultiMapKey key) {
        Replicator.Subscribe x$1 = new Replicator.Subscribe(key, package$TypedActorRefOps$.MODULE$.toClassic$extension(akka.actor.typed.scaladsl.adapter.package$.MODULE$.TypedActorRefOps(replicatorMessageAdapter$1)));
        ActorRef x$2 = setup$1.replicator().$bang$default$2(x$1);
        setup$1.replicator().$bang(x$1, x$2);
    }

    private static final boolean isLeader$1(ClusterReceptionist.Setup setup$2) {
        return setup$2.cluster().state().leader().contains((Object)setup$2.cluster().selfAddress());
    }

    private static final boolean isOnRemovedNode$1(ClusterReceptionist.Entry entry, Set addresses$1, ClusterReceptionist.Setup setup$2) {
        return addresses$1.apply((Object)entry.uniqueAddress(setup$2.selfUniqueAddress().address()));
    }

    private static final boolean isOld$1(ClusterReceptionist.Entry entry, long now$1, ClusterReceptionist.Setup setup$2) {
        return now$1 - entry.createdTimestamp() >= setup$2.settings().pruneRemovedOlderThan().toMillis();
    }

    public static final /* synthetic */ boolean $anonfun$behavior$8(boolean onlyRemoveOldEntries$1, Set addresses$1, ClusterReceptionist.Setup setup$2, long now$1, ClusterReceptionist.Entry entry) {
        return ClusterReceptionist$.isOnRemovedNode$1(entry, addresses$1, setup$2) && (!onlyRemoveOldEntries$1 || ClusterReceptionist$.isOld$1(entry, now$1, setup$2));
    }

    public static final /* synthetic */ void $anonfun$behavior$10(ClusterReceptionist.Setup setup$2, Tuple2 x0$3) {
        Tuple2 tuple2 = x0$3;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        ORMultiMapKey ddataKey = (ORMultiMapKey)tuple2._1();
        Map removalForKey = (Map)tuple2._2();
        Replicator.Update<ORMultiMap<ServiceKey<?>, ClusterReceptionist.Entry>> x$1 = Replicator$Update$.MODULE$.apply(ddataKey, MODULE$.EmptyORMultiMap(), setup$2.settings().writeConsistency(), Replicator$Update$.MODULE$.apply$default$4(), (Function1 & Serializable)registry -> ServiceRegistry$.MODULE$.toORMultiMap$extension(ServiceRegistry$.MODULE$.removeAll$extension((ORMultiMap<ServiceKey<?>, ClusterReceptionist.Entry>)registry, (Map<AbstractServiceKey, Set<ClusterReceptionist.Entry>>)removalForKey, setup$2.selfNodeAddress())));
        ActorRef x$2 = setup$2.replicator().$bang$default$2(x$1);
        setup$2.replicator().$bang(x$1, x$2);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    private static final void nodesRemoved$1(Set addresses, boolean onlyRemoveOldEntries, ClusterReceptionist.Setup setup$2, ClusterReceptionist.State state$1, ActorContext ctx$2) {
        block1: {
            long now = System.currentTimeMillis();
            Map removals = (Map)state$1.registry().allServices().foldLeft((Object)Predef$.MODULE$.Map().empty(), (Function2 & Serializable)(x0$1, x1$1) -> {
                Tuple2 tuple2;
                Map acc;
                block3: {
                    Tuple2 tuple22;
                    block2: {
                        tuple22 = new Tuple2(x0$1, x1$1);
                        if (tuple22 == null) break block2;
                        acc = (Map)tuple22._1();
                        tuple2 = (Tuple2)tuple22._2();
                        if (tuple2 != null) break block3;
                    }
                    throw new MatchError((Object)tuple22);
                }
                ServiceKey key = (ServiceKey)tuple2._1();
                Set entries2 = (Set)tuple2._2();
                Set removedEntries = (Set)entries2.filter((Function1 & Serializable)entry -> BoxesRunTime.boxToBoolean((boolean)ClusterReceptionist$.$anonfun$behavior$8(onlyRemoveOldEntries, addresses, setup$2, now, entry)));
                Map map = removedEntries.isEmpty() ? acc : (Map)acc.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)key), (Object)removedEntries));
                return map;
            });
            if (!removals.nonEmpty()) break block1;
            if (ctx$2.log().isDebugEnabled()) {
                package$LoggerOps$.MODULE$.debugN$extension(package$.MODULE$.LoggerOps(ctx$2.log()), "ClusterReceptionist [{}] - Node(s) removed [{}], updating registry removing entries: [{}]", (Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{setup$2.cluster().selfAddress(), addresses.mkString(","), removals.map((Function1 & Serializable)x0$2 -> {
                    Tuple2 tuple2 = x0$2;
                    if (tuple2 == null) {
                        throw new MatchError((Object)tuple2);
                    }
                    AbstractServiceKey key = (AbstractServiceKey)tuple2._1();
                    Set entries2 = (Set)tuple2._2();
                    Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)key.asServiceKey().id()), (Object)entries2.mkString("[", ", ", "]"));
                    return tuple22;
                }).mkString(",")}));
            }
            Map<ORMultiMapKey<ServiceKey<?>, ClusterReceptionist.Entry>, Map<AbstractServiceKey, Set<ClusterReceptionist.Entry>>> removalsPerDdataKey = state$1.registry().entriesPerDdataKey((Map<AbstractServiceKey, Set<ClusterReceptionist.Entry>>)removals);
            removalsPerDdataKey.foreach((Function1 & Serializable)x0$3 -> {
                ClusterReceptionist$.$anonfun$behavior$10(setup$2, x0$3);
                return BoxedUnit.UNIT;
            });
        }
    }

    private static final void reachabilityChanged$1(Set keysForNode, ClusterReceptionist.State newState, ClusterReceptionist.Setup setup$2) {
        ClusterReceptionist$.notifySubscribers$1(keysForNode, false, newState, setup$2);
    }

    public static final /* synthetic */ void $anonfun$behavior$12(ClusterReceptionist.State newState$1, ClusterReceptionist.Setup setup$2, boolean servicesWereAddedOrRemoved$1, AbstractServiceKey changedKey) {
        block1: {
            ServiceKey<Object> serviceKey = changedKey.asServiceKey();
            Set<akka.actor.typed.ActorRef> subscribers = newState$1.subscriptions().get(changedKey);
            if (!subscribers.nonEmpty()) break block1;
            Tuple2<Set<akka.actor.typed.ActorRef<Object>>, Set<akka.actor.typed.ActorRef<Object>>> tuple2 = newState$1.activeActorRefsFor(serviceKey, setup$2.selfUniqueAddress());
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            Set reachable = (Set)tuple2._1();
            Set all = (Set)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)reachable, (Object)all);
            Tuple2 tuple23 = tuple22;
            Set reachable2 = (Set)tuple23._1();
            Set all2 = (Set)tuple23._2();
            ReceptionistMessages.Listing<Object> listing = ReceptionistMessages$Listing$.MODULE$.apply(serviceKey, reachable2, all2, servicesWereAddedOrRemoved$1);
            subscribers.foreach((Function1 & Serializable)x$3 -> {
                ActorRef$ActorRefOps$.MODULE$.$bang$extension(ActorRef$.MODULE$.ActorRefOps(x$3), listing);
                return BoxedUnit.UNIT;
            });
        }
    }

    private static final void notifySubscribers$1(Set changedKeys, boolean servicesWereAddedOrRemoved, ClusterReceptionist.State newState, ClusterReceptionist.Setup setup$2) {
        changedKeys.foreach((Function1 & Serializable)changedKey -> {
            ClusterReceptionist$.$anonfun$behavior$12(newState, setup$2, servicesWereAddedOrRemoved, changedKey);
            return BoxedUnit.UNIT;
        });
    }

    private static final Behavior onCommand$1(Receptionist.Command cmd, ClusterReceptionist.Setup setup$2, ActorContext ctx$2, ClusterReceptionist.State state$1) {
        Behavior behavior;
        Receptionist.Command command = cmd;
        if (command instanceof ReceptionistMessages.Register) {
            Behavior<Object> behavior2;
            ReceptionistMessages.Register register = (ReceptionistMessages.Register)command;
            ServiceKey key = register.key();
            akka.actor.typed.ActorRef serviceInstance = register.serviceInstance();
            Option<akka.actor.typed.ActorRef<Receptionist.Registered>> maybeReplyTo = register.replyTo();
            if (serviceInstance.path().address().hasLocalScope()) {
                Option<akka.actor.typed.ActorRef<Receptionist.Registered>> option;
                ClusterReceptionist.Entry entry = new ClusterReceptionist.Entry(serviceInstance, setup$2.selfSystemUid(), System.currentTimeMillis());
                package$LoggerOps$.MODULE$.debugN$extension(package$.MODULE$.LoggerOps(ctx$2.log()), "ClusterReceptionist [{}] - Actor was registered: [{}] [{}]", (Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{setup$2.cluster().selfAddress(), key, entry}));
                if (!state$1.servicesPerActor().contains(serviceInstance)) {
                    ctx$2.watchWith(serviceInstance, new ClusterReceptionist.LocalServiceActorTerminated(serviceInstance));
                }
                if ((option = maybeReplyTo) instanceof Some) {
                    Some some = (Some)option;
                    akka.actor.typed.ActorRef replyTo = (akka.actor.typed.ActorRef)some.value();
                    ActorRef$ActorRefOps$.MODULE$.$bang$extension(ActorRef$.MODULE$.ActorRefOps(replyTo), ReceptionistMessages$Registered$.MODULE$.apply(key, serviceInstance));
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else if (None$.MODULE$.equals(option)) {
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else {
                    throw new MatchError(option);
                }
                ORMultiMapKey<ServiceKey<?>, ClusterReceptionist.Entry> ddataKey = state$1.registry().ddataKeyFor(key);
                Replicator.Update<ORMultiMap<ServiceKey<?>, ClusterReceptionist.Entry>> x$1 = Replicator$Update$.MODULE$.apply(ddataKey, MODULE$.EmptyORMultiMap(), setup$2.settings().writeConsistency(), Replicator$Update$.MODULE$.apply$default$4(), (Function1 & Serializable)registry -> ServiceRegistry$.MODULE$.toORMultiMap$extension(ServiceRegistry$.MODULE$.addBinding$extension((ORMultiMap<ServiceKey<?>, ClusterReceptionist.Entry>)registry, key, entry, setup$2.selfNodeAddress())));
                ActorRef x$2 = setup$2.replicator().$bang$default$2(x$1);
                setup$2.replicator().$bang(x$1, x$2);
                behavior2 = MODULE$.behavior(setup$2, state$1.addLocalService(serviceInstance, key));
            } else {
                ctx$2.log().error("ClusterReceptionist [{}] - Register of non-local [{}] is not supported", serviceInstance);
                behavior2 = Behaviors$.MODULE$.same();
            }
            behavior = behavior2;
        } else if (command instanceof ReceptionistMessages.Deregister) {
            Behavior<Object> behavior3;
            ReceptionistMessages.Deregister deregister = (ReceptionistMessages.Deregister)command;
            ServiceKey key = deregister.key();
            akka.actor.typed.ActorRef serviceInstance = deregister.serviceInstance();
            Option<akka.actor.typed.ActorRef<Receptionist.Deregistered>> maybeReplyTo = deregister.replyTo();
            if (serviceInstance.path().address().hasLocalScope()) {
                Option<akka.actor.typed.ActorRef<Receptionist.Deregistered>> option;
                ClusterReceptionist.Entry entry = new ClusterReceptionist.Entry(serviceInstance, setup$2.selfSystemUid(), 0L);
                package$LoggerOps$.MODULE$.debugN$extension(package$.MODULE$.LoggerOps(ctx$2.log()), "ClusterReceptionist [{}] - Unregister actor: [{}] [{}]", (Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{setup$2.cluster().selfAddress(), key.asServiceKey().id(), entry}));
                ClusterReceptionist.State newState = state$1.removeLocalService(serviceInstance, key, setup$2.newTombstoneDeadline());
                if (!newState.servicesPerActor().contains(serviceInstance)) {
                    ctx$2.unwatch(serviceInstance);
                }
                if ((option = maybeReplyTo) instanceof Some) {
                    Some some = (Some)option;
                    akka.actor.typed.ActorRef replyTo = (akka.actor.typed.ActorRef)some.value();
                    ActorRef$ActorRefOps$.MODULE$.$bang$extension(ActorRef$.MODULE$.ActorRefOps(replyTo), ReceptionistMessages$Deregistered$.MODULE$.apply(key, serviceInstance));
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else if (None$.MODULE$.equals(option)) {
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else {
                    throw new MatchError(option);
                }
                ORMultiMapKey<ServiceKey<?>, ClusterReceptionist.Entry> ddataKey = state$1.registry().ddataKeyFor(key);
                Replicator.Update<ORMultiMap<ServiceKey<?>, ClusterReceptionist.Entry>> x$3 = Replicator$Update$.MODULE$.apply(ddataKey, MODULE$.EmptyORMultiMap(), setup$2.settings().writeConsistency(), Replicator$Update$.MODULE$.apply$default$4(), (Function1 & Serializable)registry -> ServiceRegistry$.MODULE$.toORMultiMap$extension(ServiceRegistry$.MODULE$.removeBinding$extension((ORMultiMap<ServiceKey<?>, ClusterReceptionist.Entry>)registry, key, entry, setup$2.selfNodeAddress())));
                ActorRef x$4 = setup$2.replicator().$bang$default$2(x$3);
                setup$2.replicator().$bang(x$3, x$4);
                behavior3 = MODULE$.behavior(setup$2, newState);
            } else {
                ctx$2.log().error("ClusterReceptionist [{}] - Unregistering non-local [{}] is not supported", serviceInstance);
                behavior3 = Behaviors$.MODULE$.same();
            }
            behavior = behavior3;
        } else if (command instanceof ReceptionistMessages.Find) {
            ReceptionistMessages.Find find = (ReceptionistMessages.Find)command;
            ServiceKey key = find.key();
            akka.actor.typed.ActorRef<Receptionist.Listing> replyTo = find.replyTo();
            Tuple2 tuple2 = state$1.activeActorRefsFor(key, setup$2.selfUniqueAddress());
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            Set reachable = (Set)tuple2._1();
            Set all = (Set)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)reachable, (Object)all);
            Tuple2 tuple23 = tuple22;
            Set reachable2 = (Set)tuple23._1();
            Set all2 = (Set)tuple23._2();
            ActorRef$ActorRefOps$.MODULE$.$bang$extension(ActorRef$.MODULE$.ActorRefOps(replyTo), ReceptionistMessages$Listing$.MODULE$.apply(key.asServiceKey(), reachable2, all2, true));
            behavior = Behaviors$.MODULE$.same();
        } else if (command instanceof ReceptionistMessages.Subscribe) {
            Behavior<Object> behavior4;
            ReceptionistMessages.Subscribe subscribe = (ReceptionistMessages.Subscribe)command;
            ServiceKey key = subscribe.key();
            akka.actor.typed.ActorRef<Receptionist.Listing> subscriber = subscribe.subscriber();
            if (subscriber.path().address().hasLocalScope()) {
                ctx$2.watchWith(subscriber, new ClusterReceptionist.SubscriberTerminated(subscriber));
                Tuple2 tuple2 = state$1.activeActorRefsFor(key, setup$2.selfUniqueAddress());
                if (tuple2 == null) {
                    throw new MatchError(tuple2);
                }
                Set reachable = (Set)tuple2._1();
                Set all = (Set)tuple2._2();
                Tuple2 tuple24 = new Tuple2((Object)reachable, (Object)all);
                Tuple2 tuple25 = tuple24;
                Set reachable3 = (Set)tuple25._1();
                Set all3 = (Set)tuple25._2();
                ReceptionistMessages.Listing listing = ReceptionistMessages$Listing$.MODULE$.apply(key.asServiceKey(), reachable3, all3, true);
                ActorRef$ActorRefOps$.MODULE$.$bang$extension(ActorRef$.MODULE$.ActorRefOps(subscriber), listing);
                TypedMultiMap<AbstractServiceKey, akka.actor.typed.ActorRef> x$5 = state$1.subscriptions().inserted(key, subscriber);
                ShardedServiceRegistry x$6 = state$1.copy$default$1();
                Map<akka.actor.typed.ActorRef<?>, Set<AbstractServiceKey>> x$7 = state$1.copy$default$2();
                Map<akka.actor.typed.ActorRef<?>, Set<Tuple2<AbstractServiceKey, Deadline>>> x$8 = state$1.copy$default$3();
                behavior4 = MODULE$.behavior(setup$2, state$1.copy(x$6, x$7, x$8, x$5));
            } else {
                ctx$2.log().error("ClusterReceptionist [{}] - Subscriptions from non-local [{}] is not supported", subscriber);
                behavior4 = Behaviors$.MODULE$.same();
            }
            behavior = behavior4;
        } else {
            throw new IllegalArgumentException();
        }
        return behavior;
    }

    public static final /* synthetic */ void $anonfun$behavior$18(ClusterReceptionist.State state$1, ClusterReceptionist.Setup setup$2, ClusterReceptionist.Entry entry$3, AbstractServiceKey key) {
        ORMultiMapKey<ServiceKey<?>, ClusterReceptionist.Entry> ddataKey = state$1.registry().ddataKeyFor(key.asServiceKey());
        Replicator.Update<ORMultiMap<ServiceKey<?>, ClusterReceptionist.Entry>> x$1 = Replicator$Update$.MODULE$.apply(ddataKey, MODULE$.EmptyORMultiMap(), setup$2.settings().writeConsistency(), Replicator$Update$.MODULE$.apply$default$4(), (Function1 & Serializable)registry -> ServiceRegistry$.MODULE$.toORMultiMap$extension(ServiceRegistry$.MODULE$.removeBinding$extension((ORMultiMap<ServiceKey<?>, ClusterReceptionist.Entry>)registry, key.asServiceKey(), entry$3, setup$2.selfNodeAddress())));
        ActorRef x$2 = setup$2.replicator().$bang$default$2(x$1);
        setup$2.replicator().$bang(x$1, x$2);
    }

    public static final /* synthetic */ void $anonfun$behavior$21(ORMultiMap newRegistry$1, ClusterReceptionist.State state$1, ActorContext ctx$2, ClusterReceptionist.Setup setup$2, ORMultiMapKey ddataKey$1, AbstractServiceKey changedKey) {
        block1: {
            ServiceKey<Object> serviceKey = changedKey.asServiceKey();
            Set tombstonedButReAdded = (Set)ServiceRegistry$.MODULE$.actorRefsFor$extension(newRegistry$1, serviceKey).filter((Function1 & Serializable)actorRef2 -> BoxesRunTime.boxToBoolean((boolean)state$1.hasTombstone(serviceKey, actorRef2)));
            if (!tombstonedButReAdded.nonEmpty()) break block1;
            if (ctx$2.log().isDebugEnabled()) {
                package$LoggerOps$.MODULE$.debug2$extension(package$.MODULE$.LoggerOps(ctx$2.log()), "ClusterReceptionist [{}] - Saw ActorRefs that were tomstoned [{}], re-removing.", setup$2.cluster().selfAddress(), tombstonedButReAdded.mkString(", "));
            }
            Replicator.Update<ORMultiMap<ServiceKey<?>, ClusterReceptionist.Entry>> x$3 = Replicator$Update$.MODULE$.apply(ddataKey$1, MODULE$.EmptyORMultiMap(), setup$2.settings().writeConsistency(), Replicator$Update$.MODULE$.apply$default$4(), (Function1 & Serializable)registry -> ServiceRegistry$.MODULE$.toORMultiMap$extension(((ServiceRegistry)tombstonedButReAdded.foldLeft((Object)new ServiceRegistry((ORMultiMap<ServiceKey<?>, ClusterReceptionist.Entry>)registry), (Function2 & Serializable)(acc, ref) -> new ServiceRegistry(ServiceRegistry$.MODULE$.removeBinding$extension(((ServiceRegistry)acc).entries(), serviceKey, new ClusterReceptionist.Entry(ref, setup$2.selfSystemUid(), 0L), setup$2.selfNodeAddress())))).entries()));
            ActorRef x$4 = setup$2.replicator().$bang$default$2(x$3);
            setup$2.replicator().$bang(x$3, x$4);
        }
    }

    private static final Behavior onInternalCommand$1(ClusterReceptionist.InternalCommand cmd, ClusterReceptionist.Setup setup$2, ClusterReceptionist.State state$1, ActorContext ctx$2) {
        Behavior<Receptionist.Command> behavior;
        ClusterReceptionist.InternalCommand internalCommand = cmd;
        if (internalCommand instanceof ClusterReceptionist.SubscriberTerminated) {
            ClusterReceptionist.SubscriberTerminated subscriberTerminated = (ClusterReceptionist.SubscriberTerminated)internalCommand;
            akka.actor.typed.ActorRef subscriber = subscriberTerminated.ref();
            behavior = MODULE$.behavior(setup$2, state$1.removeSubscriber(subscriber));
        } else if (internalCommand instanceof ClusterReceptionist.LocalServiceActorTerminated) {
            ClusterReceptionist.LocalServiceActorTerminated localServiceActorTerminated = (ClusterReceptionist.LocalServiceActorTerminated)internalCommand;
            akka.actor.typed.ActorRef serviceInstance = localServiceActorTerminated.ref();
            ClusterReceptionist.Entry entry = new ClusterReceptionist.Entry(serviceInstance, setup$2.selfSystemUid(), 0L);
            Set keys = (Set)state$1.servicesPerActor().getOrElse(serviceInstance, (Function0 & Serializable)() -> Predef$.MODULE$.Set().empty());
            package$LoggerOps$.MODULE$.debugN$extension(package$.MODULE$.LoggerOps(ctx$2.log()), "ClusterReceptionist [{}] - Registered actor terminated: [{}] [{}]", (Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{setup$2.cluster().selfAddress(), ((IterableOnceOps)keys.map((Function1 & Serializable)x$6 -> x$6.asServiceKey().id())).mkString(", "), entry}));
            keys.foreach((Function1 & Serializable)key -> {
                ClusterReceptionist$.$anonfun$behavior$18(state$1, setup$2, entry, key);
                return BoxedUnit.UNIT;
            });
            behavior = MODULE$.behavior(setup$2, state$1.addTombstone(serviceInstance, setup$2.newTombstoneDeadline()));
        } else if (internalCommand instanceof ClusterReceptionist.ChangeFromReplicator) {
            Behavior<Object> behavior2;
            ORMultiMap<ServiceKey<?>, ClusterReceptionist.Entry> value;
            ClusterReceptionist.ChangeFromReplicator changeFromReplicator = (ClusterReceptionist.ChangeFromReplicator)internalCommand;
            ORMultiMapKey<ServiceKey<?>, ClusterReceptionist.Entry> ddataKey = changeFromReplicator.key();
            ORMultiMap<ServiceKey<?>, ClusterReceptionist.Entry> newRegistry = value = changeFromReplicator.value();
            Set<AbstractServiceKey> changedKeys = state$1.registry().collectChangedKeys(ddataKey, newRegistry);
            ClusterReceptionist.State newState = state$1.copy(state$1.registry().withServiceRegistry(ddataKey, newRegistry), state$1.copy$default$2(), state$1.copy$default$3(), state$1.copy$default$4());
            if (changedKeys.nonEmpty()) {
                if (ctx$2.log().isDebugEnabled()) {
                    package$LoggerOps$.MODULE$.debugN$extension(package$.MODULE$.LoggerOps(ctx$2.log()), "ClusterReceptionist [{}] - Change from replicator: [{}], changes: [{}], tombstones [{}]", (Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{setup$2.cluster().selfAddress(), newRegistry.entries(), ((IterableOnceOps)changedKeys.map((Function1 & Serializable)key -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)key.asServiceKey().id()), (Object)ServiceRegistry$.MODULE$.entriesFor$extension(newRegistry, (AbstractServiceKey)key).mkString("[", ", ", "]")))).mkString(", "), state$1.tombstones().mkString(", ")}));
                }
                ClusterReceptionist$.notifySubscribers$1(changedKeys, true, newState, setup$2);
                changedKeys.foreach((Function1 & Serializable)changedKey -> {
                    ClusterReceptionist$.$anonfun$behavior$21(newRegistry, state$1, ctx$2, setup$2, ddataKey, changedKey);
                    return BoxedUnit.UNIT;
                });
                behavior2 = MODULE$.behavior(setup$2, newState);
            } else {
                behavior2 = Behaviors$.MODULE$.same();
            }
            behavior = behavior2;
        } else if (internalCommand instanceof ClusterReceptionist.NodeAdded) {
            Behavior<Object> behavior3;
            ClusterReceptionist.NodeAdded nodeAdded = (ClusterReceptionist.NodeAdded)internalCommand;
            UniqueAddress uniqueAddress = nodeAdded.addresses();
            if (state$1.registry().nodes().contains((Object)uniqueAddress)) {
                behavior3 = Behaviors$.MODULE$.same();
            } else {
                ClusterReceptionist.State newState = state$1.copy(state$1.registry().addNode(uniqueAddress), state$1.copy$default$2(), state$1.copy$default$3(), state$1.copy$default$4());
                Set<AbstractServiceKey> keysForNode = newState.registry().keysFor(uniqueAddress, setup$2.selfNodeAddress());
                if (keysForNode.nonEmpty()) {
                    package$LoggerOps$.MODULE$.debug2$extension(package$.MODULE$.LoggerOps(ctx$2.log()), "ClusterReceptionist [{}] - Node with registered services added [{}]", setup$2.cluster().selfAddress(), uniqueAddress);
                    ClusterReceptionist$.notifySubscribers$1(keysForNode, true, newState, setup$2);
                } else {
                    package$LoggerOps$.MODULE$.debug2$extension(package$.MODULE$.LoggerOps(ctx$2.log()), "ClusterReceptionist [{}] - Node added [{}]", setup$2.cluster().selfAddress(), uniqueAddress);
                }
                behavior3 = MODULE$.behavior(setup$2, newState);
            }
            behavior = behavior3;
        } else if (internalCommand instanceof ClusterReceptionist.NodeRemoved) {
            Behavior<Object> behavior4;
            UniqueAddress uniqueAddress;
            ClusterReceptionist.NodeRemoved nodeRemoved = (ClusterReceptionist.NodeRemoved)internalCommand;
            UniqueAddress uniqueAddress2 = uniqueAddress = nodeRemoved.addresses();
            UniqueAddress uniqueAddress3 = setup$2.selfUniqueAddress();
            if (!(uniqueAddress2 != null ? !((Object)uniqueAddress2).equals(uniqueAddress3) : uniqueAddress3 != null)) {
                ctx$2.log().debug("ClusterReceptionist [{}] - terminated/removed", (Object)setup$2.cluster().selfAddress());
                behavior4 = Behaviors$.MODULE$.stopped();
            } else if (state$1.registry().nodes().contains((Object)uniqueAddress)) {
                Set<AbstractServiceKey> keysForNode = state$1.registry().keysFor(uniqueAddress, setup$2.selfNodeAddress());
                ClusterReceptionist.State newState = state$1.copy(state$1.registry().removeNode(uniqueAddress), state$1.copy$default$2(), state$1.copy$default$3(), state$1.copy$default$4());
                if (keysForNode.nonEmpty()) {
                    package$LoggerOps$.MODULE$.debug2$extension(package$.MODULE$.LoggerOps(ctx$2.log()), "ClusterReceptionist [{}] - Node with registered services removed [{}]", setup$2.cluster().selfAddress(), uniqueAddress);
                    ClusterReceptionist$.notifySubscribers$1(keysForNode, true, newState, setup$2);
                }
                if (ClusterReceptionist$.isLeader$1(setup$2)) {
                    package$LoggerOps$.MODULE$.debug2$extension(package$.MODULE$.LoggerOps(ctx$2.log()), "ClusterReceptionist [{}] - Leader node observed removed node [{}]", setup$2.cluster().selfAddress(), uniqueAddress);
                    ClusterReceptionist$.nodesRemoved$1((Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new UniqueAddress[]{uniqueAddress})), false, setup$2, state$1, ctx$2);
                }
                behavior4 = MODULE$.behavior(setup$2, newState);
            } else {
                behavior4 = Behaviors$.MODULE$.same();
            }
            behavior = behavior4;
        } else if (internalCommand instanceof ClusterReceptionist.NodeUnreachable) {
            ClusterReceptionist.NodeUnreachable nodeUnreachable = (ClusterReceptionist.NodeUnreachable)internalCommand;
            UniqueAddress uniqueAddress = nodeUnreachable.addresses();
            Set<AbstractServiceKey> keysForNode = state$1.registry().keysFor(uniqueAddress, setup$2.selfNodeAddress());
            ClusterReceptionist.State newState = state$1.copy(state$1.registry().addUnreachable(uniqueAddress), state$1.copy$default$2(), state$1.copy$default$3(), state$1.copy$default$4());
            if (keysForNode.nonEmpty()) {
                package$LoggerOps$.MODULE$.debug2$extension(package$.MODULE$.LoggerOps(ctx$2.log()), "ClusterReceptionist [{}] - Node with registered services unreachable [{}]", setup$2.cluster().selfAddress(), uniqueAddress);
                ClusterReceptionist$.reachabilityChanged$1(keysForNode, newState, setup$2);
            }
            behavior = MODULE$.behavior(setup$2, newState);
        } else if (internalCommand instanceof ClusterReceptionist.NodeReachable) {
            ClusterReceptionist.NodeReachable nodeReachable = (ClusterReceptionist.NodeReachable)internalCommand;
            UniqueAddress uniqueAddress = nodeReachable.addresses();
            Set<AbstractServiceKey> keysForNode = state$1.registry().keysFor(uniqueAddress, setup$2.selfNodeAddress());
            ClusterReceptionist.State newState = state$1.copy(state$1.registry().removeUnreachable(uniqueAddress), state$1.copy$default$2(), state$1.copy$default$3(), state$1.copy$default$4());
            if (keysForNode.nonEmpty()) {
                package$LoggerOps$.MODULE$.debug2$extension(package$.MODULE$.LoggerOps(ctx$2.log()), "ClusterReceptionist [{}] - Node with registered services reachable again [{}]", setup$2.cluster().selfAddress(), uniqueAddress);
                ClusterReceptionist$.reachabilityChanged$1(keysForNode, newState, setup$2);
            }
            behavior = MODULE$.behavior(setup$2, newState);
        } else if (ClusterReceptionist$RemoveTick$.MODULE$.equals(internalCommand)) {
            Set<UniqueAddress> allAddressesInState;
            Set notInCluster;
            if (ClusterReceptionist$.isLeader$1(setup$2) && (notInCluster = (Set)(allAddressesInState = state$1.registry().allUniqueAddressesInState(setup$2.selfUniqueAddress())).diff(state$1.registry().nodes())).nonEmpty()) {
                if (ctx$2.log().isDebugEnabled()) {
                    package$LoggerOps$.MODULE$.debug2$extension(package$.MODULE$.LoggerOps(ctx$2.log()), "ClusterReceptionist [{}] - Leader node cleanup tick, removed nodes: [{}]", setup$2.cluster().selfAddress(), notInCluster.mkString(","));
                }
                ClusterReceptionist$.nodesRemoved$1(notInCluster, true, setup$2, state$1, ctx$2);
            }
            behavior = Behaviors$.MODULE$.same();
        } else if (ClusterReceptionist$PruneTombstonesTick$.MODULE$.equals(internalCommand)) {
            Behavior<Object> behavior5;
            ClusterReceptionist.State prunedState = state$1.pruneTombstones();
            if (prunedState == state$1) {
                behavior5 = Behaviors$.MODULE$.same();
            } else {
                ctx$2.log().debug("ClusterReceptionist [{}] - Pruning tombstones", (Object)setup$2.cluster().selfAddress());
                behavior5 = MODULE$.behavior(setup$2, prunedState);
            }
            behavior = behavior5;
        } else {
            throw new MatchError((Object)internalCommand);
        }
        return behavior;
    }

    private ClusterReceptionist$() {
    }
}

