/*
 * Decompiled with CFR 0.152.
 */
package akka.remote.serialization;

import akka.actor.ActorInitializationException;
import akka.actor.ActorRef;
import akka.actor.ExtendedActorSystem;
import akka.actor.InternalActorRef;
import akka.annotation.InternalApi;
import akka.dispatch.sysmsg.Create;
import akka.dispatch.sysmsg.DeathWatchNotification;
import akka.dispatch.sysmsg.Failed;
import akka.dispatch.sysmsg.NoMessage$;
import akka.dispatch.sysmsg.Recreate;
import akka.dispatch.sysmsg.Resume;
import akka.dispatch.sysmsg.Supervise;
import akka.dispatch.sysmsg.Suspend;
import akka.dispatch.sysmsg.SystemMessage;
import akka.dispatch.sysmsg.Terminate;
import akka.dispatch.sysmsg.Unwatch;
import akka.dispatch.sysmsg.Watch;
import akka.remote.ContainerFormats;
import akka.remote.SystemMessageFormats;
import akka.remote.serialization.WrappedPayloadSupport;
import akka.serialization.BaseSerializer;
import akka.serialization.Serialization;
import akka.serialization.Serialization$;
import akka.serialization.SerializationExtension$;
import akka.serialization.Serializer;
import java.io.NotSerializableException;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Product;
import scala.Some;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.Statics;

@ScalaSignature(bytes="\u0006\u0005\u0005]c\u0001B\b\u0011\u0001]A\u0001b\t\u0001\u0003\u0006\u0004%\t\u0001\n\u0005\tW\u0001\u0011\t\u0011)A\u0005K!)A\u0006\u0001C\u0001[!A\u0011\u0003\u0001EC\u0002\u0013%\u0011\u0007C\u00046\u0001\t\u0007I\u0011\u0002\u001c\t\ri\u0002\u0001\u0015!\u00038\u0011\u0015Y\u0004\u0001\"\u0011=\u0011\u0015\u0001\u0005\u0001\"\u0011B\u0011\u0015Q\u0005\u0001\"\u0011L\u0011\u0015Q\u0007\u0001\"\u0003l\u0011\u0015a\b\u0001\"\u0003~\u0011\u001d\tI\u0003\u0001C\u0005\u0003WAq!!\r\u0001\t\u0013\t\u0019\u0004C\u0004\u0002L\u0001!I!!\u0014\u0003/MK8\u000f^3n\u001b\u0016\u001c8/Y4f'\u0016\u0014\u0018.\u00197ju\u0016\u0014(BA\t\u0013\u00035\u0019XM]5bY&T\u0018\r^5p]*\u00111\u0003F\u0001\u0007e\u0016lw\u000e^3\u000b\u0003U\tA!Y6lC\u000e\u00011c\u0001\u0001\u0019=A\u0011\u0011\u0004H\u0007\u00025)\t1$A\u0003tG\u0006d\u0017-\u0003\u0002\u001e5\t1\u0011I\\=SK\u001a\u0004\"aH\u0011\u000e\u0003\u0001R!!\u0005\u000b\n\u0005\t\u0002#A\u0004\"bg\u0016\u001cVM]5bY&TXM]\u0001\u0007gf\u001cH/Z7\u0016\u0003\u0015\u0002\"AJ\u0015\u000e\u0003\u001dR!\u0001\u000b\u000b\u0002\u000b\u0005\u001cGo\u001c:\n\u0005):#aE#yi\u0016tG-\u001a3BGR|'oU=ti\u0016l\u0017aB:zgR,W\u000eI\u0001\u0007y%t\u0017\u000e\u001e \u0015\u00059\u0002\u0004CA\u0018\u0001\u001b\u0005\u0001\u0002\"B\u0012\u0004\u0001\u0004)S#\u0001\u001a\u0011\u0005}\u0019\u0014B\u0001\u001b!\u00055\u0019VM]5bY&T\u0018\r^5p]\u0006q\u0001/Y=m_\u0006$7+\u001e9q_J$X#A\u001c\u0011\u0005=B\u0014BA\u001d\u0011\u0005U9&/\u00199qK\u0012\u0004\u0016-\u001f7pC\u0012\u001cV\u000f\u001d9peR\fq\u0002]1zY>\fGmU;qa>\u0014H\u000fI\u0001\u0010S:\u001cG.\u001e3f\u001b\u0006t\u0017NZ3tiV\tQ\b\u0005\u0002\u001a}%\u0011qH\u0007\u0002\b\u0005>|G.Z1o\u0003!!xNQ5oCJLHC\u0001\"I!\rI2)R\u0005\u0003\tj\u0011Q!\u0011:sCf\u0004\"!\u0007$\n\u0005\u001dS\"\u0001\u0002\"zi\u0016DQ!\u0013\u0005A\u0002a\t\u0011a\\\u0001\u000bMJ|WNQ5oCJLHc\u0001\rM\u001d\")Q*\u0003a\u0001\u0005\u0006)!-\u001f;fg\")q*\u0003a\u0001!\u0006AQ.\u00198jM\u0016\u001cH\u000fE\u0002\u001a#NK!A\u0015\u000e\u0003\r=\u0003H/[8oa\t!\u0016\rE\u0002V9~s!A\u0016.\u0011\u0005]SR\"\u0001-\u000b\u0005e3\u0012A\u0002\u001fs_>$h(\u0003\u0002\\5\u00051\u0001K]3eK\u001aL!!\u00180\u0003\u000b\rc\u0017m]:\u000b\u0005mS\u0002C\u00011b\u0019\u0001!\u0011B\u0019(\u0002\u0002\u0003\u0005)\u0011A2\u0003\u0007}#\u0013'\u0005\u0002eOB\u0011\u0011$Z\u0005\u0003Mj\u0011qAT8uQ&tw\r\u0005\u0002\u001aQ&\u0011\u0011N\u0007\u0002\u0004\u0003:L\u0018\u0001\u00073fg\u0016\u0014\u0018.\u00197ju\u0016\u001c\u0016p\u001d;f[6+7o]1hKR\u0011A\u000e\u001e\t\u0003[Jl\u0011A\u001c\u0006\u0003_B\faa]=t[N<'BA9\u0015\u0003!!\u0017n\u001d9bi\u000eD\u0017BA:o\u00055\u0019\u0016p\u001d;f[6+7o]1hK\")qN\u0003a\u0001kB\u0011aO\u001f\b\u0003obl\u0011AE\u0005\u0003sJ\tAcU=ti\u0016lW*Z:tC\u001e,gi\u001c:nCR\u001c\u0018BA:|\u0015\tI(#\u0001\ntKJL\u0017\r\\5{KRC'o\\<bE2,Gc\u0001@\u0002\u0014A\u0019q0!\u0004\u000f\t\u0005\u0005\u0011q\u0001\b\u0004o\u0006\r\u0011bAA\u0003%\u0005\u00012i\u001c8uC&tWM\u001d$pe6\fGo]\u0005\u0005\u0003\u0013\tY!A\u0004QCfdw.\u00193\u000b\u0007\u0005\u0015!#\u0003\u0003\u0002\u0010\u0005E!a\u0002\"vS2$WM\u001d\u0006\u0005\u0003\u0013\tY\u0001C\u0004\u0002\u0016-\u0001\r!a\u0006\u0002\u0013QD'o\\<bE2,\u0007\u0003BA\r\u0003GqA!a\u0007\u0002 9\u0019q+!\b\n\u0003mI1!!\t\u001b\u0003\u001d\u0001\u0018mY6bO\u0016LA!!\n\u0002(\tIA\u000b\u001b:po\u0006\u0014G.\u001a\u0006\u0004\u0003CQ\u0012!E4fi\u000e\u000bWo]3UQJ|w/\u00192mKR!\u0011qCA\u0017\u0011\u0019\ty\u0003\u0004a\u0001k\u0006\u0019Qn]4\u0002#M,'/[1mSj,\u0017i\u0019;peJ+g\r\u0006\u0003\u00026\u0005\u0005\u0003\u0003BA\u001c\u0003{qA!!\u0001\u0002:%!\u00111HA\u0006\u0003!\t5\r^8s%\u00164\u0017\u0002BA\b\u0003\u007fQA!a\u000f\u0002\f!9\u00111I\u0007A\u0002\u0005\u0015\u0013\u0001C1di>\u0014(+\u001a4\u0011\u0007\u0019\n9%C\u0002\u0002J\u001d\u0012\u0001\"Q2u_J\u0014VMZ\u0001\u0014I\u0016\u001cXM]5bY&TX-Q2u_J\u0014VM\u001a\u000b\u0005\u0003\u000b\ny\u0005C\u0004\u0002R9\u0001\r!a\u0015\u0002\u001bM,'/[1mSj,GMU3g!\u0011\t\t!!\u0016\n\t\u0005%\u00131\u0002")
public class SystemMessageSerializer
implements BaseSerializer {
    private Serialization serialization;
    private final ExtendedActorSystem system;
    private final WrappedPayloadSupport payloadSupport;
    private int identifier;
    private volatile boolean bitmap$0;

    @Override
    @InternalApi
    public int identifierFromConfig() {
        return BaseSerializer.identifierFromConfig$(this);
    }

    @Override
    public final Object fromBinary(byte[] bytes) {
        return Serializer.fromBinary$(this, bytes);
    }

    @Override
    public final Object fromBinary(byte[] bytes, Class<?> clazz) throws NotSerializableException {
        return Serializer.fromBinary$(this, bytes, clazz);
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public void akka$serialization$BaseSerializer$_setter_$identifier_$eq(int x$1) {
        this.identifier = x$1;
    }

    @Override
    public ExtendedActorSystem system() {
        return this.system;
    }

    private Serialization serialization$lzycompute() {
        SystemMessageSerializer systemMessageSerializer = this;
        synchronized (systemMessageSerializer) {
            if (!this.bitmap$0) {
                this.serialization = (Serialization)SerializationExtension$.MODULE$.apply(this.system());
                this.bitmap$0 = true;
            }
        }
        return this.serialization;
    }

    private Serialization serialization() {
        return !this.bitmap$0 ? this.serialization$lzycompute() : this.serialization;
    }

    private WrappedPayloadSupport payloadSupport() {
        return this.payloadSupport;
    }

    @Override
    public boolean includeManifest() {
        return false;
    }

    @Override
    public byte[] toBinary(Object o) {
        SystemMessageFormats.SystemMessage.Builder builder;
        SystemMessageFormats.SystemMessage.Builder builder2 = SystemMessageFormats.SystemMessage.newBuilder();
        SystemMessage systemMessage = (SystemMessage)o;
        if (systemMessage instanceof Create) {
            Object object;
            Create create = (Create)systemMessage;
            Option<ActorInitializationException> failure = create.failure();
            builder2.setType(SystemMessageFormats.SystemMessage.Type.CREATE);
            Option<ActorInitializationException> option = failure;
            if (option instanceof Some) {
                Some some = (Some)option;
                ActorInitializationException throwable = (ActorInitializationException)some.value();
                object = builder2.setCauseData(this.serializeThrowable(throwable));
            } else if (None$.MODULE$.equals(option)) {
                object = BoxedUnit.UNIT;
            } else {
                throw new MatchError(option);
            }
            builder = object;
        } else if (systemMessage instanceof Recreate) {
            Recreate recreate = (Recreate)systemMessage;
            Throwable cause = recreate.cause();
            builder2.setType(SystemMessageFormats.SystemMessage.Type.RECREATE);
            builder = builder2.setCauseData(this.serializeThrowable(cause));
        } else if (systemMessage instanceof Suspend) {
            builder = builder2.setType(SystemMessageFormats.SystemMessage.Type.SUSPEND);
        } else if (systemMessage instanceof Resume) {
            Resume resume = (Resume)systemMessage;
            Throwable cause = resume.causedByFailure();
            builder2.setType(SystemMessageFormats.SystemMessage.Type.RESUME);
            builder = builder2.setCauseData(this.serializeThrowable(cause));
        } else if (systemMessage instanceof Terminate) {
            builder = builder2.setType(SystemMessageFormats.SystemMessage.Type.TERMINATE);
        } else if (systemMessage instanceof Supervise) {
            Supervise supervise = (Supervise)systemMessage;
            ActorRef child = supervise.child();
            boolean async = supervise.async();
            builder2.setType(SystemMessageFormats.SystemMessage.Type.SUPERVISE);
            SystemMessageFormats.SuperviseData.Builder superviseData = SystemMessageFormats.SuperviseData.newBuilder().setChild(this.serializeActorRef(child)).setAsync(async);
            builder = builder2.setSuperviseData(superviseData);
        } else if (systemMessage instanceof Watch) {
            Watch watch = (Watch)systemMessage;
            InternalActorRef watchee = watch.watchee();
            InternalActorRef watcher = watch.watcher();
            builder2.setType(SystemMessageFormats.SystemMessage.Type.WATCH);
            SystemMessageFormats.WatchData.Builder watchData = SystemMessageFormats.WatchData.newBuilder().setWatchee(this.serializeActorRef(watchee)).setWatcher(this.serializeActorRef(watcher));
            builder = builder2.setWatchData(watchData);
        } else if (systemMessage instanceof Unwatch) {
            Unwatch unwatch = (Unwatch)systemMessage;
            ActorRef watchee = unwatch.watchee();
            ActorRef watcher = unwatch.watcher();
            builder2.setType(SystemMessageFormats.SystemMessage.Type.UNWATCH);
            SystemMessageFormats.WatchData.Builder watchData = SystemMessageFormats.WatchData.newBuilder().setWatchee(this.serializeActorRef(watchee)).setWatcher(this.serializeActorRef(watcher));
            builder = builder2.setWatchData(watchData);
        } else if (systemMessage instanceof Failed) {
            Failed failed = (Failed)systemMessage;
            ActorRef child = failed.child();
            Throwable cause = failed.cause();
            int uid = failed.uid();
            builder2.setType(SystemMessageFormats.SystemMessage.Type.FAILED);
            SystemMessageFormats.FailedData.Builder failedData = SystemMessageFormats.FailedData.newBuilder().setChild(this.serializeActorRef(child)).setUid(uid);
            builder2.setCauseData(this.serializeThrowable(cause));
            builder = builder2.setFailedData(failedData);
        } else if (systemMessage instanceof DeathWatchNotification) {
            DeathWatchNotification deathWatchNotification = (DeathWatchNotification)systemMessage;
            ActorRef actor = deathWatchNotification.actor();
            boolean existenceConfirmed = deathWatchNotification.existenceConfirmed();
            boolean addressTerminated = deathWatchNotification.addressTerminated();
            builder2.setType(SystemMessageFormats.SystemMessage.Type.DEATHWATCH_NOTIFICATION);
            SystemMessageFormats.DeathWatchNotificationData.Builder deathWatchNotificationData = SystemMessageFormats.DeathWatchNotificationData.newBuilder().setActor(this.serializeActorRef(actor)).setExistenceConfirmed(existenceConfirmed).setAddressTerminated(addressTerminated);
            builder = builder2.setDwNotificationData(deathWatchNotificationData);
        } else {
            if (NoMessage$.MODULE$.equals(systemMessage)) {
                throw new IllegalArgumentException("NoMessage should never be serialized or deserialized");
            }
            throw new MatchError((Object)systemMessage);
        }
        return builder2.build().toByteArray();
    }

    @Override
    public Object fromBinary(byte[] bytes, Option<Class<?>> manifest) {
        return this.deserializeSystemMessage(SystemMessageFormats.SystemMessage.parseFrom(bytes));
    }

    private SystemMessage deserializeSystemMessage(SystemMessageFormats.SystemMessage sysmsg) {
        Product product;
        SystemMessageFormats.SystemMessage.Type type = sysmsg.getType();
        if (SystemMessageFormats.SystemMessage.Type.CREATE.equals(type)) {
            None$ cause = sysmsg.hasCauseData() ? new Some((Object)((ActorInitializationException)this.getCauseThrowable(sysmsg))) : None$.MODULE$;
            product = new Create((Option<ActorInitializationException>)cause);
        } else if (SystemMessageFormats.SystemMessage.Type.RECREATE.equals(type)) {
            product = new Recreate(this.getCauseThrowable(sysmsg));
        } else if (SystemMessageFormats.SystemMessage.Type.SUSPEND.equals(type)) {
            product = new Suspend();
        } else if (SystemMessageFormats.SystemMessage.Type.RESUME.equals(type)) {
            product = new Resume(this.getCauseThrowable(sysmsg));
        } else if (SystemMessageFormats.SystemMessage.Type.TERMINATE.equals(type)) {
            product = new Terminate();
        } else if (SystemMessageFormats.SystemMessage.Type.SUPERVISE.equals(type)) {
            product = new Supervise(this.deserializeActorRef(sysmsg.getSuperviseData().getChild()), sysmsg.getSuperviseData().getAsync());
        } else if (SystemMessageFormats.SystemMessage.Type.WATCH.equals(type)) {
            product = new Watch((InternalActorRef)this.deserializeActorRef(sysmsg.getWatchData().getWatchee()), (InternalActorRef)this.deserializeActorRef(sysmsg.getWatchData().getWatcher()));
        } else if (SystemMessageFormats.SystemMessage.Type.UNWATCH.equals(type)) {
            product = new Unwatch((InternalActorRef)this.deserializeActorRef(sysmsg.getWatchData().getWatchee()), (InternalActorRef)this.deserializeActorRef(sysmsg.getWatchData().getWatcher()));
        } else if (SystemMessageFormats.SystemMessage.Type.FAILED.equals(type)) {
            product = new Failed(this.deserializeActorRef(sysmsg.getFailedData().getChild()), this.getCauseThrowable(sysmsg), (int)sysmsg.getFailedData().getUid());
        } else if (SystemMessageFormats.SystemMessage.Type.DEATHWATCH_NOTIFICATION.equals(type)) {
            product = new DeathWatchNotification(this.deserializeActorRef(sysmsg.getDwNotificationData().getActor()), sysmsg.getDwNotificationData().getExistenceConfirmed(), sysmsg.getDwNotificationData().getAddressTerminated());
        } else {
            throw new MatchError((Object)type);
        }
        return product;
    }

    private ContainerFormats.Payload.Builder serializeThrowable(Throwable throwable) {
        return this.payloadSupport().payloadBuilder(throwable);
    }

    private Throwable getCauseThrowable(SystemMessageFormats.SystemMessage msg) {
        return (Throwable)this.payloadSupport().deserializePayload(msg.getCauseData());
    }

    private ContainerFormats.ActorRef.Builder serializeActorRef(ActorRef actorRef2) {
        return ContainerFormats.ActorRef.newBuilder().setPath(Serialization$.MODULE$.serializedActorPath(actorRef2));
    }

    private ActorRef deserializeActorRef(ContainerFormats.ActorRef serializedRef) {
        return this.serialization().system().provider().resolveActorRef(serializedRef.getPath());
    }

    public SystemMessageSerializer(ExtendedActorSystem system) {
        this.system = system;
        Serializer.$init$(this);
        BaseSerializer.$init$(this);
        this.payloadSupport = new WrappedPayloadSupport(system);
        Statics.releaseFence();
    }
}

