/*
 * Decompiled with CFR 0.152.
 */
package akka.remote.serialization;

import akka.event.LoggingAdapter;
import akka.protobufv3.internal.ByteString;
import akka.remote.ByteStringUtils$;
import akka.remote.ContainerFormats;
import akka.remote.serialization.ThrowableNotSerializableException;
import akka.serialization.ByteBufferSerializer;
import akka.serialization.DisabledJavaSerializer;
import akka.serialization.Serialization;
import akka.serialization.Serializer;
import akka.serialization.SerializerWithStringManifest;
import akka.serialization.Serializers$;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import scala.Predef$;
import scala.collection.StringOps$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class WrappedPayloadSupport$ {
    public static final WrappedPayloadSupport$ MODULE$ = new WrappedPayloadSupport$();

    /*
     * Enabled aggressive block sorting
     */
    public ContainerFormats.Payload.Builder payloadBuilder(Object input, Serialization serialization, LoggingAdapter log) {
        BoxedUnit boxedUnit;
        Object payload = input;
        ContainerFormats.Payload.Builder builder = ContainerFormats.Payload.newBuilder();
        Serializer serializer = serialization.findSerializerFor(payload);
        Object object = payload;
        if (object instanceof Throwable) {
            Throwable throwable = (Throwable)object;
            if (serializer instanceof DisabledJavaSerializer) {
                ThrowableNotSerializableException notSerializableException = new ThrowableNotSerializableException(throwable.getMessage(), throwable.getClass().getName(), throwable.getCause());
                log.debug("Couldn't serialize [{}] because Java serialization is disabled. Fallback to ThrowableNotSerializableException. {}", notSerializableException.originalClassName(), notSerializableException.originalMessage());
                Serializer serializer2 = serialization.findSerializerFor(notSerializableException);
                builder.setEnclosedMessage(ByteStringUtils$.MODULE$.toProtoByteStringUnsafe(serializer2.toBinary(notSerializableException))).setSerializerId(serializer2.identifier());
                String manifest = Serializers$.MODULE$.manifestFor(serializer2, notSerializableException);
                boxedUnit = StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(manifest)) ? builder.setMessageManifest(ByteString.copyFromUtf8(manifest)) : BoxedUnit.UNIT;
                return builder;
            }
        }
        builder.setEnclosedMessage(ByteStringUtils$.MODULE$.toProtoByteStringUnsafe(serializer.toBinary(payload))).setSerializerId(serializer.identifier());
        String manifest = Serializers$.MODULE$.manifestFor(serializer, payload);
        boxedUnit = StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(manifest)) ? builder.setMessageManifest(ByteString.copyFromUtf8(manifest)) : BoxedUnit.UNIT;
        return builder;
    }

    public Object deserializePayload(ContainerFormats.Payload payload, Serialization serialization) {
        Object object;
        String manifest = payload.hasMessageManifest() ? payload.getMessageManifest().toStringUtf8() : "";
        Serializer serializer = (Serializer)serialization.serializerByIdentity().apply((Object)BoxesRunTime.boxToInteger((int)payload.getSerializerId()));
        if (serializer instanceof ByteBufferSerializer) {
            Serializer serializer2 = serializer;
            ByteBuffer buffer = payload.getEnclosedMessage().asReadOnlyByteBuffer();
            buffer.order(ByteOrder.LITTLE_ENDIAN);
            object = ((ByteBufferSerializer)((Object)serializer2)).fromBinary(buffer, manifest);
        } else if (serializer instanceof SerializerWithStringManifest) {
            SerializerWithStringManifest serializerWithStringManifest = (SerializerWithStringManifest)serializer;
            object = serializerWithStringManifest.fromBinary(payload.getEnclosedMessage().toByteArray(), manifest);
        } else {
            object = serialization.deserialize(payload.getEnclosedMessage().toByteArray(), payload.getSerializerId(), manifest).get();
        }
        return object;
    }

    private WrappedPayloadSupport$() {
    }
}

