/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.raft;

import akka.actor.ActorRef;
import akka.actor.ActorSelection;
import akka.actor.ActorSystem;
import akka.actor.Props;
import akka.cluster.Cluster;
import com.google.common.annotations.VisibleForTesting;
import java.util.Collection;
import java.util.Optional;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import java.util.function.LongSupplier;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.controller.cluster.DataPersistenceProvider;
import org.opendaylight.controller.cluster.io.FileBackedOutputStreamFactory;
import org.opendaylight.controller.cluster.raft.ConfigParams;
import org.opendaylight.controller.cluster.raft.ElectionTerm;
import org.opendaylight.controller.cluster.raft.PeerInfo;
import org.opendaylight.controller.cluster.raft.RaftActorLeadershipTransferCohort;
import org.opendaylight.controller.cluster.raft.ReplicatedLog;
import org.opendaylight.controller.cluster.raft.SnapshotManager;
import org.opendaylight.controller.cluster.raft.VotingState;
import org.opendaylight.controller.cluster.raft.base.messages.ApplyState;
import org.opendaylight.controller.cluster.raft.behaviors.RaftActorBehavior;
import org.opendaylight.controller.cluster.raft.persisted.ServerConfigurationPayload;
import org.opendaylight.controller.cluster.raft.policy.RaftPolicy;
import org.slf4j.Logger;

public interface RaftActorContext {
    public ActorRef actorOf(Props var1);

    public ActorSelection actorSelection(String var1);

    public String getId();

    public ActorRef getActor();

    public @NonNull Executor getExecutor();

    public Optional<Cluster> getCluster();

    public @NonNull ElectionTerm getTermInformation();

    public long getCommitIndex();

    public void setCommitIndex(long var1);

    public long getLastApplied();

    public void setLastApplied(long var1);

    public void setReplicatedLog(@NonNull ReplicatedLog var1);

    public @NonNull ReplicatedLog getReplicatedLog();

    public @NonNull ActorSystem getActorSystem();

    public @NonNull Logger getLogger();

    public @Nullable String getPeerAddress(String var1);

    public void updatePeerIds(ServerConfigurationPayload var1);

    public @NonNull Collection<PeerInfo> getPeers();

    public @NonNull Collection<String> getPeerIds();

    public @Nullable PeerInfo getPeerInfo(String var1);

    public void addToPeers(String var1, String var2, VotingState var3);

    public void removePeer(String var1);

    public @Nullable ActorSelection getPeerActorSelection(String var1);

    public void setPeerAddress(String var1, String var2);

    public @NonNull ConfigParams getConfigParams();

    public @NonNull SnapshotManager getSnapshotManager();

    public @NonNull DataPersistenceProvider getPersistenceProvider();

    public boolean hasFollowers();

    public long getTotalMemory();

    @VisibleForTesting
    public void setTotalMemoryRetriever(LongSupplier var1);

    public short getPayloadVersion();

    public @NonNull RaftPolicy getRaftPolicy();

    public boolean isDynamicServerConfigurationInUse();

    public void setDynamicServerConfigurationInUse();

    public @Nullable ServerConfigurationPayload getPeerServerInfo(boolean var1);

    public boolean isVotingMember();

    public boolean anyVotingPeers();

    public RaftActorBehavior getCurrentBehavior();

    public Consumer<ApplyState> getApplyStateConsumer();

    public @NonNull FileBackedOutputStreamFactory getFileBackedOutputStreamFactory();

    public @Nullable RaftActorLeadershipTransferCohort getRaftActorLeadershipTransferCohort();

    public void setRaftActorLeadershipTransferCohort(@Nullable RaftActorLeadershipTransferCohort var1);
}

