/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.raft.messages;

import com.google.common.base.Verify;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Objects;
import org.opendaylight.controller.cluster.raft.messages.AppendEntriesReply;
import org.opendaylight.yangtools.concepts.WritableObjects;

final class AR
implements Externalizable {
    private static final long serialVersionUID = 1L;
    private static final int SUCCESS = 16;
    private static final int FORCE_INSTALL_SNAPSHOT = 32;
    private static final int NEEDS_LEADER_ADDRESS = 64;
    private AppendEntriesReply appendEntriesReply;

    public AR() {
    }

    AR(AppendEntriesReply appendEntriesReply) {
        this.appendEntriesReply = Objects.requireNonNull(appendEntriesReply);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeShort(this.appendEntriesReply.getRaftVersion());
        int flags = 0;
        if (this.appendEntriesReply.isSuccess()) {
            flags |= 0x10;
        }
        if (this.appendEntriesReply.isForceInstallSnapshot()) {
            flags |= 0x20;
        }
        if (this.appendEntriesReply.isNeedsLeaderAddress()) {
            flags |= 0x40;
        }
        WritableObjects.writeLong((DataOutput)out, (long)this.appendEntriesReply.getTerm(), (int)flags);
        out.writeObject(this.appendEntriesReply.getFollowerId());
        WritableObjects.writeLongs((DataOutput)out, (long)this.appendEntriesReply.getLogLastIndex(), (long)this.appendEntriesReply.getLogLastTerm());
        out.writeShort(this.appendEntriesReply.getPayloadVersion());
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        short raftVersion = in.readShort();
        byte hdr = WritableObjects.readLongHeader((DataInput)in);
        int flags = WritableObjects.longHeaderFlags((byte)hdr);
        long term = WritableObjects.readLongBody((DataInput)in, (byte)hdr);
        String followerId = (String)in.readObject();
        hdr = WritableObjects.readLongHeader((DataInput)in);
        long logLastIndex = WritableObjects.readFirstLong((DataInput)in, (byte)hdr);
        long logLastTerm = WritableObjects.readSecondLong((DataInput)in, (byte)hdr);
        short payloadVersion = in.readShort();
        this.appendEntriesReply = new AppendEntriesReply(followerId, term, AR.getFlag(flags, 16), logLastIndex, logLastTerm, payloadVersion, AR.getFlag(flags, 32), AR.getFlag(flags, 64), raftVersion, 5);
    }

    private Object readResolve() {
        return Verify.verifyNotNull((Object)this.appendEntriesReply);
    }

    private static boolean getFlag(int flags, int bit) {
        return (flags & bit) != 0;
    }
}

