/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.raft.messages;

import com.google.common.base.Verify;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Objects;
import org.opendaylight.controller.cluster.raft.messages.InstallSnapshotReply;
import org.opendaylight.yangtools.concepts.WritableObjects;

final class IR
implements Externalizable {
    private static final long serialVersionUID = 1L;
    private static final int SUCCESS = 16;
    private InstallSnapshotReply installSnapshotReply;

    public IR() {
    }

    IR(InstallSnapshotReply installSnapshotReply) {
        this.installSnapshotReply = Objects.requireNonNull(installSnapshotReply);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        WritableObjects.writeLong((DataOutput)out, (long)this.installSnapshotReply.getTerm(), (int)(this.installSnapshotReply.isSuccess() ? 16 : 0));
        out.writeObject(this.installSnapshotReply.getFollowerId());
        out.writeInt(this.installSnapshotReply.getChunkIndex());
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        byte hdr = WritableObjects.readLongHeader((DataInput)in);
        int flags = WritableObjects.longHeaderFlags((byte)hdr);
        long term = WritableObjects.readLongBody((DataInput)in, (byte)hdr);
        String followerId = (String)in.readObject();
        int chunkIndex = in.readInt();
        this.installSnapshotReply = new InstallSnapshotReply(term, followerId, chunkIndex, (flags & 0x10) != 0);
    }

    private Object readResolve() {
        return Verify.verifyNotNull((Object)this.installSnapshotReply);
    }
}

