/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.raft.messages;

import com.google.common.annotations.VisibleForTesting;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Optional;
import java.util.OptionalInt;
import org.opendaylight.controller.cluster.raft.messages.AbstractRaftRPC;
import org.opendaylight.controller.cluster.raft.messages.IS;
import org.opendaylight.controller.cluster.raft.persisted.ServerConfigurationPayload;

public final class InstallSnapshot
extends AbstractRaftRPC {
    private static final long serialVersionUID = 1L;
    private final String leaderId;
    private final long lastIncludedIndex;
    private final long lastIncludedTerm;
    private final byte[] data;
    private final int chunkIndex;
    private final int totalChunks;
    @SuppressFBWarnings(value={"SE_BAD_FIELD"}, justification="Handled via writeReplace()")
    private final OptionalInt lastChunkHashCode;
    @SuppressFBWarnings(value={"SE_BAD_FIELD"}, justification="Handled via writeReplace()")
    private final Optional<ServerConfigurationPayload> serverConfig;
    private final short recipientRaftVersion;

    @SuppressFBWarnings(value={"EI_EXPOSE_REP2"}, justification="Stores a reference to an externally mutable byte[] object but this is OK since this class is merely a DTO and does not process byte[] internally. Also it would be inefficient to create a copy as the byte[] could be large.")
    public InstallSnapshot(long term, String leaderId, long lastIncludedIndex, long lastIncludedTerm, byte[] data, int chunkIndex, int totalChunks, OptionalInt lastChunkHashCode, Optional<ServerConfigurationPayload> serverConfig, short recipientRaftVersion) {
        super(term);
        this.leaderId = leaderId;
        this.lastIncludedIndex = lastIncludedIndex;
        this.lastIncludedTerm = lastIncludedTerm;
        this.data = data;
        this.chunkIndex = chunkIndex;
        this.totalChunks = totalChunks;
        this.lastChunkHashCode = lastChunkHashCode;
        this.serverConfig = serverConfig;
        this.recipientRaftVersion = recipientRaftVersion;
    }

    @VisibleForTesting
    public InstallSnapshot(long term, String leaderId, long lastIncludedIndex, long lastIncludedTerm, byte[] data, int chunkIndex, int totalChunks) {
        this(term, leaderId, lastIncludedIndex, lastIncludedTerm, data, chunkIndex, totalChunks, OptionalInt.empty(), Optional.empty(), 5);
    }

    public String getLeaderId() {
        return this.leaderId;
    }

    public long getLastIncludedIndex() {
        return this.lastIncludedIndex;
    }

    public long getLastIncludedTerm() {
        return this.lastIncludedTerm;
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="Exposes a mutable object stored in a field but this is OK since this class is merely a DTO and does not process the byte[] internally. Also it would be inefficient to create a return copy as the byte[] could be large.")
    public byte[] getData() {
        return this.data;
    }

    public int getChunkIndex() {
        return this.chunkIndex;
    }

    public int getTotalChunks() {
        return this.totalChunks;
    }

    public OptionalInt getLastChunkHashCode() {
        return this.lastChunkHashCode;
    }

    public Optional<ServerConfigurationPayload> getServerConfig() {
        return this.serverConfig;
    }

    public String toString() {
        return "InstallSnapshot [term=" + this.getTerm() + ", leaderId=" + this.leaderId + ", lastIncludedIndex=" + this.lastIncludedIndex + ", lastIncludedTerm=" + this.lastIncludedTerm + ", datasize=" + this.data.length + ", Chunk=" + this.chunkIndex + "/" + this.totalChunks + ", lastChunkHashCode=" + this.lastChunkHashCode + ", serverConfig=" + this.serverConfig.orElse(null) + "]";
    }

    @Override
    Object writeReplace() {
        return this.recipientRaftVersion <= 4 ? new Proxy(this) : new IS(this);
    }

    private static class Proxy
    implements Externalizable {
        private static final long serialVersionUID = 1L;
        private InstallSnapshot installSnapshot;

        public Proxy() {
        }

        Proxy(InstallSnapshot installSnapshot) {
            this.installSnapshot = installSnapshot;
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeLong(this.installSnapshot.getTerm());
            out.writeObject(this.installSnapshot.leaderId);
            out.writeLong(this.installSnapshot.lastIncludedIndex);
            out.writeLong(this.installSnapshot.lastIncludedTerm);
            out.writeInt(this.installSnapshot.chunkIndex);
            out.writeInt(this.installSnapshot.totalChunks);
            out.writeByte(this.installSnapshot.lastChunkHashCode.isPresent() ? 1 : 0);
            if (this.installSnapshot.lastChunkHashCode.isPresent()) {
                out.writeInt(this.installSnapshot.lastChunkHashCode.orElseThrow());
            }
            out.writeByte(this.installSnapshot.serverConfig.isPresent() ? 1 : 0);
            if (this.installSnapshot.serverConfig.isPresent()) {
                out.writeObject(this.installSnapshot.serverConfig.orElseThrow());
            }
            out.writeObject(this.installSnapshot.data);
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            long term = in.readLong();
            String leaderId = (String)in.readObject();
            long lastIncludedIndex = in.readLong();
            long lastIncludedTerm = in.readLong();
            int chunkIndex = in.readInt();
            int totalChunks = in.readInt();
            OptionalInt lastChunkHashCode = in.readByte() == 1 ? OptionalInt.of(in.readInt()) : OptionalInt.empty();
            Optional<ServerConfigurationPayload> serverConfig = in.readByte() == 1 ? Optional.of((ServerConfigurationPayload)in.readObject()) : Optional.empty();
            byte[] data = (byte[])in.readObject();
            this.installSnapshot = new InstallSnapshot(term, leaderId, lastIncludedIndex, lastIncludedTerm, data, chunkIndex, totalChunks, lastChunkHashCode, serverConfig, 5);
        }

        private Object readResolve() {
            return this.installSnapshot;
        }
    }
}

