/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.raft.messages;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Objects;
import org.opendaylight.controller.cluster.raft.messages.RequestVote;
import org.opendaylight.yangtools.concepts.WritableObjects;

final class RV
implements Externalizable {
    private static final long serialVersionUID = 1L;
    private RequestVote requestVote;

    public RV() {
    }

    RV(RequestVote requestVote) {
        this.requestVote = Objects.requireNonNull(requestVote);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        WritableObjects.writeLong((DataOutput)out, (long)this.requestVote.getTerm());
        out.writeObject(this.requestVote.getCandidateId());
        WritableObjects.writeLongs((DataOutput)out, (long)this.requestVote.getLastLogIndex(), (long)this.requestVote.getLastLogTerm());
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        long term = WritableObjects.readLong((DataInput)in);
        String candidateId = (String)in.readObject();
        byte hdr = WritableObjects.readLongHeader((DataInput)in);
        long lastLogIndex = WritableObjects.readFirstLong((DataInput)in, (byte)hdr);
        long lastLogTerm = WritableObjects.readSecondLong((DataInput)in, (byte)hdr);
        this.requestVote = new RequestVote(term, candidateId, lastLogIndex, lastLogTerm);
    }

    private Object readResolve() {
        return this.requestVote;
    }
}

