/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.akka.segjournal;

import akka.actor.ActorSystem;
import akka.persistence.AtomicWrite;
import akka.persistence.PersistentRepr;
import com.codahale.metrics.Histogram;
import com.google.common.base.VerifyException;
import io.atomix.storage.journal.Indexed;
import io.atomix.storage.journal.JournalReader;
import io.atomix.storage.journal.JournalSerdes;
import io.atomix.storage.journal.JournalWriter;
import io.atomix.storage.journal.SegmentedJournal;
import io.atomix.storage.journal.StorageLevel;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.opendaylight.controller.akka.segjournal.DataJournal;
import org.opendaylight.controller.akka.segjournal.DataJournalEntry;
import org.opendaylight.controller.akka.segjournal.DataJournalEntrySerdes;
import org.opendaylight.controller.akka.segjournal.SegmentedJournalActor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.collection.Seq;
import scala.jdk.javaapi.CollectionConverters;

final class DataJournalV0
extends DataJournal {
    private static final Logger LOG = LoggerFactory.getLogger(DataJournalV0.class);
    private final SegmentedJournal<DataJournalEntry> entries;

    DataJournalV0(String persistenceId, Histogram messageSize, ActorSystem system, StorageLevel storage, File directory, int maxEntrySize, int maxSegmentSize) {
        super(persistenceId, messageSize);
        this.entries = SegmentedJournal.builder().withStorageLevel(storage).withDirectory(directory).withName("data").withNamespace(JournalSerdes.builder().register((JournalSerdes.EntrySerdes)new DataJournalEntrySerdes(system), new Class[]{DataJournalEntry.FromPersistence.class, DataJournalEntry.ToPersistence.class}).build()).withMaxEntrySize(maxEntrySize).withMaxSegmentSize(maxSegmentSize).build();
    }

    @Override
    long lastWrittenSequenceNr() {
        return this.entries.writer().getLastIndex();
    }

    @Override
    void deleteTo(long sequenceNr) {
        this.entries.writer().commit(sequenceNr);
    }

    @Override
    void compactTo(long sequenceNr) {
        this.entries.compact(sequenceNr + 1L);
    }

    @Override
    void close() {
        this.flush();
        this.entries.close();
    }

    @Override
    void flush() {
        this.entries.writer().flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void handleReplayMessages(SegmentedJournalActor.ReplayMessages message, long fromSequenceNr) {
        try (JournalReader reader = this.entries.openReader(fromSequenceNr);){
            this.handleReplayMessages((JournalReader<DataJournalEntry>)reader, message);
        }
        catch (Exception e) {
            LOG.warn("{}: failed to replay messages for {}", new Object[]{this.persistenceId, message, e});
            message.promise.failure((Throwable)e);
        }
        finally {
            message.promise.success(null);
        }
    }

    private void handleReplayMessages(JournalReader<DataJournalEntry> reader, SegmentedJournalActor.ReplayMessages message) {
        Indexed next;
        int count = 0;
        while ((long)count < message.max && (next = reader.tryNext()) != null && next.index() <= message.toSequenceNr) {
            LOG.trace("{}: replay {}", (Object)this.persistenceId, (Object)next);
            this.updateLargestSize(next.size());
            DataJournalEntry entry = (DataJournalEntry)next.entry();
            if (entry instanceof DataJournalEntry.FromPersistence) {
                DataJournalEntry.FromPersistence fromPersistence = (DataJournalEntry.FromPersistence)entry;
                PersistentRepr repr = fromPersistence.toRepr(this.persistenceId, next.index());
                LOG.debug("{}: replaying {}", (Object)this.persistenceId, (Object)repr);
                message.replayCallback.accept(repr);
                ++count;
                continue;
            }
            throw new VerifyException("Unexpected entry " + entry);
        }
        LOG.debug("{}: successfully replayed {} entries", (Object)this.persistenceId, (Object)count);
    }

    @Override
    SegmentedJournalActor.WrittenMessages handleWriteMessages(SegmentedJournalActor.WriteMessages message) {
        int count = message.size();
        ArrayList<Object> responses = new ArrayList<Object>();
        JournalWriter writer = this.entries.writer();
        long writtenBytes = 0L;
        for (int i = 0; i < count; ++i) {
            long mark = writer.getLastIndex();
            AtomicWrite request = message.getRequest(i);
            List reprs = CollectionConverters.asJava((Seq)request.payload());
            LOG.trace("{}: append {}/{}: {} items at mark {}", new Object[]{this.persistenceId, i, count, reprs.size(), mark});
            try {
                writtenBytes += this.writePayload((JournalWriter<DataJournalEntry>)writer, reprs);
            }
            catch (Exception e) {
                LOG.warn("{}: failed to write out request {}/{} reverting to {}", new Object[]{this.persistenceId, i, count, mark, e});
                responses.add(e);
                writer.truncate(mark);
                continue;
            }
            responses.add(null);
        }
        return new SegmentedJournalActor.WrittenMessages(message, responses, writtenBytes);
    }

    private long writePayload(JournalWriter<DataJournalEntry> writer, List<PersistentRepr> reprs) {
        long bytes = 0L;
        for (PersistentRepr repr : reprs) {
            Object payload = repr.payload();
            if (!(payload instanceof Serializable)) {
                throw new UnsupportedOperationException("Non-serializable payload encountered " + payload.getClass());
            }
            LOG.trace("{}: starting append of {}", (Object)this.persistenceId, payload);
            Indexed entry = writer.append((Object)new DataJournalEntry.ToPersistence(repr));
            int size = entry.size();
            LOG.trace("{}: finished append of {} with {} bytes at {}", new Object[]{this.persistenceId, payload, size, entry.index()});
            this.recordMessageSize(size);
            bytes += (long)size;
        }
        return bytes;
    }
}

