/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.remote.rpc.registry.mbeans;

import akka.util.Timeout;
import com.google.common.collect.ImmutableSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.opendaylight.controller.remote.rpc.registry.ActionRoutingTable;
import org.opendaylight.controller.remote.rpc.registry.gossip.BucketStoreAccess;
import org.opendaylight.controller.remote.rpc.registry.mbeans.AbstractRegistryMXBean;
import org.opendaylight.controller.remote.rpc.registry.mbeans.RemoteActionRegistryMXBean;
import org.opendaylight.mdsal.dom.api.DOMActionInstance;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;

public class RemoteActionRegistryMXBeanImpl
extends AbstractRegistryMXBean<ActionRoutingTable, DOMActionInstance>
implements RemoteActionRegistryMXBean {
    public RemoteActionRegistryMXBeanImpl(BucketStoreAccess actionRegistryAccess, Timeout timeout) {
        super("RemoteActionRegistry", "RemoteActionBroker", actionRegistryAccess, timeout);
    }

    @Override
    public Set<String> getLocalRegisteredAction() {
        ActionRoutingTable table = (ActionRoutingTable)this.localData();
        HashSet<String> routedAction = new HashSet<String>(table.getItems().size());
        for (DOMActionInstance route : table.getItems()) {
            YangInstanceIdentifier actionPath = YangInstanceIdentifier.of((QName)route.getType().lastNodeIdentifier());
            if (actionPath.isEmpty()) continue;
            routedAction.add("route:" + actionPath + " | name:" + route.getType());
        }
        this.log.debug("Locally registered routed RPCs {}", routedAction);
        return routedAction;
    }

    @Override
    public Map<String, String> findActionByName(String name) {
        ActionRoutingTable localTable = (ActionRoutingTable)this.localData();
        HashMap<String, String> rpcMap = new HashMap<String, String>(RemoteActionRegistryMXBeanImpl.getActionMemberMapByName(localTable, name, "local"));
        Map buckets = this.remoteBuckets();
        for (Map.Entry entry : buckets.entrySet()) {
            ActionRoutingTable table = (ActionRoutingTable)entry.getValue().getData();
            rpcMap.putAll(RemoteActionRegistryMXBeanImpl.getActionMemberMapByName(table, name, entry.getKey().toString()));
        }
        this.log.debug("list of Actions {} searched by name {}", rpcMap, (Object)name);
        return rpcMap;
    }

    @Override
    public Map<String, String> findActionByRoute(String routeId) {
        ActionRoutingTable localTable = (ActionRoutingTable)this.localData();
        HashMap<String, String> rpcMap = new HashMap<String, String>(RemoteActionRegistryMXBeanImpl.getActionMemberMapByAction(localTable, routeId, "local"));
        Map buckets = this.remoteBuckets();
        for (Map.Entry entry : buckets.entrySet()) {
            ActionRoutingTable table = (ActionRoutingTable)entry.getValue().getData();
            rpcMap.putAll(RemoteActionRegistryMXBeanImpl.getActionMemberMapByAction(table, routeId, entry.getKey().toString()));
        }
        this.log.debug("list of Actions {} searched by route {}", rpcMap, (Object)routeId);
        return rpcMap;
    }

    private static Map<String, String> getActionMemberMapByAction(ActionRoutingTable table, String routeName, String address) {
        ImmutableSet routes = table.getItems();
        HashMap<String, String> actionMap = new HashMap<String, String>(routes.size());
        for (DOMActionInstance route : routes) {
            String routeString;
            YangInstanceIdentifier actionPath = YangInstanceIdentifier.of((QName)route.getType().lastNodeIdentifier());
            if (actionPath.isEmpty() || !(routeString = actionPath.toString()).contains(routeName)) continue;
            actionMap.put("route:" + routeString + " | name:" + route.getType(), address);
        }
        return actionMap;
    }

    private static Map<String, String> getActionMemberMapByName(ActionRoutingTable table, String name, String address) {
        ImmutableSet routes = table.getItems();
        HashMap<String, String> actionMap = new HashMap<String, String>(routes.size());
        for (DOMActionInstance route : routes) {
            String type;
            YangInstanceIdentifier actionPath = YangInstanceIdentifier.of((QName)route.getType().lastNodeIdentifier());
            if (actionPath.isEmpty() || !(type = route.getType().toString()).contains(name)) continue;
            actionMap.put("route:" + actionPath + " | name:" + type, address);
        }
        return actionMap;
    }

    @Override
    public String getBucketVersions() {
        return this.bucketVersions();
    }
}

