package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.opendaylight.test.bug._3090.rev160101.root;
import com.google.common.base.MoreObjects;
import java.lang.Class;
import java.lang.NullPointerException;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.NoSuchElementException;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.opendaylight.test.bug._3090.rev160101.Root;
import org.opendaylight.yang.svc.v1.urn.opendaylight.params.xml.ns.opendaylight.test.bug._3090.rev160101.YangModuleInfoImpl;
import org.opendaylight.yangtools.yang.binding.Augmentable;
import org.opendaylight.yangtools.yang.binding.ChildOf;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.KeyAware;
import org.opendaylight.yangtools.yang.common.QName;

/**
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>opendaylight-test-bug-3090</b>
 * <pre>
 * list list-in-root {
 *   key "leaf-c leaf-a leaf-b";
 *   leaf leaf-a {
 *     type string;
 *   }
 *   leaf leaf-b {
 *     type string;
 *   }
 *   leaf leaf-c {
 *     type string;
 *   }
 * }
 * </pre>
 * <p>To create instances of this class use {@link ListInRootBuilder}.
 * @see ListInRootBuilder
 * @see ListInRootKey
 *
 */
@Generated("mdsal-binding-generator")
public interface ListInRoot
    extends
    ChildOf<Root>,
    Augmentable<ListInRoot>,
    KeyAware<ListInRootKey>
{



    /**
     * YANG identifier of the statement represented by this class.
     */
    public static final @NonNull QName QNAME = YangModuleInfoImpl.qnameOf("list-in-root");

    @Override
    default Class<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.opendaylight.test.bug._3090.rev160101.root.ListInRoot> implementedInterface() {
        return org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.opendaylight.test.bug._3090.rev160101.root.ListInRoot.class;
    }
    
    /**
     * Default implementation of {@link Object#hashCode()} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent hashing
     * results across all implementations.
     *
     * @param obj Object for which to generate hashCode() result.
     * @return Hash code value of data modeled by this interface.
     * @throws NullPointerException if {@code obj} is {@code null}
     */
    static int bindingHashCode(final org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.opendaylight.test.bug._3090.rev160101.root.@NonNull ListInRoot obj) {
        int result = 1;
        final int prime = 31;
        result = prime * result + Objects.hashCode(obj.getLeafA());
        result = prime * result + Objects.hashCode(obj.getLeafB());
        result = prime * result + Objects.hashCode(obj.getLeafC());
        for (var augmentation : obj.augmentations().values()) {
            result += augmentation.hashCode();
        }
        return result;
    }
    
    /**
     * Default implementation of {@link Object#equals(Object)} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent equality
     * results across all implementations.
     *
     * @param thisObj Object acting as the receiver of equals invocation
     * @param obj Object acting as argument to equals invocation
     * @return True if thisObj and obj are considered equal
     * @throws NullPointerException if {@code thisObj} is {@code null}
     */
    static boolean bindingEquals(final org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.opendaylight.test.bug._3090.rev160101.root.@NonNull ListInRoot thisObj, final Object obj) {
        if (thisObj == obj) {
            return true;
        }
        final var other = CodeHelpers.checkCast(org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.opendaylight.test.bug._3090.rev160101.root.ListInRoot.class, obj);
        return other != null
            && Objects.equals(thisObj.getLeafA(), other.getLeafA())
            && Objects.equals(thisObj.getLeafB(), other.getLeafB())
            && Objects.equals(thisObj.getLeafC(), other.getLeafC())
            && thisObj.augmentations().equals(other.augmentations());
    }
    
    /**
     * Default implementation of {@link Object#toString()} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent string
     * representations across all implementations.
     *
     * @param obj Object for which to generate toString() result.
     * @return {@link String} value of data modeled by this interface.
     * @throws NullPointerException if {@code obj} is {@code null}
     */
    static String bindingToString(final org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.opendaylight.test.bug._3090.rev160101.root.@NonNull ListInRoot obj) {
        final var helper = MoreObjects.toStringHelper("ListInRoot");
        CodeHelpers.appendValue(helper, "leafA", obj.getLeafA());
        CodeHelpers.appendValue(helper, "leafB", obj.getLeafB());
        CodeHelpers.appendValue(helper, "leafC", obj.getLeafC());
        CodeHelpers.appendAugmentations(helper, "augmentation", obj);
        return helper.toString();
    }
    
    @Override
    ListInRootKey key();
    
    /**
     * Return leafA, or {@code null} if it is not present.
     *
     * @return {@code String} leafA, or {@code null} if it is not present.
     *
     */
    String getLeafA();
    
    /**
     * Return leafA, guaranteed to be non-null.
     *
     * @return {@code String} leafA, guaranteed to be non-null.
     * @throws NoSuchElementException if leafA is not present
     *
     */
    default @NonNull String requireLeafA() {
        return CodeHelpers.require(getLeafA(), "leafa");
    }
    
    /**
     * Return leafB, or {@code null} if it is not present.
     *
     * @return {@code String} leafB, or {@code null} if it is not present.
     *
     */
    String getLeafB();
    
    /**
     * Return leafB, guaranteed to be non-null.
     *
     * @return {@code String} leafB, guaranteed to be non-null.
     * @throws NoSuchElementException if leafB is not present
     *
     */
    default @NonNull String requireLeafB() {
        return CodeHelpers.require(getLeafB(), "leafb");
    }
    
    /**
     * Return leafC, or {@code null} if it is not present.
     *
     * @return {@code String} leafC, or {@code null} if it is not present.
     *
     */
    String getLeafC();
    
    /**
     * Return leafC, guaranteed to be non-null.
     *
     * @return {@code String} leafC, guaranteed to be non-null.
     * @throws NoSuchElementException if leafC is not present
     *
     */
    default @NonNull String requireLeafC() {
        return CodeHelpers.require(getLeafC(), "leafc");
    }

}

