package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.test.list.rev140701.two.level.list;
import java.lang.Class;
import java.lang.NullPointerException;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.test.list.rev140701.two.level.list.top.level.list.NestedList;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;

/**
 * Class that builds {@link TopLevelList} instances. Overall design of the class is that of a
 * <a href="https://en.wikipedia.org/wiki/Fluent_interface">fluent interface</a>, where method chaining is used.
 *
 * <p>
 * In general, this class is supposed to be used like this template:
 * <pre>
 *   <code>
 *     TopLevelList createTopLevelList(int fooXyzzy, int barBaz) {
 *         return new TopLevelListBuilder()
 *             .setFoo(new FooBuilder().setXyzzy(fooXyzzy).build())
 *             .setBar(new BarBuilder().setBaz(barBaz).build())
 *             .build();
 *     }
 *   </code>
 * </pre>
 *
 * <p>
 * This pattern is supported by the immutable nature of TopLevelList, as instances can be freely passed around without
 * worrying about synchronization issues.
 *
 * <p>
 * As a side note: method chaining results in:
 * <ul>
 *   <li>very efficient Java bytecode, as the method invocation result, in this case the Builder reference, is
 *       on the stack, so further method invocations just need to fill method arguments for the next method
 *       invocation, which is terminated by {@link #build()}, which is then returned from the method</li>
 *   <li>better understanding by humans, as the scope of mutable state (the builder) is kept to a minimum and is
 *       very localized</li>
 *   <li>better optimization opportunities, as the object scope is minimized in terms of invocation (rather than
 *       method) stack, making <a href="https://en.wikipedia.org/wiki/Escape_analysis">escape analysis</a> a lot
 *       easier. Given enough compiler (JIT/AOT) prowess, the cost of th builder object can be completely
 *       eliminated</li>
 * </ul>
 *
 * @see TopLevelList
 *
 */
@Generated("mdsal-binding-generator")
public class TopLevelListBuilder {

    private String _name;
    private List<NestedList> _nestedList;
    private TopLevelListKey key;


    Map<Class<? extends Augmentation<TopLevelList>>, Augmentation<TopLevelList>> augmentation = Map.of();

    /**
     * Construct an empty builder.
     */
    public TopLevelListBuilder() {
        // No-op
    }

    
    

    /**
     * Construct a builder initialized with state from specified {@link TopLevelList}.
     *
     * @param base TopLevelList from which the builder should be initialized
     */
    public TopLevelListBuilder(TopLevelList base) {
        final var aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<>(aug);
        }
        this.key = base.key();
        this._name = base.getName();
        this._nestedList = base.getNestedList();
    }



    /**
     * Return current value associated with the property corresponding to {@link TopLevelList#key()}.
     *
     * @return current value
     */
    public TopLevelListKey key() {
        return key;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link TopLevelList#getName()}.
     *
     * @return current value
     */
    public String getName() {
        return _name;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link TopLevelList#getNestedList()}.
     *
     * @return current value
     */
    public List<NestedList> getNestedList() {
        return _nestedList;
    }

    /**
     * Return the specified augmentation, if it is present in this builder.
     *
     * @param <E$$> augmentation type
     * @param augmentationType augmentation type class
     * @return Augmentation object from this builder, or {@code null} if not present
     * @throws NullPointerException if {@code augmentType} is {@code null}
     */
    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<TopLevelList>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(Objects.requireNonNull(augmentationType));
    }

    /**
     * Set the key value corresponding to {@link TopLevelList#key()} to the specified
     * value.
     *
     * @param key desired value
     * @return this builder
     */
    public TopLevelListBuilder withKey(final TopLevelListKey key) {
        this.key = key;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link TopLevelList#getName()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public TopLevelListBuilder setName(final String value) {
        this._name = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link TopLevelList#getNestedList()} to the specified
     * value.
     *
     * @param values desired value
     * @return this builder
     */
    public TopLevelListBuilder setNestedList(final List<NestedList> values) {
        this._nestedList = values;
        return this;
    }
    
    
    /**
      * Add an augmentation to this builder's product.
      *
      * @param augmentation augmentation to be added
      * @return this builder
      * @throws NullPointerException if {@code augmentation} is null
      */
    public TopLevelListBuilder addAugmentation(Augmentation<TopLevelList> augmentation) {
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentation.implementedInterface(), augmentation);
        return this;
    }
    
    /**
      * Remove an augmentation from this builder's product. If this builder does not track such an augmentation
      * type, this method does nothing.
      *
      * @param augmentationType augmentation type to be removed
      * @return this builder
      */
    public TopLevelListBuilder removeAugmentation(Class<? extends Augmentation<TopLevelList>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    /**
     * A new {@link TopLevelList} instance.
     *
     * @return A new {@link TopLevelList} instance.
     */
    public @NonNull TopLevelList build() {
        return new TopLevelListImpl(this);
    }

    private static final class TopLevelListImpl
        extends AbstractAugmentable<TopLevelList>
        implements TopLevelList {
    
        private final String _name;
        private final List<NestedList> _nestedList;
        private final TopLevelListKey key;
    
        TopLevelListImpl(TopLevelListBuilder base) {
            super(base.augmentation);
            if (base.key() != null) {
                this.key = base.key();
            } else {
                this.key = new TopLevelListKey(base.getName());
            }
            this._name = key.getName();
            this._nestedList = CodeHelpers.emptyToNull(base.getNestedList());
        }
    
        @Override
        public TopLevelListKey key() {
            return key;
        }
        
        @Override
        public String getName() {
            return _name;
        }
        
        @Override
        public List<NestedList> getNestedList() {
            return _nestedList;
        }
    
        
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int result = TopLevelList.bindingHashCode(this);
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            return TopLevelList.bindingEquals(this, obj);
        }
    
        @Override
        public String toString() {
            return TopLevelList.bindingToString(this);
        }
    }
}
