package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.test.list.rev140701.two.level.list.top.level.list;
import com.google.common.base.MoreObjects;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.Key;

/**
 * This class represents the key of {@link NestedList} class.
 *
 * @see NestedList
 *
 */
@Generated("mdsal-binding-generator")
public class NestedListKey
 implements Key<NestedList> {
    @java.io.Serial
    private static final long serialVersionUID = 3960296780998600844L;
    private final String _name;


    /**
     * Constructs an instance.
     *
     * @param _name the entity name
     * @throws NullPointerException if any of the arguments are null
     */
    public NestedListKey(@NonNull String _name) {
        this._name = CodeHelpers.requireKeyProp(_name, "name");
    }
    
    /**
     * Creates a copy from Source Object.
     *
     * @param source Source object
     */
    public NestedListKey(NestedListKey source) {
        this._name = source._name;
    }


    /**
     * Return name, guaranteed to be non-null.
     *
     * @return {@code String} name, guaranteed to be non-null.
     */
    public @NonNull String getName() {
        return _name;
    }


    @Override
    public int hashCode() {
        return CodeHelpers.wrapperHashCode(_name);
    }

    @Override
    public final boolean equals(Object obj) {
        return this == obj || obj instanceof NestedListKey other
            && Objects.equals(_name, other._name);
    }

    @Override
    public String toString() {
        final var helper = MoreObjects.toStringHelper(NestedListKey.class);
        CodeHelpers.appendValue(helper, "name", _name);
        return helper.toString();
    }
}

