package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.test.listener.rev150825.listener.test;
import com.google.common.base.MoreObjects;
import java.lang.Class;
import java.lang.NullPointerException;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.NoSuchElementException;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.test.listener.rev150825.ListenerTest;
import org.opendaylight.yang.svc.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.test.listener.rev150825.YangModuleInfoImpl;
import org.opendaylight.yangtools.yang.binding.Augmentable;
import org.opendaylight.yangtools.yang.binding.ChildOf;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.KeyAware;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.Uint32;

/**
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>listener-container</b>
 * <pre>
 * list list-item {
 *   key "sip op";
 *   leaf sip {
 *     type string;
 *   }
 *   leaf op {
 *     type uint32;
 *   }
 * }
 * </pre>
 * <p>To create instances of this class use {@link ListItemBuilder}.
 * @see ListItemBuilder
 * @see ListItemKey
 *
 */
@Generated("mdsal-binding-generator")
public interface ListItem
    extends
    ChildOf<ListenerTest>,
    Augmentable<ListItem>,
    KeyAware<ListItemKey>
{



    /**
     * YANG identifier of the statement represented by this class.
     */
    public static final @NonNull QName QNAME = YangModuleInfoImpl.qnameOf("list-item");

    @Override
    default Class<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.test.listener.rev150825.listener.test.ListItem> implementedInterface() {
        return org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.test.listener.rev150825.listener.test.ListItem.class;
    }
    
    /**
     * Default implementation of {@link Object#hashCode()} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent hashing
     * results across all implementations.
     *
     * @param obj Object for which to generate hashCode() result.
     * @return Hash code value of data modeled by this interface.
     * @throws NullPointerException if {@code obj} is {@code null}
     */
    static int bindingHashCode(final org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.test.listener.rev150825.listener.test.@NonNull ListItem obj) {
        int result = 1;
        final int prime = 31;
        result = prime * result + Objects.hashCode(obj.getOp());
        result = prime * result + Objects.hashCode(obj.getSip());
        for (var augmentation : obj.augmentations().values()) {
            result += augmentation.hashCode();
        }
        return result;
    }
    
    /**
     * Default implementation of {@link Object#equals(Object)} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent equality
     * results across all implementations.
     *
     * @param thisObj Object acting as the receiver of equals invocation
     * @param obj Object acting as argument to equals invocation
     * @return True if thisObj and obj are considered equal
     * @throws NullPointerException if {@code thisObj} is {@code null}
     */
    static boolean bindingEquals(final org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.test.listener.rev150825.listener.test.@NonNull ListItem thisObj, final Object obj) {
        if (thisObj == obj) {
            return true;
        }
        final var other = CodeHelpers.checkCast(org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.test.listener.rev150825.listener.test.ListItem.class, obj);
        return other != null
            && Objects.equals(thisObj.getOp(), other.getOp())
            && Objects.equals(thisObj.getSip(), other.getSip())
            && thisObj.augmentations().equals(other.augmentations());
    }
    
    /**
     * Default implementation of {@link Object#toString()} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent string
     * representations across all implementations.
     *
     * @param obj Object for which to generate toString() result.
     * @return {@link String} value of data modeled by this interface.
     * @throws NullPointerException if {@code obj} is {@code null}
     */
    static String bindingToString(final org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.test.listener.rev150825.listener.test.@NonNull ListItem obj) {
        final var helper = MoreObjects.toStringHelper("ListItem");
        CodeHelpers.appendValue(helper, "op", obj.getOp());
        CodeHelpers.appendValue(helper, "sip", obj.getSip());
        CodeHelpers.appendAugmentations(helper, "augmentation", obj);
        return helper.toString();
    }
    
    @Override
    ListItemKey key();
    
    /**
     * Return sip, or {@code null} if it is not present.
     *
     * @return {@code String} sip, or {@code null} if it is not present.
     *
     */
    String getSip();
    
    /**
     * Return sip, guaranteed to be non-null.
     *
     * @return {@code String} sip, guaranteed to be non-null.
     * @throws NoSuchElementException if sip is not present
     *
     */
    default @NonNull String requireSip() {
        return CodeHelpers.require(getSip(), "sip");
    }
    
    /**
     * Return op, or {@code null} if it is not present.
     *
     * @return {@code Uint32} op, or {@code null} if it is not present.
     *
     */
    Uint32 getOp();
    
    /**
     * Return op, guaranteed to be non-null.
     *
     * @return {@code Uint32} op, guaranteed to be non-null.
     * @throws NoSuchElementException if op is not present
     *
     */
    default @NonNull Uint32 requireOp() {
        return CodeHelpers.require(getOp(), "op");
    }

}

