package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.test.listener.rev150825.listener.test;
import com.google.common.base.MoreObjects;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.Key;
import org.opendaylight.yangtools.yang.common.Uint32;

/**
 * This class represents the key of {@link ListItem} class.
 *
 * @see ListItem
 *
 */
@Generated("mdsal-binding-generator")
public class ListItemKey
 implements Key<ListItem> {
    @java.io.Serial
    private static final long serialVersionUID = -3046050474501732976L;
    private final String _sip;
    private final Uint32 _op;


    /**
     * Constructs an instance.
     *
     * @param _op the entity op
     * @param _sip the entity sip
     * @throws NullPointerException if any of the arguments are null
     */
    public ListItemKey(@NonNull Uint32 _op, @NonNull String _sip) {
        this._op = CodeHelpers.requireKeyProp(_op, "op");
        this._sip = CodeHelpers.requireKeyProp(_sip, "sip");
    }
    
    /**
     * Creates a copy from Source Object.
     *
     * @param source Source object
     */
    public ListItemKey(ListItemKey source) {
        this._sip = source._sip;
        this._op = source._op;
    }


    /**
     * Return sip, guaranteed to be non-null.
     *
     * @return {@code String} sip, guaranteed to be non-null.
     */
    public @NonNull String getSip() {
        return _sip;
    }
    
    /**
     * Return op, guaranteed to be non-null.
     *
     * @return {@code Uint32} op, guaranteed to be non-null.
     */
    public @NonNull Uint32 getOp() {
        return _op;
    }


    @Override
    public int hashCode() {
        final int prime = 31;
        int result = 1;
        result = prime * result + Objects.hashCode(_sip);
        result = prime * result + Objects.hashCode(_op);
        return result;
    }

    @Override
    public final boolean equals(Object obj) {
        return this == obj || obj instanceof ListItemKey other
            && Objects.equals(_sip, other._sip)        
            && Objects.equals(_op, other._op);
    }

    @Override
    public String toString() {
        final var helper = MoreObjects.toStringHelper(ListItemKey.class);
        CodeHelpers.appendValue(helper, "sip", _sip);
        CodeHelpers.appendValue(helper, "op", _op);
        return helper.toString();
    }
}

