/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.infrautils.diagstatus.internal;

import com.google.common.collect.ImmutableSet;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Collection;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.opendaylight.infrautils.diagstatus.DiagStatusService;
import org.opendaylight.infrautils.diagstatus.ServiceDescriptor;
import org.opendaylight.infrautils.diagstatus.ServiceRegistration;
import org.opendaylight.infrautils.diagstatus.ServiceState;
import org.opendaylight.infrautils.diagstatus.ServiceStatusProvider;
import org.opendaylight.infrautils.diagstatus.ServiceStatusSummary;
import org.opendaylight.infrautils.ready.SystemReadyMonitor;
import org.opendaylight.infrautils.ready.SystemState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class AbstractDiagStatusService
implements DiagStatusService {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractDiagStatusService.class);
    private final ConcurrentMap<String, ServiceDescriptor> statusMap = new ConcurrentHashMap<String, ServiceDescriptor>();

    AbstractDiagStatusService() {
    }

    public final ServiceRegistration register(final String serviceIdentifier) {
        this.statusMap.put(serviceIdentifier, new ServiceDescriptor(serviceIdentifier, ServiceState.STARTING, "INITIALIZING"));
        return new ServiceRegistration(){

            public void report(ServiceDescriptor serviceDescriptor) {
                ServiceDescriptor checked = Objects.requireNonNull(serviceDescriptor);
                ServiceDescriptor prev = AbstractDiagStatusService.this.statusMap.computeIfPresent(serviceIdentifier, (key, value) -> checked);
                if (prev == null) {
                    throw new IllegalStateException("Service already unregistered");
                }
            }

            public void close() {
                AbstractDiagStatusService.this.statusMap.remove(serviceIdentifier);
            }
        };
    }

    public final ServiceDescriptor getServiceDescriptor(String serviceIdentifier) {
        this.updateServiceStatusMap();
        return (ServiceDescriptor)this.statusMap.get(serviceIdentifier);
    }

    public final ImmutableSet<ServiceDescriptor> getAllServiceDescriptors() {
        this.updateServiceStatusMap();
        return ImmutableSet.copyOf(this.statusMap.values());
    }

    public final ServiceStatusSummary getServiceStatusSummary() {
        SystemReadyMonitor systemReadyMonitor = this.systemReadyMonitor();
        SystemState systemState = systemReadyMonitor.getSystemState();
        ImmutableSet<ServiceDescriptor> serviceDescriptors = this.getAllServiceDescriptors();
        return new ServiceStatusSummary(AbstractDiagStatusService.isOperational(systemState, serviceDescriptors), systemState, systemReadyMonitor.getFailureCause(), serviceDescriptors);
    }

    abstract Iterable<? extends ServiceStatusProvider> serviceStatusProviders();

    abstract SystemReadyMonitor systemReadyMonitor();

    private static boolean isOperational(SystemState systemState, Collection<ServiceDescriptor> serviceDescriptors) {
        if (!systemState.equals((Object)SystemState.ACTIVE)) {
            return false;
        }
        for (ServiceDescriptor serviceDescriptor : serviceDescriptors) {
            if (serviceDescriptor.getServiceState().equals((Object)ServiceState.OPERATIONAL)) continue;
            return false;
        }
        return true;
    }

    @SuppressFBWarnings(value={"RCN_REDUNDANT_NULLCHECK_OF_NONNULL_VALUE"})
    private void updateServiceStatusMap() {
        for (ServiceStatusProvider serviceStatusProvider : this.serviceStatusProviders()) {
            ServiceDescriptor serviceDescriptor = serviceStatusProvider.getServiceDescriptor();
            if (serviceDescriptor != null) {
                this.statusMap.put(serviceDescriptor.getModuleServiceName(), serviceDescriptor);
                continue;
            }
            LOG.warn("ServiceStatusProvider getServiceDescriptor() returned null: {}", (Object)serviceStatusProvider);
        }
    }
}

