/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.infrautils.diagstatus.internal;

import com.google.common.base.Preconditions;
import com.google.common.net.InetAddresses;
import java.net.InetAddress;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.inject.Singleton;
import javax.management.JMException;
import org.apache.commons.lang3.StringUtils;
import org.opendaylight.infrautils.diagstatus.ClusterMemberInfo;
import org.opendaylight.infrautils.diagstatus.MBeanUtils;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated(forRemoval=true)
@Singleton
@Component(immediate=true)
public final class ClusterMemberInfoImpl
implements ClusterMemberInfo {
    private static final Logger LOG = LoggerFactory.getLogger(ClusterMemberInfoImpl.class);

    public InetAddress getSelfAddress() {
        Object clusterStatusMBeanValue;
        try {
            clusterStatusMBeanValue = MBeanUtils.getMBeanAttribute((String)"akka:type=Cluster", (String)"ClusterStatus");
        }
        catch (JMException e) {
            throw new IllegalStateException("getMBeanAttribute(\"akka:type=Cluster\", \"ClusterStatus\") failed", e);
        }
        Preconditions.checkState((clusterStatusMBeanValue != null ? 1 : 0) != 0, (Object)"getMBeanAttribute(\"akka:type=Cluster\", \"ClusterStatus\") == null?!");
        String clusterStatusText = clusterStatusMBeanValue.toString();
        String selfAddressMbean = Objects.requireNonNull(StringUtils.substringBetween((String)clusterStatusText, (String)"\"self-address\": ", (String)","), "null substringBetween() for: " + clusterStatusText);
        return InetAddresses.forString((String)ClusterMemberInfoImpl.extractAddressFromAkka(selfAddressMbean));
    }

    public List<InetAddress> getClusterMembers() {
        Object clusterMemberMBeanValue;
        try {
            clusterMemberMBeanValue = MBeanUtils.getMBeanAttribute((String)"akka:type=Cluster", (String)"Members");
        }
        catch (JMException e) {
            LOG.error("Problem to getMBeanAttribute(\"akka:type=Cluster\", \"Members\"); returning empty List", (Throwable)e);
            return List.of();
        }
        if (clusterMemberMBeanValue == null) {
            return List.of();
        }
        return Arrays.stream(((String)clusterMemberMBeanValue).split(",", -1)).map(clusterMember -> InetAddresses.forString((String)ClusterMemberInfoImpl.extractAddressFromAkka(clusterMember))).collect(Collectors.toUnmodifiableList());
    }

    public boolean isLocalAddress(InetAddress ipAddress) {
        return ipAddress.equals(InetAddress.getLoopbackAddress()) || ipAddress.equals(this.getSelfAddress());
    }

    @Activate
    void activate() {
        LOG.info("ClusterMemberInfo activated");
    }

    @Deactivate
    void deactivate() {
        LOG.info("ClusterMemberInfo deactivated");
    }

    private static String extractAddressFromAkka(String clusterMember) {
        if (clusterMember.contains("@[")) {
            return Objects.requireNonNull(StringUtils.substringBetween((String)clusterMember, (String)"@[", (String)"]"), "null substringBetween() for IPv6: " + clusterMember);
        }
        return Objects.requireNonNull(StringUtils.substringBetween((String)clusterMember, (String)"@", (String)":"), "null substringBetween() for IPv4: " + clusterMember);
    }
}

