/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.infrautils.diagstatus.internal;

import com.google.common.base.Strings;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.management.InstanceNotFoundException;
import javax.management.JMException;
import javax.management.MBeanRegistrationException;
import javax.management.ObjectName;
import javax.management.StandardMBean;
import org.opendaylight.infrautils.diagstatus.DiagStatusService;
import org.opendaylight.infrautils.diagstatus.DiagStatusServiceMBean;
import org.opendaylight.infrautils.diagstatus.MBeanUtils;
import org.opendaylight.infrautils.diagstatus.ServiceDescriptor;
import org.opendaylight.infrautils.diagstatus.ServiceState;
import org.opendaylight.infrautils.diagstatus.ServiceStatusSummary;
import org.opendaylight.infrautils.ready.SystemReadyMonitor;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
@Component(immediate=true, service={DiagStatusServiceMBean.class})
public final class DiagStatusServiceMBeanImpl
extends StandardMBean
implements DiagStatusServiceMBean,
AutoCloseable {
    private static final Logger LOG = LoggerFactory.getLogger(DiagStatusServiceMBeanImpl.class);
    private final DiagStatusService diagStatusService;
    private final SystemReadyMonitor systemReadyMonitor;

    @Inject
    @Activate
    public DiagStatusServiceMBeanImpl(@Reference DiagStatusService diagStatusService, @Reference SystemReadyMonitor systemReadyMonitor) throws JMException {
        super(DiagStatusServiceMBean.class);
        this.diagStatusService = diagStatusService;
        this.systemReadyMonitor = systemReadyMonitor;
        MBeanUtils.registerServerMBean((Object)this, (ObjectName)JMX_OBJECT_NAME);
        LOG.info("Diagnostic Status Service management started");
    }

    @Override
    @PreDestroy
    @Deactivate
    public void close() throws InstanceNotFoundException, MBeanRegistrationException {
        MBeanUtils.unregisterServerMBean((Object)this, (ObjectName)JMX_OBJECT_NAME);
        LOG.info("Diagnostic Status Service management stopped");
    }

    public String acquireServiceStatus() {
        StringBuilder statusSummary = new StringBuilder();
        ServiceStatusSummary summary = this.diagStatusService.getServiceStatusSummary();
        statusSummary.append("System is operational: ").append(summary.isOperational()).append('\n');
        statusSummary.append("System ready state: ").append(summary.getSystemReadyState()).append('\n');
        for (ServiceDescriptor status : summary.getStatusSummary()) {
            statusSummary.append("ServiceName          : ").append(status.getModuleServiceName()).append('\n');
            if (status.getServiceState() != null) {
                statusSummary.append("Last Reported Status : ").append(status.getServiceState().name()).append('\n');
            }
            if (status.getStatusDesc() != null) {
                statusSummary.append("Reported Status Desc : ").append(status.getStatusDesc()).append('\n');
            }
            if (status.getStatusTimestamp() != null) {
                statusSummary.append("Status Timestamp     : ").append(status.getStatusTimestamp()).append("\n");
            }
            if (status.getErrorCause() != null && status.getErrorCause().isPresent()) {
                statusSummary.append("Error Cause          : ").append(Throwables.getStackTraceAsString((Throwable)((Throwable)status.getErrorCause().orElseThrow()))).append("\n");
            }
            statusSummary.append('\n');
        }
        statusSummary.append('\n');
        return statusSummary.toString();
    }

    public String acquireServiceStatusDetailed() {
        StringBuilder statusSummary = new StringBuilder();
        ServiceStatusSummary summary = this.diagStatusService.getServiceStatusSummary();
        statusSummary.append("System is operational: ").append(summary.isOperational()).append('\n');
        statusSummary.append("System ready state: ").append(this.systemReadyMonitor.getSystemState()).append('\n');
        for (ServiceDescriptor status : summary.getStatusSummary()) {
            statusSummary.append("  ").append(String.format("%-20s%-15s", status.getModuleServiceName(), ": " + status.getServiceState()));
            if (!Strings.isNullOrEmpty((String)status.getStatusDesc())) {
                statusSummary.append(" (");
                statusSummary.append(status.getStatusDesc());
                statusSummary.append(")");
            }
            status.getErrorCause().ifPresent(cause -> statusSummary.append(cause.toString()));
            statusSummary.append("\n");
        }
        return statusSummary.toString();
    }

    public String acquireServiceStatusBrief() {
        String errorState = "ERROR - ";
        StringBuilder statusSummary = new StringBuilder();
        ServiceStatusSummary summary = this.diagStatusService.getServiceStatusSummary();
        statusSummary.append("System is operational: ").append(summary.isOperational()).append('\n');
        statusSummary.append("System ready state: ").append(summary.getSystemReadyState()).append('\n');
        for (ServiceDescriptor stat : summary.getStatusSummary()) {
            ServiceState state = stat.getServiceState();
            if (!state.equals((Object)ServiceState.ERROR) && !state.equals((Object)ServiceState.UNREGISTERED)) continue;
            statusSummary.append(errorState).append(stat.getModuleServiceName()).append(" ");
        }
        return statusSummary.toString();
    }

    public Map<String, String> acquireServiceStatusMap() {
        ImmutableMap.Builder mapBuilder = ImmutableMap.builder();
        ServiceStatusSummary summary = this.diagStatusService.getServiceStatusSummary();
        for (ServiceDescriptor status : summary.getStatusSummary()) {
            ServiceState state = status.getServiceState();
            if (state == null) {
                mapBuilder.put((Object)status.getModuleServiceName(), (Object)ServiceState.UNREGISTERED.name());
                continue;
            }
            mapBuilder.put((Object)status.getModuleServiceName(), (Object)state.name());
        }
        return mapBuilder.build();
    }

    public String acquireServiceStatusAsJSON() {
        return this.diagStatusService.getServiceStatusSummary().toJSON();
    }
}

