/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.infrautils.diagstatus.internal;

import com.google.common.annotations.Beta;
import com.google.common.base.Verify;
import java.util.List;
import org.opendaylight.infrautils.diagstatus.DiagStatusService;
import org.opendaylight.infrautils.diagstatus.ServiceStatusProvider;
import org.opendaylight.infrautils.diagstatus.internal.AbstractDiagStatusService;
import org.opendaylight.infrautils.ready.SystemReadyMonitor;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Beta
@Component(immediate=true, service={DiagStatusService.class})
public final class OSGiDiagStatusService
extends AbstractDiagStatusService {
    private static final Logger LOG = LoggerFactory.getLogger(OSGiDiagStatusService.class);
    @Reference
    volatile List<ServiceStatusProvider> serviceStatusProviders = null;
    @Reference
    SystemReadyMonitor systemReadyMonitor = null;

    @Override
    Iterable<? extends ServiceStatusProvider> serviceStatusProviders() {
        return (Iterable)Verify.verifyNotNull(this.serviceStatusProviders);
    }

    @Override
    SystemReadyMonitor systemReadyMonitor() {
        return (SystemReadyMonitor)Verify.verifyNotNull((Object)this.systemReadyMonitor);
    }

    @Activate
    void activate() {
        LOG.info("Diagnostic Status Service started");
    }

    @Deactivate
    void deactivate() {
        LOG.info("Diagnostic Status Service stopped");
    }
}

