package org.opendaylight.infrautils.utils.concurrent;

import com.google.common.base.MoreObjects;
import com.google.common.primitives.Booleans;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.immutables.value.Generated;
import org.slf4j.Logger;

/**
 * Immutable implementation of {@link ThreadFactoryProvider}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableThreadFactoryProvider.builder()}.
 * Use the static factory method to create immutable instances:
 * {@code ImmutableThreadFactoryProvider.of()}.
 */
@Generated(from = "ThreadFactoryProvider", generator = "Immutables")
@SuppressWarnings({"all"})
@SuppressFBWarnings
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
public final class ImmutableThreadFactoryProvider
    extends ThreadFactoryProvider {
  private final String namePrefix;
  private final Logger logger;
  private final Integer priority;
  private final boolean daemon;

  private ImmutableThreadFactoryProvider(
      String namePrefix,
      Logger logger,
      Optional<Integer> priority) {
    this.namePrefix = Objects.requireNonNull(namePrefix, "namePrefix");
    this.logger = Objects.requireNonNull(logger, "logger");
    this.priority = priority.orElse(null);
    this.daemon = super.daemon();
  }

  private ImmutableThreadFactoryProvider(ImmutableThreadFactoryProvider.Builder builder) {
    this.namePrefix = builder.namePrefix;
    this.logger = builder.logger;
    this.priority = builder.priority;
    this.daemon = builder.daemonIsSet()
        ? builder.daemon
        : super.daemon();
  }

  private ImmutableThreadFactoryProvider(String namePrefix, Logger logger, Integer priority, boolean daemon) {
    this.namePrefix = namePrefix;
    this.logger = logger;
    this.priority = priority;
    this.daemon = daemon;
  }

  /**
   * Prefix for threads from this factory. For example, "rpc-pool", to create
   * "rpc-pool-1/2/3" named threads. Note that this is a prefix, not a format,
   * so you pass just "rpc-pool" instead of e.g. "rpc-pool-%d".
   */
  @Override
  public String namePrefix() {
    return namePrefix;
  }

  /**
   * Logger used to log uncaught exceptions from new threads created via this factory.
   */
  @Override
  public Logger logger() {
    return logger;
  }

  /**
   * Priority for new threads from this factory.
   */
  @Override
  public Optional<Integer> priority() {
    return Optional.ofNullable(priority);
  }

  /**
   * Daemon or not for new threads created via this factory.
   * <b>NB: Defaults to true.</b>
   */
  @Override
  public boolean daemon() {
    return daemon;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ThreadFactoryProvider#namePrefix() namePrefix} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for namePrefix
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableThreadFactoryProvider withNamePrefix(String value) {
    String newValue = Objects.requireNonNull(value, "namePrefix");
    if (this.namePrefix.equals(newValue)) return this;
    return new ImmutableThreadFactoryProvider(newValue, this.logger, this.priority, this.daemon);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ThreadFactoryProvider#logger() logger} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for logger
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableThreadFactoryProvider withLogger(Logger value) {
    if (this.logger == value) return this;
    Logger newValue = Objects.requireNonNull(value, "logger");
    return new ImmutableThreadFactoryProvider(this.namePrefix, newValue, this.priority, this.daemon);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link ThreadFactoryProvider#priority() priority} attribute.
   * @param value The value for priority
   * @return A modified copy of {@code this} object
   */
  public final ImmutableThreadFactoryProvider withPriority(int value) {
    Integer newValue = value;
    if (Objects.equals(this.priority, newValue)) return this;
    return new ImmutableThreadFactoryProvider(this.namePrefix, this.logger, newValue, this.daemon);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link ThreadFactoryProvider#priority() priority} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for priority
   * @return A modified copy of {@code this} object
   */
  public final ImmutableThreadFactoryProvider withPriority(Optional<Integer> optional) {
    Integer value = optional.orElse(null);
    if (Objects.equals(this.priority, value)) return this;
    return new ImmutableThreadFactoryProvider(this.namePrefix, this.logger, value, this.daemon);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ThreadFactoryProvider#daemon() daemon} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for daemon
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableThreadFactoryProvider withDaemon(boolean value) {
    if (this.daemon == value) return this;
    return new ImmutableThreadFactoryProvider(this.namePrefix, this.logger, this.priority, value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableThreadFactoryProvider} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ImmutableThreadFactoryProvider
        && equalTo(0, (ImmutableThreadFactoryProvider) another);
  }

  private boolean equalTo(int synthetic, ImmutableThreadFactoryProvider another) {
    return namePrefix.equals(another.namePrefix)
        && logger.equals(another.logger)
        && Objects.equals(priority, another.priority)
        && daemon == another.daemon;
  }

  /**
   * Computes a hash code from attributes: {@code namePrefix}, {@code logger}, {@code priority}, {@code daemon}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + namePrefix.hashCode();
    h += (h << 5) + logger.hashCode();
    h += (h << 5) + Objects.hashCode(priority);
    h += (h << 5) + Booleans.hashCode(daemon);
    return h;
  }

  /**
   * Prints the immutable value {@code ThreadFactoryProvider} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("ThreadFactoryProvider")
        .omitNullValues()
        .add("namePrefix", namePrefix)
        .add("logger", logger)
        .add("priority", priority)
        .add("daemon", daemon)
        .toString();
  }

  /**
   * Construct a new immutable {@code ThreadFactoryProvider} instance.
   * @param namePrefix The value for the {@code namePrefix} attribute
   * @param logger The value for the {@code logger} attribute
   * @param priority The value for the {@code priority} attribute
   * @return An immutable ThreadFactoryProvider instance
   */
  public static ImmutableThreadFactoryProvider of(String namePrefix, Logger logger, Optional<Integer> priority) {
    return new ImmutableThreadFactoryProvider(namePrefix, logger, priority);
  }

  /**
   * Creates an immutable copy of a {@link ThreadFactoryProvider} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable ThreadFactoryProvider instance
   */
  public static ImmutableThreadFactoryProvider copyOf(ThreadFactoryProvider instance) {
    if (instance instanceof ImmutableThreadFactoryProvider) {
      return (ImmutableThreadFactoryProvider) instance;
    }
    return ((ImmutableThreadFactoryProvider.Builder) ImmutableThreadFactoryProvider.builder())
        .namePrefix(instance.namePrefix())
        .logger(instance.logger())
        .priority(instance.priority())
        .daemon(instance.daemon())
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableThreadFactoryProvider ImmutableThreadFactoryProvider}.
   * <pre>
   * ImmutableThreadFactoryProvider.builder()
   *    .namePrefix(String) // required {@link ThreadFactoryProvider#namePrefix() namePrefix}
   *    .logger(org.slf4j.Logger) // required {@link ThreadFactoryProvider#logger() logger}
   *    .priority(Integer) // optional {@link ThreadFactoryProvider#priority() priority}
   *    .daemon(boolean) // optional {@link ThreadFactoryProvider#daemon() daemon}
   *    .build();
   * </pre>
   * @return A new ImmutableThreadFactoryProvider builder
   */
  public static NamePrefixBuildStage builder() {
    return new ImmutableThreadFactoryProvider.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableThreadFactoryProvider ImmutableThreadFactoryProvider}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "ThreadFactoryProvider", generator = "Immutables")
  public static final class Builder implements NamePrefixBuildStage, LoggerBuildStage, BuildFinal {
    private static final long INIT_BIT_NAME_PREFIX = 0x1L;
    private static final long INIT_BIT_LOGGER = 0x2L;
    private static final long OPT_BIT_PRIORITY = 0x1L;
    private static final long OPT_BIT_DAEMON = 0x2L;
    private long initBits = 0x3L;
    private long optBits;

    private String namePrefix;
    private Logger logger;
    private Integer priority;
    private boolean daemon;

    private Builder() {
    }

    /**
     * Initializes the value for the {@link ThreadFactoryProvider#namePrefix() namePrefix} attribute.
     * @param namePrefix The value for namePrefix 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder namePrefix(String namePrefix) {
      checkNotIsSet(namePrefixIsSet(), "namePrefix");
      this.namePrefix = Objects.requireNonNull(namePrefix, "namePrefix");
      initBits &= ~INIT_BIT_NAME_PREFIX;
      return this;
    }

    /**
     * Initializes the value for the {@link ThreadFactoryProvider#logger() logger} attribute.
     * @param logger The value for logger 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder logger(Logger logger) {
      checkNotIsSet(loggerIsSet(), "logger");
      this.logger = Objects.requireNonNull(logger, "logger");
      initBits &= ~INIT_BIT_LOGGER;
      return this;
    }

    /**
     * Initializes the optional value {@link ThreadFactoryProvider#priority() priority} to priority.
     * @param priority The value for priority
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder priority(int priority) {
      checkNotIsSet(priorityIsSet(), "priority");
      this.priority = priority;
      optBits |= OPT_BIT_PRIORITY;
      return this;
    }

    /**
     * Initializes the optional value {@link ThreadFactoryProvider#priority() priority} to priority.
     * @param priority The value for priority
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder priority(Optional<Integer> priority) {
      checkNotIsSet(priorityIsSet(), "priority");
      this.priority = priority.orElse(null);
      optBits |= OPT_BIT_PRIORITY;
      return this;
    }

    /**
     * Initializes the value for the {@link ThreadFactoryProvider#daemon() daemon} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link ThreadFactoryProvider#daemon() daemon}.</em>
     * @param daemon The value for daemon 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder daemon(boolean daemon) {
      checkNotIsSet(daemonIsSet(), "daemon");
      this.daemon = daemon;
      optBits |= OPT_BIT_DAEMON;
      return this;
    }

    /**
     * Builds a new {@link ImmutableThreadFactoryProvider ImmutableThreadFactoryProvider}.
     * @return An immutable instance of ThreadFactoryProvider
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableThreadFactoryProvider build() {
      checkRequiredAttributes();
      return new ImmutableThreadFactoryProvider(this);
    }

    private boolean priorityIsSet() {
      return (optBits & OPT_BIT_PRIORITY) != 0;
    }

    private boolean daemonIsSet() {
      return (optBits & OPT_BIT_DAEMON) != 0;
    }

    private boolean namePrefixIsSet() {
      return (initBits & INIT_BIT_NAME_PREFIX) == 0;
    }

    private boolean loggerIsSet() {
      return (initBits & INIT_BIT_LOGGER) == 0;
    }

    private static void checkNotIsSet(boolean isSet, String name) {
      if (isSet) throw new IllegalStateException("Builder of ThreadFactoryProvider is strict, attribute is already set: ".concat(name));
    }

    private void checkRequiredAttributes() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if (!namePrefixIsSet()) attributes.add("namePrefix");
      if (!loggerIsSet()) attributes.add("logger");
      return "Cannot build ThreadFactoryProvider, some of required attributes are not set " + attributes;
    }
  }

  @Generated(from = "ThreadFactoryProvider", generator = "Immutables")
  public interface NamePrefixBuildStage {
    /**
     * Initializes the value for the {@link ThreadFactoryProvider#namePrefix() namePrefix} attribute.
     * @param namePrefix The value for namePrefix 
     * @return {@code this} builder for use in a chained invocation
     */
    LoggerBuildStage namePrefix(String namePrefix);
  }

  @Generated(from = "ThreadFactoryProvider", generator = "Immutables")
  public interface LoggerBuildStage {
    /**
     * Initializes the value for the {@link ThreadFactoryProvider#logger() logger} attribute.
     * @param logger The value for logger 
     * @return {@code this} builder for use in a chained invocation
     */
    BuildFinal logger(Logger logger);
  }

  @Generated(from = "ThreadFactoryProvider", generator = "Immutables")
  public interface BuildFinal {

    /**
     * Initializes the optional value {@link ThreadFactoryProvider#priority() priority} to priority.
     * @param priority The value for priority
     * @return {@code this} builder for chained invocation
     */
    BuildFinal priority(int priority);

    /**
     * Initializes the optional value {@link ThreadFactoryProvider#priority() priority} to priority.
     * @param priority The value for priority
     * @return {@code this} builder for use in a chained invocation
     */
    BuildFinal priority(Optional<Integer> priority);

    /**
     * Initializes the value for the {@link ThreadFactoryProvider#daemon() daemon} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link ThreadFactoryProvider#daemon() daemon}.</em>
     * @param daemon The value for daemon 
     * @return {@code this} builder for use in a chained invocation
     */
    BuildFinal daemon(boolean daemon);

    /**
     * Builds a new {@link ImmutableThreadFactoryProvider ImmutableThreadFactoryProvider}.
     * @return An immutable instance of ThreadFactoryProvider
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    ImmutableThreadFactoryProvider build();
  }
}
