/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.infrautils.inject.guice.testutils;

import com.google.inject.ConfigurationException;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.Stage;
import com.mycila.guice.ext.closeable.CloseableInjector;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.junit.rules.MethodRule;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.Statement;
import org.opendaylight.infrautils.inject.PostFullSystemInjectionListener;
import org.opendaylight.infrautils.inject.guice.testutils.AnnotationsModule;

public class GuiceRule
implements MethodRule {
    protected static final Stage DEFAULT_STAGE = Stage.PRODUCTION;
    protected final Iterable<? extends Module> modules;
    protected final Stage stage;
    protected Injector injector;

    public GuiceRule(Module ... modules) {
        this(DEFAULT_STAGE, modules);
    }

    protected GuiceRule(Stage stage, Module ... modules) {
        this.modules = Arrays.asList(modules);
        this.stage = stage;
    }

    @SafeVarargs
    public GuiceRule(Class<? extends Module> ... moduleClasses) {
        this.modules = GuiceRule.createModules(Arrays.asList(moduleClasses));
        this.stage = DEFAULT_STAGE;
    }

    private static Iterable<? extends Module> createModules(List<Class<? extends Module>> moduleClasses) {
        return moduleClasses.stream().map(klass -> {
            try {
                return (Module)klass.getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (IllegalArgumentException | ReflectiveOperationException | SecurityException e) {
                throw new IllegalArgumentException("newInstance() failed: " + klass.getName(), e);
            }
        }).collect(Collectors.toList());
    }

    public Statement apply(final Statement base, FrameworkMethod method, final Object target) {
        return new Statement(){

            public void evaluate() throws Throwable {
                try {
                    GuiceRule.this.setUpGuice(target);
                    base.evaluate();
                }
                finally {
                    GuiceRule.this.tearDownGuice();
                }
            }
        };
    }

    protected void setUpGuice(Object target) {
        this.injector = Guice.createInjector((Stage)this.stage, this.modules);
        this.injector.injectMembers(target);
        try {
            ((PostFullSystemInjectionListener)this.injector.getInstance(PostFullSystemInjectionListener.class)).onFullSystemInjected();
        }
        catch (ConfigurationException configurationException) {
            // empty catch block
        }
    }

    protected void tearDownGuice() {
        if (this.injector != null) {
            try {
                ((CloseableInjector)this.injector.getInstance(CloseableInjector.class)).close();
            }
            catch (ConfigurationException e) {
                throw new IllegalStateException("You forgot to either add GuiceRule(..., AnnotationsModule.class), or in your Module use an install(new AnnotationsModule()) with " + AnnotationsModule.class.getName(), e);
            }
        }
    }
}

