/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.infrautils.ready.karaf.internal;

import com.google.common.annotations.VisibleForTesting;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.karaf.bundle.core.BundleService;
import org.opendaylight.infrautils.ready.SystemReadyMonitor;
import org.opendaylight.infrautils.ready.SystemReadyMonitorMXBean;
import org.opendaylight.infrautils.ready.SystemState;
import org.opendaylight.infrautils.ready.spi.DelegatingSystemReadyMonitorMXBean;
import org.opendaylight.infrautils.ready.spi.SimpleSystemReadyMonitor;
import org.opendaylight.infrautils.utils.concurrent.ThreadFactoryProvider;
import org.opendaylight.odlparent.bundlestest.lib.SystemStateFailureException;
import org.opendaylight.odlparent.bundlestest.lib.TestBundleDiag;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.metatype.annotations.AttributeDefinition;
import org.osgi.service.metatype.annotations.Designate;
import org.osgi.service.metatype.annotations.ObjectClassDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true, service={SystemReadyMonitor.class}, configurationPid={"org.opendaylight.infrautils.ready"})
@Designate(ocd=Config.class)
public class KarafSystemReady
extends SimpleSystemReadyMonitor {
    private static final Logger LOG = LoggerFactory.getLogger(KarafSystemReady.class);
    private final ThreadFactory threadFactory = ThreadFactoryProvider.builder().namePrefix("SystemReadyService").logger(LOG).build().get();
    private final DelegatingSystemReadyMonitorMXBean mbean = new DelegatingSystemReadyMonitorMXBean((SystemReadyMonitorMXBean)this);
    private Config config;
    private TestBundleDiag testBundleDiag;
    @Reference
    BundleService bundleService = null;

    @Activate
    public void activate(BundleContext bundleContext, Config newConfig) {
        this.config = newConfig;
        this.mbean.registerMBean();
        this.testBundleDiag = new TestBundleDiag(bundleContext, this.bundleService);
        LOG.info("Now starting to provide full system readiness status updates (see TestBundleDiag's logs)...");
        this.threadFactory.newThread(this::runCheckBundleDiag).start();
    }

    @Deactivate
    void deactivate() {
        this.mbean.unregisterMBean();
    }

    @SuppressFBWarnings(value={"THROWS_METHOD_THROWS_RUNTIMEEXCEPTION"}, justification="Re-thrown")
    private void runCheckBundleDiag() {
        try {
            this.testBundleDiag.checkBundleDiagInfos((long)this.config.systemReadyTimeout(), TimeUnit.SECONDS, (timeInfo, bundleDiagInfos) -> LOG.info("checkBundleDiagInfos: Elapsed time {}s, remaining time {}s, {}", new Object[]{timeInfo.getElapsedTimeInMS() / 1000L, timeInfo.getRemainingTimeInMS() / 1000L, bundleDiagInfos.getSummaryText()}));
        }
        catch (SystemStateFailureException e) {
            LOG.error("Failed, some bundles did not start (SystemReadyListeners are not called)", (Throwable)e);
            this.setSystemState(SystemState.FAILURE);
            this.setSystemFailureCause(e);
        }
        catch (RuntimeException throwable) {
            LOG.error("Boot failed; not all SystemReadyListeners were not called, SystemState FAILURE", (Throwable)throwable);
            this.setSystemState(SystemState.FAILURE);
            this.setSystemFailureCause(throwable);
            throw throwable;
        }
        this.ready();
    }

    @VisibleForTesting
    DelegatingSystemReadyMonitorMXBean getMbean() {
        return this.mbean;
    }

    @ObjectClassDefinition
    public static @interface Config {
        @AttributeDefinition(name="system-ready-timeout-seconds")
        public int systemReadyTimeout() default 300;
    }
}

