/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.binding.api;

import com.google.common.collect.ClassToInstanceMap;
import com.google.common.collect.ImmutableClassToInstanceMap;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.mdsal.binding.api.BindingService;
import org.opendaylight.yangtools.binding.DataObjectIdentifier;
import org.opendaylight.yangtools.binding.Rpc;
import org.opendaylight.yangtools.concepts.Registration;

public interface RpcProviderService
extends BindingService {
    public @NonNull Registration registerRpcImplementation(Rpc<?, ?> var1);

    public @NonNull Registration registerRpcImplementation(Rpc<?, ?> var1, Set<DataObjectIdentifier<?>> var2);

    default public @NonNull Registration registerRpcImplementations(Rpc<?, ?> ... implementations) {
        return this.registerRpcImplementations(List.of(implementations));
    }

    default public @NonNull Registration registerRpcImplementations(Collection<Rpc<?, ?>> implementations) {
        return this.registerRpcImplementations((ClassToInstanceMap<Rpc<?, ?>>)RpcProviderService.indexImplementations(implementations));
    }

    default public @NonNull Registration registerRpcImplementations(Collection<Rpc<?, ?>> implementations, Set<DataObjectIdentifier<?>> paths) {
        return this.registerRpcImplementations((ClassToInstanceMap<Rpc<?, ?>>)RpcProviderService.indexImplementations(implementations), paths);
    }

    @Deprecated(since="13.0.1")
    public @NonNull Registration registerRpcImplementations(ClassToInstanceMap<Rpc<?, ?>> var1);

    @Deprecated(since="13.0.1")
    public @NonNull Registration registerRpcImplementations(ClassToInstanceMap<Rpc<?, ?>> var1, Set<DataObjectIdentifier<?>> var2);

    private static @NonNull ImmutableClassToInstanceMap<Rpc<?, ?>> indexImplementations(Collection<Rpc<?, ?>> impls) {
        ImmutableClassToInstanceMap.Builder builder = ImmutableClassToInstanceMap.builder();
        for (Rpc<?, ?> impl : impls) {
            builder.put(impl.implementedInterface(), impl);
        }
        return builder.build();
    }
}

