/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.binding.dom.adapter;

import com.google.common.util.concurrent.MoreExecutors;
import java.util.concurrent.ExecutorService;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.opendaylight.mdsal.binding.api.DataTreeCommitCohort;
import org.opendaylight.mdsal.binding.api.DataTreeIdentifier;
import org.opendaylight.mdsal.binding.dom.adapter.BindingDOMDataTreeCommitCohortRegistryAdapter;
import org.opendaylight.mdsal.binding.dom.adapter.test.util.BindingBrokerTestFactory;
import org.opendaylight.mdsal.binding.dom.adapter.test.util.BindingTestContext;
import org.opendaylight.mdsal.common.api.LogicalDatastoreType;
import org.opendaylight.mdsal.dom.api.DOMDataTreeCommitCohort;
import org.opendaylight.mdsal.dom.api.DOMDataTreeCommitCohortRegistration;
import org.opendaylight.mdsal.dom.api.DOMDataTreeCommitCohortRegistry;
import org.opendaylight.mdsal.dom.api.DOMDataTreeIdentifier;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.mdsal.test.binding.rev140701.Top;
import org.opendaylight.yangtools.concepts.ObjectRegistration;
import org.opendaylight.yangtools.yang.binding.InstanceIdentifier;

public class BindingDOMDataTreeCommitCohortRegistryAdapterTest {
    @Test
    public void basicTest() throws Exception {
        BindingBrokerTestFactory bindingBrokerTestFactory = new BindingBrokerTestFactory();
        bindingBrokerTestFactory.setExecutor((ExecutorService)MoreExecutors.newDirectExecutorService());
        BindingTestContext bindingTestContext = bindingBrokerTestFactory.getTestContext();
        bindingTestContext.start();
        DOMDataTreeCommitCohortRegistry cohortRegistry = (DOMDataTreeCommitCohortRegistry)Mockito.mock(DOMDataTreeCommitCohortRegistry.class);
        DOMDataTreeCommitCohortRegistration cohortRegistration = (DOMDataTreeCommitCohortRegistration)Mockito.mock(DOMDataTreeCommitCohortRegistration.class);
        ((DOMDataTreeCommitCohortRegistry)Mockito.doReturn((Object)cohortRegistration).when((Object)cohortRegistry)).registerCommitCohort((DOMDataTreeIdentifier)ArgumentMatchers.any(), (DOMDataTreeCommitCohort)ArgumentMatchers.any());
        ((DOMDataTreeCommitCohortRegistration)Mockito.doNothing().when((Object)cohortRegistration)).close();
        BindingDOMDataTreeCommitCohortRegistryAdapter registryAdapter = new BindingDOMDataTreeCommitCohortRegistryAdapter(bindingTestContext.getCodec(), cohortRegistry);
        DataTreeIdentifier dataTreeIdentifier = DataTreeIdentifier.create((LogicalDatastoreType)LogicalDatastoreType.CONFIGURATION, (InstanceIdentifier)InstanceIdentifier.create(Top.class));
        DataTreeCommitCohort dataTreeCommitCohort = (DataTreeCommitCohort)Mockito.mock(DataTreeCommitCohort.class);
        ObjectRegistration objectRegistration = registryAdapter.registerCommitCohort(dataTreeIdentifier, dataTreeCommitCohort);
        Assert.assertEquals((Object)dataTreeCommitCohort, (Object)objectRegistration.getInstance());
        objectRegistration.close();
        ((DOMDataTreeCommitCohortRegistration)Mockito.verify((Object)cohortRegistration)).close();
    }
}

