/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.binding.dom.adapter;

import com.google.common.util.concurrent.MoreExecutors;
import java.util.concurrent.ExecutorService;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.opendaylight.mdsal.binding.api.MountPointService;
import org.opendaylight.mdsal.binding.dom.adapter.AdapterContext;
import org.opendaylight.mdsal.binding.dom.adapter.BindingDOMMountPointListenerAdapter;
import org.opendaylight.mdsal.binding.dom.adapter.test.util.BindingBrokerTestFactory;
import org.opendaylight.mdsal.binding.dom.adapter.test.util.BindingTestContext;
import org.opendaylight.mdsal.dom.api.DOMMountPointListener;
import org.opendaylight.mdsal.dom.api.DOMMountPointService;
import org.opendaylight.yangtools.concepts.ListenerRegistration;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;

@RunWith(value=MockitoJUnitRunner.StrictStubs.class)
public class BindingDOMMountPointListenerAdapterTest {
    private BindingDOMMountPointListenerAdapter<?> bindingDOMMountPointListenerAdapter;
    private AdapterContext codec;
    @Mock
    private MountPointService.MountPointListener listener;
    @Mock
    private DOMMountPointService mountPointService;
    @Mock
    private ListenerRegistration<?> listenerRegistration;

    @Before
    public void setUp() throws Exception {
        BindingBrokerTestFactory testFactory = new BindingBrokerTestFactory();
        testFactory.setExecutor((ExecutorService)MoreExecutors.newDirectExecutorService());
        BindingTestContext testContext = testFactory.getTestContext();
        testContext.start();
        this.codec = testContext.getCodec();
        ((DOMMountPointService)Mockito.doReturn(this.listenerRegistration).when((Object)this.mountPointService)).registerProvisionListener((DOMMountPointListener)ArgumentMatchers.any());
        this.bindingDOMMountPointListenerAdapter = new BindingDOMMountPointListenerAdapter(this.listener, this.codec, this.mountPointService);
    }

    @Test
    public void basicTest() throws Exception {
        Assert.assertEquals((Object)this.listener, (Object)this.bindingDOMMountPointListenerAdapter.getInstance());
        this.bindingDOMMountPointListenerAdapter.close();
        ((ListenerRegistration)Mockito.verify(this.listenerRegistration)).close();
    }

    @Test
    public void onMountPointCreatedWithExceptionTest() throws Exception {
        Mockito.reset((Object[])new MountPointService.MountPointListener[]{this.listener});
        this.bindingDOMMountPointListenerAdapter.onMountPointCreated(YangInstanceIdentifier.empty());
        Mockito.verifyNoInteractions((Object[])new Object[]{this.listener});
    }

    @Test
    public void onMountPointRemovedWithExceptionTest() throws Exception {
        Mockito.reset((Object[])new MountPointService.MountPointListener[]{this.listener});
        this.bindingDOMMountPointListenerAdapter.onMountPointRemoved(YangInstanceIdentifier.empty());
        Mockito.verifyNoInteractions((Object[])new Object[]{this.listener});
    }
}

