/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.binding.dom.adapter;

import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.BiFunction;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnit;
import org.mockito.junit.MockitoRule;
import org.mockito.quality.Strictness;
import org.opendaylight.mdsal.binding.api.DataBroker;
import org.opendaylight.mdsal.binding.api.TransactionChain;
import org.opendaylight.mdsal.binding.api.TransactionChainListener;
import org.opendaylight.mdsal.binding.dom.adapter.AdapterContext;
import org.opendaylight.mdsal.binding.dom.adapter.BindingDOMAdapterLoader;
import org.opendaylight.mdsal.binding.dom.adapter.BindingDOMDataBrokerAdapter;
import org.opendaylight.mdsal.binding.dom.adapter.BindingDOMTransactionChainAdapter;
import org.opendaylight.mdsal.binding.dom.adapter.ConstantAdapterContext;
import org.opendaylight.mdsal.binding.dom.codec.spi.BindingDOMCodecServices;
import org.opendaylight.mdsal.dom.api.DOMDataTreeReadTransaction;
import org.opendaylight.mdsal.dom.api.DOMDataTreeReadWriteTransaction;
import org.opendaylight.mdsal.dom.api.DOMDataTreeWriteTransaction;
import org.opendaylight.mdsal.dom.api.DOMService;
import org.opendaylight.mdsal.dom.api.DOMTransactionChain;
import org.opendaylight.mdsal.dom.api.DOMTransactionChainListener;
import org.opendaylight.mdsal.dom.spi.PingPongMergingDOMDataBroker;

@RunWith(value=Parameterized.class)
public class BindingDOMTransactionChainAdapterTest {
    @Rule
    public MockitoRule rule = MockitoJUnit.rule().strictness(Strictness.STRICT_STUBS);
    private final TransactionChainType type;
    @Mock
    private PingPongMergingDOMDataBroker domService;
    @Mock
    private DOMTransactionChain transactionChain;
    @Mock
    private TransactionChainListener transactionChainListener;
    @Mock
    private BindingDOMCodecServices mockCodecRegistry;
    private BindingDOMTransactionChainAdapter bindingDOMTransactionChainAdapter;

    @Parameterized.Parameters
    public static Collection<Object[]> parameters() {
        return List.of(new Object[]{TransactionChainType.NORMAL}, new Object[]{TransactionChainType.MERGING});
    }

    public BindingDOMTransactionChainAdapterTest(TransactionChainType type) {
        this.type = Objects.requireNonNull(type);
    }

    @Before
    public void setUp() {
        ((PingPongMergingDOMDataBroker)Mockito.doCallRealMethod().when((Object)this.domService)).getExtensions();
        ((PingPongMergingDOMDataBroker)Mockito.doReturn((Object)this.transactionChain).when((Object)this.domService)).createTransactionChain((DOMTransactionChainListener)ArgumentMatchers.any());
        if (this.type == TransactionChainType.MERGING) {
            ((PingPongMergingDOMDataBroker)Mockito.doCallRealMethod().when((Object)this.domService)).createMergingTransactionChain((DOMTransactionChainListener)ArgumentMatchers.any());
        }
        BindingDOMAdapterLoader bindingDOMAdapterLoader = new BindingDOMAdapterLoader((AdapterContext)new ConstantAdapterContext(this.mockCodecRegistry)){

            protected DOMService getDelegate(Class<? extends DOMService> reqDeleg) {
                return BindingDOMTransactionChainAdapterTest.this.domService;
            }
        };
        BindingDOMDataBrokerAdapter bindingDOMDataBrokerAdapter = (BindingDOMDataBrokerAdapter)bindingDOMAdapterLoader.load(DataBroker.class).get();
        this.bindingDOMTransactionChainAdapter = (BindingDOMTransactionChainAdapter)this.type.apply(bindingDOMDataBrokerAdapter, this.transactionChainListener);
        Assert.assertNotNull((Object)this.bindingDOMTransactionChainAdapter.getDelegate());
    }

    static void mockReadWrite(DOMTransactionChain chain) {
        ((DOMTransactionChain)Mockito.doReturn((Object)Mockito.mock(DOMDataTreeReadWriteTransaction.class)).when((Object)chain)).newReadWriteTransaction();
    }

    @Test
    public void closeTest() {
        ((DOMTransactionChain)Mockito.doNothing().when((Object)this.transactionChain)).close();
        this.bindingDOMTransactionChainAdapter.close();
        ((DOMTransactionChain)Mockito.verify((Object)this.transactionChain)).close();
    }

    @Test
    public void readTransactionTest() throws Exception {
        this.type.mockRead(this.transactionChain);
        Assert.assertNotNull((Object)this.bindingDOMTransactionChainAdapter.newReadOnlyTransaction());
    }

    @Test
    public void writeTransactionTest() throws Exception {
        this.type.mockWrite(this.transactionChain);
        Assert.assertNotNull((Object)this.bindingDOMTransactionChainAdapter.newWriteOnlyTransaction());
    }

    @Test
    public void readWriteTransactionTest() throws Exception {
        BindingDOMTransactionChainAdapterTest.mockReadWrite(this.transactionChain);
        Assert.assertNotNull((Object)this.bindingDOMTransactionChainAdapter.newReadWriteTransaction());
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    static enum TransactionChainType implements BiFunction<DataBroker, TransactionChainListener, TransactionChain>
    {
        NORMAL{

            @Override
            public TransactionChain apply(DataBroker broker, TransactionChainListener listener) {
                return broker.createTransactionChain(listener);
            }

            @Override
            void mockRead(DOMTransactionChain chain) {
                ((DOMTransactionChain)Mockito.doReturn((Object)Mockito.mock(DOMDataTreeReadTransaction.class)).when((Object)chain)).newReadOnlyTransaction();
            }

            @Override
            void mockWrite(DOMTransactionChain chain) {
                ((DOMTransactionChain)Mockito.doReturn((Object)Mockito.mock(DOMDataTreeWriteTransaction.class)).when((Object)chain)).newWriteOnlyTransaction();
            }
        }
        ,
        MERGING{

            @Override
            public TransactionChain apply(DataBroker broker, TransactionChainListener listener) {
                return broker.createMergingTransactionChain(listener);
            }

            @Override
            void mockRead(DOMTransactionChain chain) {
                BindingDOMTransactionChainAdapterTest.mockReadWrite(chain);
            }

            @Override
            void mockWrite(DOMTransactionChain chain) {
                BindingDOMTransactionChainAdapterTest.mockReadWrite(chain);
            }
        };


        abstract void mockRead(DOMTransactionChain var1);

        abstract void mockWrite(DOMTransactionChain var1);
    }
}

