/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.binding.dom.adapter;

import com.google.common.collect.ImmutableSet;
import java.util.Set;
import org.junit.Test;
import org.opendaylight.mdsal.binding.api.WriteTransaction;
import org.opendaylight.mdsal.binding.dom.adapter.test.AbstractDataTreeChangeListenerTest;
import org.opendaylight.mdsal.binding.spec.reflect.BindingReflections;
import org.opendaylight.mdsal.binding.test.model.util.ListsBindingUtils;
import org.opendaylight.mdsal.common.api.LogicalDatastoreType;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.mdsal.test.augment.rev140709.TreeComplexUsesAugment;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.mdsal.test.augment.rev140709.TreeComplexUsesAugmentBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.mdsal.test.augment.rev140709.complex.from.grouping.ContainerWithUsesBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.mdsal.test.binding.rev140701.Top;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.mdsal.test.binding.rev140701.TopBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.mdsal.test.binding.rev140701.two.level.list.TopLevelList;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.mdsal.test.binding.rev140701.two.level.list.TopLevelListKey;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.binding.Identifier;
import org.opendaylight.yangtools.yang.binding.InstanceIdentifier;
import org.opendaylight.yangtools.yang.binding.YangModuleInfo;

public class Bug1125RegressionTest
extends AbstractDataTreeChangeListenerTest {
    private static final InstanceIdentifier<Top> TOP_PATH = InstanceIdentifier.create(Top.class);
    private static final InstanceIdentifier<TopLevelList> TOP_FOO_PATH = TOP_PATH.child(TopLevelList.class, (Identifier)ListsBindingUtils.TOP_FOO_KEY);
    private static final InstanceIdentifier<TreeComplexUsesAugment> FOO_AUGMENT_PATH = TOP_FOO_PATH.augmentation(TreeComplexUsesAugment.class);
    private static final InstanceIdentifier<TreeComplexUsesAugment> WILDCARDED_AUGMENT_PATH = TOP_PATH.child(TopLevelList.class).augmentation(TreeComplexUsesAugment.class);

    @Override
    protected Set<YangModuleInfo> getModuleInfos() throws Exception {
        return ImmutableSet.of((Object)BindingReflections.getModuleInfo(Top.class), (Object)BindingReflections.getModuleInfo(TreeComplexUsesAugment.class));
    }

    @Test
    public void deleteAndListenAugment() {
        this.deleteAndListenAugment(TOP_PATH);
        this.deleteAndListenAugment(TOP_FOO_PATH);
        this.deleteAndListenAugment(FOO_AUGMENT_PATH);
    }

    private void deleteAndListenAugment(InstanceIdentifier<?> path) {
        TreeComplexUsesAugment augment = this.writeInitialState();
        AbstractDataTreeChangeListenerTest.TestListener<TreeComplexUsesAugment> listener = this.createListener(LogicalDatastoreType.OPERATIONAL, WILDCARDED_AUGMENT_PATH, Bug1125RegressionTest.added(FOO_AUGMENT_PATH, augment), Bug1125RegressionTest.deleted(FOO_AUGMENT_PATH, augment));
        WriteTransaction tx = this.getDataBroker().newWriteOnlyTransaction();
        tx.delete(LogicalDatastoreType.OPERATIONAL, path);
        Bug1125RegressionTest.assertCommit(tx.commit());
        listener.verify();
    }

    private TreeComplexUsesAugment writeInitialState() {
        WriteTransaction initialTx = this.getDataBroker().newWriteOnlyTransaction();
        initialTx.put(LogicalDatastoreType.OPERATIONAL, TOP_PATH, (DataObject)new TopBuilder().build());
        TreeComplexUsesAugment fooAugment = new TreeComplexUsesAugmentBuilder().setContainerWithUses(new ContainerWithUsesBuilder().setLeafFromGrouping("foo").build()).build();
        initialTx.put(LogicalDatastoreType.OPERATIONAL, ListsBindingUtils.path((TopLevelListKey)ListsBindingUtils.TOP_FOO_KEY), (DataObject)ListsBindingUtils.topLevelList((TopLevelListKey)ListsBindingUtils.TOP_FOO_KEY, (TreeComplexUsesAugment)fooAugment));
        Bug1125RegressionTest.assertCommit(initialTx.commit());
        return fooAugment;
    }
}

