/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.binding.dom.adapter;

import com.google.common.util.concurrent.ListenableFuture;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Map;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.Test;
import org.opendaylight.mdsal.binding.dom.adapter.CurrentAdapterSerializer;
import org.opendaylight.mdsal.binding.dom.codec.impl.BindingCodecContext;
import org.opendaylight.mdsal.binding.dom.codec.spi.BindingDOMCodecServices;
import org.opendaylight.mdsal.binding.generator.impl.DefaultBindingRuntimeGenerator;
import org.opendaylight.mdsal.binding.runtime.api.BindingRuntimeContext;
import org.opendaylight.mdsal.binding.runtime.api.DefaultBindingRuntimeContext;
import org.opendaylight.mdsal.binding.runtime.api.ModuleInfoSnapshot;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.binding.InstanceIdentifier;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.Uint16;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.ContainerNode;
import org.opendaylight.yangtools.yang.data.api.schema.DataContainerChild;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.data.impl.schema.Builders;
import org.opendaylight.yangtools.yang.model.api.EffectiveModelContext;
import org.opendaylight.yangtools.yang.model.repo.api.SourceIdentifier;
import org.opendaylight.yangtools.yang.model.repo.api.YangTextSchemaSource;
import org.opendaylight.yangtools.yang.test.util.YangParserTestUtils;

public class CurrentAdapterSerializerTest {
    @Test
    public void fromNormalizedNodeTest() throws Exception {
        EffectiveModelContext schemaCtx = YangParserTestUtils.parseYangResource((String)"/test.yang");
        ContainerNode data = CurrentAdapterSerializerTest.prepareData(schemaCtx, Uint16.valueOf((int)42));
        Map.Entry<InstanceIdentifier<?>, DataObject> fromNormalizedNode = CurrentAdapterSerializerTest.fromNormalizedNode((NormalizedNode)data, schemaCtx);
        DataObject value = fromNormalizedNode.getValue();
        Assert.assertNotNull((Object)value);
        Class iface = value.implementedInterface();
        Assert.assertEquals((Object)"Cont", (Object)iface.getSimpleName());
        Object[] objs = new Object[]{};
        Object invoked = iface.getDeclaredMethod("getVlanId", new Class[0]).invoke((Object)value, objs);
        Field declaredField = invoked.getClass().getDeclaredField("_id");
        declaredField.setAccessible(true);
        Object id = declaredField.get(invoked);
        Field val = id.getClass().getDeclaredField("_value");
        val.setAccessible(true);
        Assert.assertEquals((Object)Uint16.valueOf((int)42), (Object)val.get(id));
    }

    @Test
    public void fromNormalizedNodeWithAnotherInputDataTest() throws Exception {
        EffectiveModelContext schemaCtx = YangParserTestUtils.parseYangResource((String)"/test.yang");
        ContainerNode data = CurrentAdapterSerializerTest.prepareData(schemaCtx, "42");
        Map.Entry<InstanceIdentifier<?>, DataObject> fromNormalizedNode = CurrentAdapterSerializerTest.fromNormalizedNode((NormalizedNode)data, schemaCtx);
        DataObject value = fromNormalizedNode.getValue();
        Assert.assertNotNull((Object)value);
        Class iface = value.implementedInterface();
        Assert.assertEquals((Object)"Cont", (Object)iface.getSimpleName());
        Method getVlanId = iface.getDeclaredMethod("getVlanId", new Class[0]);
        InvocationTargetException ex = (InvocationTargetException)Assert.assertThrows(InvocationTargetException.class, () -> getVlanId.invoke((Object)value, new Object[0]));
        MatcherAssert.assertThat((Object)ex.getCause(), (Matcher)CoreMatchers.instanceOf(IllegalArgumentException.class));
    }

    private static ContainerNode prepareData(EffectiveModelContext schemaCtx, Object value) {
        return (ContainerNode)Builders.containerBuilder().withNodeIdentifier((YangInstanceIdentifier.PathArgument)new YangInstanceIdentifier.NodeIdentifier(QName.create((String)"urn:test", (String)"2017-01-01", (String)"cont"))).withChild((DataContainerChild)Builders.leafBuilder().withNodeIdentifier((YangInstanceIdentifier.PathArgument)new YangInstanceIdentifier.NodeIdentifier(QName.create((String)"urn:test", (String)"2017-01-01", (String)"vlan-id"))).withValue(value).build()).build();
    }

    private static Map.Entry<InstanceIdentifier<?>, DataObject> fromNormalizedNode(NormalizedNode data, EffectiveModelContext schemaCtx) {
        CurrentAdapterSerializer codec = new CurrentAdapterSerializer((BindingDOMCodecServices)new BindingCodecContext((BindingRuntimeContext)new DefaultBindingRuntimeContext(new DefaultBindingRuntimeGenerator().generateTypeMapping(schemaCtx), (ModuleInfoSnapshot)TestingModuleInfoSnapshot.INSTANCE)));
        YangInstanceIdentifier path = YangInstanceIdentifier.create((YangInstanceIdentifier.PathArgument)YangInstanceIdentifier.NodeIdentifier.create((QName)QName.create((String)"urn:test", (String)"2017-01-01", (String)"cont")));
        return codec.fromNormalizedNode(path, data);
    }

    private static final class TestingModuleInfoSnapshot
    implements ModuleInfoSnapshot {
        static final TestingModuleInfoSnapshot INSTANCE = new TestingModuleInfoSnapshot();

        private TestingModuleInfoSnapshot() {
        }

        public EffectiveModelContext getEffectiveModelContext() {
            throw new UnsupportedOperationException();
        }

        public ListenableFuture<? extends YangTextSchemaSource> getSource(SourceIdentifier sourceIdentifier) {
            throw new UnsupportedOperationException();
        }

        public <T> Class<T> loadClass(String fullyQualifiedName) throws ClassNotFoundException {
            return Class.forName(fullyQualifiedName);
        }
    }
}

